/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import com.aspose.psd.internal.bouncycastle.pqc.asn1.XMSSMTPrivateKey;
import com.aspose.psd.internal.bouncycastle.pqc.asn1.XMSSPrivateKey;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.aspose.psd.internal.bouncycastle.pqc.jcajce.interfaces.XMSSMTKey;
import com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss.a;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.PrivateKey;

public class BCXMSSMTPrivateKey
implements XMSSMTKey,
PrivateKey {
    private final ASN1ObjectIdentifier a;
    private final XMSSMTPrivateKeyParameters b;

    public BCXMSSMTPrivateKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters) {
        this.a = aSN1ObjectIdentifier;
        this.b = xMSSMTPrivateKeyParameters;
    }

    public BCXMSSMTPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        XMSSMTKeyParams xMSSMTKeyParams = XMSSMTKeyParams.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
        this.a = xMSSMTKeyParams.getTreeDigest().getAlgorithm();
        XMSSPrivateKey xMSSPrivateKey = XMSSPrivateKey.getInstance(privateKeyInfo.parsePrivateKey());
        try {
            XMSSMTPrivateKeyParameters.Builder builder = new XMSSMTPrivateKeyParameters.Builder(new XMSSMTParameters(xMSSMTKeyParams.getHeight(), xMSSMTKeyParams.getLayers(), com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss.a.a(this.a))).withIndex(xMSSPrivateKey.getIndex()).withSecretKeySeed(xMSSPrivateKey.getSecretKeySeed()).withSecretKeyPRF(xMSSPrivateKey.getSecretKeyPRF()).withPublicSeed(xMSSPrivateKey.getPublicSeed()).withRoot(xMSSPrivateKey.getRoot());
            if (xMSSPrivateKey.getBdsState() != null) {
                builder.withBDSState((BDSStateMap)XMSSUtil.deserialize(xMSSPrivateKey.getBdsState()));
            }
            this.b = builder.build();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("ClassNotFoundException processing BDS state: " + classNotFoundException.getMessage());
        }
    }

    @Override
    public String getAlgorithm() {
        return "XMSSMT";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss_mt, new XMSSMTKeyParams(this.b.getParameters().getHeight(), this.b.getParameters().getLayers(), new AlgorithmIdentifier(this.a)));
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, this.a());
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    CipherParameters getKeyParams() {
        return this.b;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCXMSSMTPrivateKey) {
            BCXMSSMTPrivateKey bCXMSSMTPrivateKey = (BCXMSSMTPrivateKey)object;
            return this.a.equals(bCXMSSMTPrivateKey.a) && Arrays.areEqual(this.b.toByteArray(), bCXMSSMTPrivateKey.b.toByteArray());
        }
        return false;
    }

    public int hashCode() {
        return this.a.hashCode() + 37 * Arrays.hashCode(this.b.toByteArray());
    }

    private XMSSMTPrivateKey a() {
        byte[] byArray = this.b.toByteArray();
        int n2 = this.b.getParameters().getDigestSize();
        int n3 = this.b.getParameters().getHeight();
        int n4 = (n3 + 7) / 8;
        int n5 = n2;
        int n6 = n2;
        int n7 = n2;
        int n8 = n2;
        int n9 = 0;
        int n10 = (int)XMSSUtil.bytesToXBigEndian(byArray, n9, n4);
        if (!XMSSUtil.isIndexValid(n3, n10)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        byte[] byArray2 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n4, n5);
        byte[] byArray3 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n5, n6);
        byte[] byArray4 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n6, n7);
        byte[] byArray5 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n7, n8);
        byte[] byArray6 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n8, byArray.length - n9);
        return new XMSSMTPrivateKey(n10, byArray2, byArray3, byArray4, byArray5, byArray6);
    }

    ASN1ObjectIdentifier getTreeDigestOID() {
        return this.a;
    }

    @Override
    public int getHeight() {
        return this.b.getParameters().getHeight();
    }

    @Override
    public int getLayers() {
        return this.b.getParameters().getLayers();
    }

    @Override
    public String getTreeDigest() {
        return com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss.a.b(this.a);
    }
}

