/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.rainbow;

import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.Digest;
import com.aspose.psd.internal.bouncycastle.crypto.digests.SHA224Digest;
import com.aspose.psd.internal.bouncycastle.crypto.digests.SHA256Digest;
import com.aspose.psd.internal.bouncycastle.crypto.digests.SHA384Digest;
import com.aspose.psd.internal.bouncycastle.crypto.digests.SHA512Digest;
import com.aspose.psd.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.rainbow.RainbowSigner;
import com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.rainbow.RainbowKeysToParams;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class SignatureSpi
extends java.security.SignatureSpi {
    private Digest a;
    private RainbowSigner b;
    private SecureRandom c;

    protected SignatureSpi(Digest digest, RainbowSigner rainbowSigner) {
        this.a = digest;
        this.b = rainbowSigner;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        AsymmetricKeyParameter asymmetricKeyParameter = RainbowKeysToParams.generatePublicKeyParameter(publicKey);
        this.a.reset();
        this.b.init(false, asymmetricKeyParameter);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.c = secureRandom;
        this.engineInitSign(privateKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        CipherParameters cipherParameters = RainbowKeysToParams.generatePrivateKeyParameter(privateKey);
        if (this.c != null) {
            cipherParameters = new ParametersWithRandom(cipherParameters, this.c);
        }
        this.a.reset();
        this.b.init(true, cipherParameters);
    }

    @Override
    protected void engineUpdate(byte by2) throws SignatureException {
        this.a.update(by2);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.a.update(byArray, n2, n3);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = new byte[this.a.getDigestSize()];
        this.a.doFinal(byArray, 0);
        try {
            byte[] byArray2 = this.b.generateSignature(byArray);
            return byArray2;
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2 = new byte[this.a.getDigestSize()];
        this.a.doFinal(byArray2, 0);
        return this.b.verifySignature(byArray2, byArray);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class withSha224
    extends SignatureSpi {
        public withSha224() {
            super(new SHA224Digest(), new RainbowSigner());
        }
    }

    public static class withSha256
    extends SignatureSpi {
        public withSha256() {
            super(new SHA256Digest(), new RainbowSigner());
        }
    }

    public static class withSha384
    extends SignatureSpi {
        public withSha384() {
            super(new SHA384Digest(), new RainbowSigner());
        }
    }

    public static class withSha512
    extends SignatureSpi {
        public withSha512() {
            super(new SHA512Digest(), new RainbowSigner());
        }
    }
}

