/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.mceliece;

import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.mceliece.McElieceCipher;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.mceliece.McElieceKeyParameters;
import com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.mceliece.McElieceKeysToParams;
import com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.util.AsymmetricBlockCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class McEliecePKCSCipherSpi
extends AsymmetricBlockCipher
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private McElieceCipher a;

    public McEliecePKCSCipherSpi(McElieceCipher mcElieceCipher) {
        this.a = mcElieceCipher;
    }

    @Override
    protected void initCipherEncrypt(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        CipherParameters cipherParameters = McElieceKeysToParams.generatePublicKeyParameter((PublicKey)key);
        cipherParameters = new ParametersWithRandom(cipherParameters, secureRandom);
        this.a.init(true, cipherParameters);
        this.maxPlainTextSize = this.a.maxPlainTextSize;
        this.cipherTextSize = this.a.cipherTextSize;
    }

    @Override
    protected void initCipherDecrypt(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AsymmetricKeyParameter asymmetricKeyParameter = McElieceKeysToParams.generatePrivateKeyParameter((PrivateKey)key);
        this.a.init(false, asymmetricKeyParameter);
        this.maxPlainTextSize = this.a.maxPlainTextSize;
        this.cipherTextSize = this.a.cipherTextSize;
    }

    @Override
    protected byte[] messageEncrypt(byte[] byArray) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = null;
        try {
            byArray2 = this.a.messageEncrypt(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray2;
    }

    @Override
    protected byte[] messageDecrypt(byte[] byArray) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = null;
        try {
            byArray2 = this.a.messageDecrypt(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray2;
    }

    @Override
    public String getName() {
        return "McEliecePKCS";
    }

    @Override
    public int getKeySize(Key key) throws InvalidKeyException {
        McElieceKeyParameters mcElieceKeyParameters = key instanceof PublicKey ? (McElieceKeyParameters)McElieceKeysToParams.generatePublicKeyParameter((PublicKey)key) : (McElieceKeyParameters)McElieceKeysToParams.generatePrivateKeyParameter((PrivateKey)key);
        return this.a.getKeySize(mcElieceKeyParameters);
    }

    public static class McEliecePKCS
    extends McEliecePKCSCipherSpi {
        public McEliecePKCS() {
            super(new McElieceCipher());
        }
    }
}

