/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss;

import com.aspose.psd.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.aspose.psd.internal.bouncycastle.crypto.KeyGenerationParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.BDS;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSKeyGenerationParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSNode;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import java.security.SecureRandom;

public final class XMSSKeyPairGenerator {
    private XMSSParameters a;
    private SecureRandom b;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        XMSSKeyGenerationParameters xMSSKeyGenerationParameters = (XMSSKeyGenerationParameters)keyGenerationParameters;
        this.b = xMSSKeyGenerationParameters.getRandom();
        this.a = xMSSKeyGenerationParameters.getParameters();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this.a(this.a, this.b);
        XMSSNode xMSSNode = xMSSPrivateKeyParameters.getBDSState().getRoot();
        xMSSPrivateKeyParameters = new XMSSPrivateKeyParameters.Builder(this.a).withSecretKeySeed(xMSSPrivateKeyParameters.getSecretKeySeed()).withSecretKeyPRF(xMSSPrivateKeyParameters.getSecretKeyPRF()).withPublicSeed(xMSSPrivateKeyParameters.getPublicSeed()).withRoot(xMSSNode.getValue()).withBDSState(xMSSPrivateKeyParameters.getBDSState()).build();
        XMSSPublicKeyParameters xMSSPublicKeyParameters = new XMSSPublicKeyParameters.Builder(this.a).withRoot(xMSSNode.getValue()).withPublicSeed(xMSSPrivateKeyParameters.getPublicSeed()).build();
        return new AsymmetricCipherKeyPair(xMSSPublicKeyParameters, xMSSPrivateKeyParameters);
    }

    private XMSSPrivateKeyParameters a(XMSSParameters xMSSParameters, SecureRandom secureRandom) {
        int n2 = xMSSParameters.getDigestSize();
        byte[] byArray = new byte[n2];
        secureRandom.nextBytes(byArray);
        byte[] byArray2 = new byte[n2];
        secureRandom.nextBytes(byArray2);
        byte[] byArray3 = new byte[n2];
        secureRandom.nextBytes(byArray3);
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = new XMSSPrivateKeyParameters.Builder(xMSSParameters).withSecretKeySeed(byArray).withSecretKeyPRF(byArray2).withPublicSeed(byArray3).withBDSState(new BDS(xMSSParameters, byArray3, byArray, (OTSHashAddress)new OTSHashAddress.Builder().build())).build();
        return xMSSPrivateKeyParameters;
    }
}

