/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pqc.asn1;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import com.aspose.psd.internal.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.aspose.psd.internal.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.aspose.psd.internal.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import java.math.BigInteger;

public class McEliecePrivateKey
extends ASN1Object {
    private int a;
    private int b;
    private byte[] c;
    private byte[] d;
    private byte[] e;
    private byte[] f;
    private byte[] g;

    public McEliecePrivateKey(int n2, int n3, GF2mField gF2mField, PolynomialGF2mSmallM polynomialGF2mSmallM, Permutation permutation, Permutation permutation2, GF2Matrix gF2Matrix) {
        this.a = n2;
        this.b = n3;
        this.c = gF2mField.getEncoded();
        this.d = polynomialGF2mSmallM.getEncoded();
        this.e = gF2Matrix.getEncoded();
        this.f = permutation.getEncoded();
        this.g = permutation2.getEncoded();
    }

    public static McEliecePrivateKey getInstance(Object object) {
        if (object instanceof McEliecePrivateKey) {
            return (McEliecePrivateKey)object;
        }
        if (object != null) {
            return new McEliecePrivateKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private McEliecePrivateKey(ASN1Sequence aSN1Sequence) {
        BigInteger bigInteger = ((ASN1Integer)aSN1Sequence.getObjectAt(0)).getValue();
        this.a = bigInteger.intValue();
        BigInteger bigInteger2 = ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getValue();
        this.b = bigInteger2.intValue();
        this.c = ((ASN1OctetString)aSN1Sequence.getObjectAt(2)).getOctets();
        this.d = ((ASN1OctetString)aSN1Sequence.getObjectAt(3)).getOctets();
        this.f = ((ASN1OctetString)aSN1Sequence.getObjectAt(4)).getOctets();
        this.g = ((ASN1OctetString)aSN1Sequence.getObjectAt(5)).getOctets();
        this.e = ((ASN1OctetString)aSN1Sequence.getObjectAt(6)).getOctets();
    }

    public int getN() {
        return this.a;
    }

    public int getK() {
        return this.b;
    }

    public GF2mField getField() {
        return new GF2mField(this.c);
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        return new PolynomialGF2mSmallM(this.getField(), this.d);
    }

    public GF2Matrix getSInv() {
        return new GF2Matrix(this.e);
    }

    public Permutation getP1() {
        return new Permutation(this.f);
    }

    public Permutation getP2() {
        return new Permutation(this.g);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.a));
        aSN1EncodableVector.add(new ASN1Integer(this.b));
        aSN1EncodableVector.add(new DEROctetString(this.c));
        aSN1EncodableVector.add(new DEROctetString(this.d));
        aSN1EncodableVector.add(new DEROctetString(this.f));
        aSN1EncodableVector.add(new DEROctetString(this.g));
        aSN1EncodableVector.add(new DEROctetString(this.e));
        return new DERSequence(aSN1EncodableVector);
    }
}

