/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pkcs;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.psd.internal.bouncycastle.asn1.DERBitString;
import com.aspose.psd.internal.bouncycastle.asn1.DERSet;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.Attribute;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.CertificationRequest;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import com.aspose.psd.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.psd.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.psd.internal.bouncycastle.operator.ContentSigner;
import com.aspose.psd.internal.bouncycastle.pkcs.PKCS10CertificationRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PKCS10CertificationRequestBuilder {
    private SubjectPublicKeyInfo a;
    private X500Name b;
    private List c = new ArrayList();
    private boolean d = false;

    public PKCS10CertificationRequestBuilder(PKCS10CertificationRequestBuilder pKCS10CertificationRequestBuilder) {
        this.a = pKCS10CertificationRequestBuilder.a;
        this.b = pKCS10CertificationRequestBuilder.b;
        this.d = pKCS10CertificationRequestBuilder.d;
        this.c = new ArrayList(pKCS10CertificationRequestBuilder.c);
    }

    public PKCS10CertificationRequestBuilder(X500Name x500Name, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.b = x500Name;
        this.a = subjectPublicKeyInfo;
    }

    public PKCS10CertificationRequestBuilder setAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        Iterator iterator = this.c.iterator();
        while (iterator.hasNext()) {
            if (!((Attribute)iterator.next()).getAttrType().equals(aSN1ObjectIdentifier)) continue;
            throw new IllegalStateException("Attribute " + aSN1ObjectIdentifier.toString() + " is already set");
        }
        this.addAttribute(aSN1ObjectIdentifier, aSN1Encodable);
        return this;
    }

    public PKCS10CertificationRequestBuilder setAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable[] aSN1EncodableArray) {
        Iterator iterator = this.c.iterator();
        while (iterator.hasNext()) {
            if (!((Attribute)iterator.next()).getAttrType().equals(aSN1ObjectIdentifier)) continue;
            throw new IllegalStateException("Attribute " + aSN1ObjectIdentifier.toString() + " is already set");
        }
        this.addAttribute(aSN1ObjectIdentifier, aSN1EncodableArray);
        return this;
    }

    public PKCS10CertificationRequestBuilder addAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.c.add(new Attribute(aSN1ObjectIdentifier, new DERSet(aSN1Encodable)));
        return this;
    }

    public PKCS10CertificationRequestBuilder addAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable[] aSN1EncodableArray) {
        this.c.add(new Attribute(aSN1ObjectIdentifier, new DERSet(aSN1EncodableArray)));
        return this;
    }

    public PKCS10CertificationRequestBuilder setLeaveOffEmptyAttributes(boolean bl2) {
        this.d = bl2;
        return this;
    }

    public PKCS10CertificationRequest build(ContentSigner contentSigner) {
        Object object;
        CertificationRequestInfo certificationRequestInfo;
        if (this.c.isEmpty()) {
            certificationRequestInfo = this.d ? new CertificationRequestInfo(this.b, this.a, null) : new CertificationRequestInfo(this.b, this.a, (ASN1Set)new DERSet());
        } else {
            object = new ASN1EncodableVector();
            Iterator iterator = this.c.iterator();
            while (iterator.hasNext()) {
                ((ASN1EncodableVector)object).add(Attribute.getInstance(iterator.next()));
            }
            certificationRequestInfo = new CertificationRequestInfo(this.b, this.a, (ASN1Set)new DERSet((ASN1EncodableVector)object));
        }
        try {
            object = contentSigner.getOutputStream();
            ((OutputStream)object).write(certificationRequestInfo.getEncoded("DER"));
            ((OutputStream)object).close();
            return new PKCS10CertificationRequest(new CertificationRequest(certificationRequestInfo, contentSigner.getAlgorithmIdentifier(), new DERBitString(contentSigner.getSignature())));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot produce certification request signature");
        }
    }
}

