/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.operator.jcajce;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.DERNull;
import com.aspose.psd.internal.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.aspose.psd.internal.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.aspose.psd.internal.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import com.aspose.psd.internal.bouncycastle.operator.GenericKey;
import com.aspose.psd.internal.bouncycastle.operator.OperatorException;
import com.aspose.psd.internal.bouncycastle.operator.SymmetricKeyWrapper;
import com.aspose.psd.internal.bouncycastle.operator.jcajce.h;
import com.aspose.psd.internal.bouncycastle.operator.jcajce.i;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class JceSymmetricKeyWrapper
extends SymmetricKeyWrapper {
    private h a = new h(new DefaultJcaJceHelper());
    private SecureRandom b;
    private SecretKey c;

    public JceSymmetricKeyWrapper(SecretKey secretKey) {
        super(JceSymmetricKeyWrapper.a(secretKey));
        this.c = secretKey;
    }

    public JceSymmetricKeyWrapper setProvider(Provider provider) {
        this.a = new h(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceSymmetricKeyWrapper setProvider(String string) {
        this.a = new h(new NamedJcaJceHelper(string));
        return this;
    }

    public JceSymmetricKeyWrapper setSecureRandom(SecureRandom secureRandom) {
        this.b = secureRandom;
        return this;
    }

    @Override
    public byte[] generateWrappedKey(GenericKey genericKey) throws OperatorException {
        Key key = i.a(genericKey);
        Cipher cipher = this.a.c(this.getAlgorithmIdentifier().getAlgorithm());
        try {
            cipher.init(3, (Key)this.c, this.b);
            return cipher.wrap(key);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new OperatorException("cannot wrap key: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    private static AlgorithmIdentifier a(SecretKey secretKey) {
        return JceSymmetricKeyWrapper.determineKeyEncAlg(secretKey.getAlgorithm(), secretKey.getEncoded().length * 8);
    }

    static AlgorithmIdentifier determineKeyEncAlg(String string, int n2) {
        if (string.startsWith("DES") || string.startsWith("TripleDES")) {
            return new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_CMS3DESwrap, DERNull.INSTANCE);
        }
        if (string.startsWith("RC2")) {
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.3.7"), new ASN1Integer(58L));
        }
        if (string.startsWith("AES")) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier;
            if (n2 == 128) {
                aSN1ObjectIdentifier = NISTObjectIdentifiers.id_aes128_wrap;
            } else if (n2 == 192) {
                aSN1ObjectIdentifier = NISTObjectIdentifiers.id_aes192_wrap;
            } else if (n2 == 256) {
                aSN1ObjectIdentifier = NISTObjectIdentifiers.id_aes256_wrap;
            } else {
                throw new IllegalArgumentException("illegal keysize in AES");
            }
            return new AlgorithmIdentifier(aSN1ObjectIdentifier);
        }
        if (string.startsWith("SEED")) {
            return new AlgorithmIdentifier(KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap);
        }
        if (string.startsWith("Camellia")) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier;
            if (n2 == 128) {
                aSN1ObjectIdentifier = NTTObjectIdentifiers.id_camellia128_wrap;
            } else if (n2 == 192) {
                aSN1ObjectIdentifier = NTTObjectIdentifiers.id_camellia192_wrap;
            } else if (n2 == 256) {
                aSN1ObjectIdentifier = NTTObjectIdentifiers.id_camellia256_wrap;
            } else {
                throw new IllegalArgumentException("illegal keysize in Camellia");
            }
            return new AlgorithmIdentifier(aSN1ObjectIdentifier);
        }
        throw new IllegalArgumentException("unknown algorithm");
    }
}

