/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.operator.jcajce;

import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.psd.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.psd.internal.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import com.aspose.psd.internal.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.aspose.psd.internal.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.aspose.psd.internal.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import com.aspose.psd.internal.bouncycastle.operator.ContentVerifier;
import com.aspose.psd.internal.bouncycastle.operator.ContentVerifierProvider;
import com.aspose.psd.internal.bouncycastle.operator.OperatorCreationException;
import com.aspose.psd.internal.bouncycastle.operator.OperatorStreamException;
import com.aspose.psd.internal.bouncycastle.operator.RawContentVerifier;
import com.aspose.psd.internal.bouncycastle.operator.RuntimeOperatorException;
import com.aspose.psd.internal.bouncycastle.operator.jcajce.h;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class JcaContentVerifierProviderBuilder {
    private h a = new h(new DefaultJcaJceHelper());

    public JcaContentVerifierProviderBuilder setProvider(Provider provider) {
        this.a = new h(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaContentVerifierProviderBuilder setProvider(String string) {
        this.a = new h(new NamedJcaJceHelper(string));
        return this;
    }

    public ContentVerifierProvider build(X509CertificateHolder x509CertificateHolder) throws OperatorCreationException, CertificateException {
        return this.build(this.a.a(x509CertificateHolder));
    }

    public ContentVerifierProvider build(X509Certificate x509Certificate) throws OperatorCreationException {
        JcaX509CertificateHolder jcaX509CertificateHolder;
        try {
            jcaX509CertificateHolder = new JcaX509CertificateHolder(x509Certificate);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new OperatorCreationException("cannot process certificate: " + certificateEncodingException.getMessage(), certificateEncodingException);
        }
        return new com.aspose.psd.internal.bouncycastle.operator.jcajce.b(this, jcaX509CertificateHolder, x509Certificate);
    }

    public ContentVerifierProvider build(PublicKey publicKey) throws OperatorCreationException {
        return new com.aspose.psd.internal.bouncycastle.operator.jcajce.c(this, publicKey);
    }

    public ContentVerifierProvider build(SubjectPublicKeyInfo subjectPublicKeyInfo) throws OperatorCreationException {
        return this.build(this.a.a(subjectPublicKeyInfo));
    }

    private c a(AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) throws OperatorCreationException {
        try {
            Signature signature = this.a.c(algorithmIdentifier);
            signature.initVerify(publicKey);
            return new c(signature);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new OperatorCreationException("exception on setup: " + generalSecurityException, generalSecurityException);
        }
    }

    private Signature b(AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) {
        Signature signature;
        try {
            signature = this.a.d(algorithmIdentifier);
            if (signature != null) {
                signature.initVerify(publicKey);
            }
        }
        catch (Exception exception) {
            signature = null;
        }
        return signature;
    }

    static /* synthetic */ h access$000(JcaContentVerifierProviderBuilder jcaContentVerifierProviderBuilder) {
        return jcaContentVerifierProviderBuilder.a;
    }

    static /* synthetic */ Signature access$100(JcaContentVerifierProviderBuilder jcaContentVerifierProviderBuilder, AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) {
        return jcaContentVerifierProviderBuilder.b(algorithmIdentifier, publicKey);
    }

    static /* synthetic */ c access$200(JcaContentVerifierProviderBuilder jcaContentVerifierProviderBuilder, AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) throws OperatorCreationException {
        return jcaContentVerifierProviderBuilder.a(algorithmIdentifier, publicKey);
    }

    private class a
    extends b
    implements RawContentVerifier {
        private Signature d;

        a(AlgorithmIdentifier algorithmIdentifier, c c2, Signature signature) {
            super(algorithmIdentifier, c2);
            this.d = signature;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean verify(byte[] byArray) {
            try {
                boolean bl2 = super.verify(byArray);
                return bl2;
            }
            finally {
                try {
                    this.d.verify(byArray);
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public boolean verify(byte[] byArray, byte[] byArray2) {
            try {
                this.d.update(byArray);
                boolean bl2 = this.d.verify(byArray2);
                return bl2;
            }
            catch (SignatureException signatureException) {
                throw new RuntimeOperatorException("exception obtaining raw signature: " + signatureException.getMessage(), signatureException);
            }
            finally {
                try {
                    this.b.a(byArray2);
                }
                catch (Exception exception) {}
            }
        }
    }

    private class b
    implements ContentVerifier {
        private AlgorithmIdentifier a;
        protected c b;

        b(AlgorithmIdentifier algorithmIdentifier, c c2) {
            this.a = algorithmIdentifier;
            this.b = c2;
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.a;
        }

        @Override
        public OutputStream getOutputStream() {
            if (this.b == null) {
                throw new IllegalStateException("verifier not initialised");
            }
            return this.b;
        }

        @Override
        public boolean verify(byte[] byArray) {
            try {
                return this.b.a(byArray);
            }
            catch (SignatureException signatureException) {
                throw new RuntimeOperatorException("exception obtaining signature: " + signatureException.getMessage(), signatureException);
            }
        }
    }

    private class c
    extends OutputStream {
        private Signature b;

        c(Signature signature) {
            this.b = signature;
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            try {
                this.b.update(byArray, n2, n3);
            }
            catch (SignatureException signatureException) {
                throw new OperatorStreamException("exception in content signer: " + signatureException.getMessage(), signatureException);
            }
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            try {
                this.b.update(byArray);
            }
            catch (SignatureException signatureException) {
                throw new OperatorStreamException("exception in content signer: " + signatureException.getMessage(), signatureException);
            }
        }

        @Override
        public void write(int n2) throws IOException {
            try {
                this.b.update((byte)n2);
            }
            catch (SignatureException signatureException) {
                throw new OperatorStreamException("exception in content signer: " + signatureException.getMessage(), signatureException);
            }
        }

        boolean a(byte[] byArray) throws SignatureException {
            return this.b.verify(byArray);
        }
    }
}

