/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.openssl;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.psd.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.psd.internal.bouncycastle.openssl.CertificateTrustBlock;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.io.IOException;

public class X509TrustedCertificateBlock {
    private final X509CertificateHolder a;
    private final CertificateTrustBlock b;

    public X509TrustedCertificateBlock(X509CertificateHolder x509CertificateHolder, CertificateTrustBlock certificateTrustBlock) {
        this.a = x509CertificateHolder;
        this.b = certificateTrustBlock;
    }

    public X509TrustedCertificateBlock(byte[] byArray) throws IOException {
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        this.a = new X509CertificateHolder(aSN1InputStream.readObject().getEncoded());
        this.b = new CertificateTrustBlock(aSN1InputStream.readObject().getEncoded());
    }

    public byte[] getEncoded() throws IOException {
        return Arrays.concatenate(this.a.getEncoded(), this.b.toASN1Sequence().getEncoded());
    }

    public X509CertificateHolder getCertificateHolder() {
        return this.a;
    }

    public CertificateTrustBlock getTrustBlock() {
        return this.b;
    }
}

