/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.openssl;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.cms.ContentInfo;
import com.aspose.psd.internal.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.aspose.psd.internal.bouncycastle.asn1.x509.DSAParameter;
import com.aspose.psd.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.psd.internal.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.cert.X509AttributeCertificateHolder;
import com.aspose.psd.internal.bouncycastle.cert.X509CRLHolder;
import com.aspose.psd.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.psd.internal.bouncycastle.openssl.PEMEncryptor;
import com.aspose.psd.internal.bouncycastle.openssl.X509TrustedCertificateBlock;
import com.aspose.psd.internal.bouncycastle.pkcs.PKCS10CertificationRequest;
import com.aspose.psd.internal.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import com.aspose.psd.internal.bouncycastle.util.Strings;
import com.aspose.psd.internal.bouncycastle.util.io.pem.PemGenerationException;
import com.aspose.psd.internal.bouncycastle.util.io.pem.PemHeader;
import com.aspose.psd.internal.bouncycastle.util.io.pem.PemObject;
import com.aspose.psd.internal.bouncycastle.util.io.pem.PemObjectGenerator;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class MiscPEMGenerator
implements PemObjectGenerator {
    private static final ASN1ObjectIdentifier[] a = new ASN1ObjectIdentifier[]{X9ObjectIdentifiers.id_dsa, OIWObjectIdentifiers.dsaWithSHA1};
    private static final byte[] b = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private final Object c;
    private final PEMEncryptor d;

    public MiscPEMGenerator(Object object) {
        this.c = object;
        this.d = null;
    }

    public MiscPEMGenerator(Object object, PEMEncryptor pEMEncryptor) {
        this.c = object;
        this.d = pEMEncryptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PemObject a(Object object) throws IOException {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        byte[] byArray;
        String string;
        if (object instanceof PemObject) {
            return (PemObject)object;
        }
        if (object instanceof PemObjectGenerator) {
            return ((PemObjectGenerator)object).generate();
        }
        if (object instanceof X509CertificateHolder) {
            string = "CERTIFICATE";
            byArray = ((X509CertificateHolder)object).getEncoded();
        } else if (object instanceof X509CRLHolder) {
            string = "X509 CRL";
            byArray = ((X509CRLHolder)object).getEncoded();
        } else if (object instanceof X509TrustedCertificateBlock) {
            string = "TRUSTED CERTIFICATE";
            byArray = ((X509TrustedCertificateBlock)object).getEncoded();
        } else if (object instanceof PrivateKeyInfo) {
            object5 = (PrivateKeyInfo)object;
            object4 = ((PrivateKeyInfo)object5).getPrivateKeyAlgorithm().getAlgorithm();
            if (((ASN1Primitive)object4).equals(PKCSObjectIdentifiers.rsaEncryption)) {
                string = "RSA PRIVATE KEY";
                byArray = ((PrivateKeyInfo)object5).parsePrivateKey().toASN1Primitive().getEncoded();
            } else if (((ASN1Primitive)object4).equals(a[0]) || ((ASN1Primitive)object4).equals(a[1])) {
                string = "DSA PRIVATE KEY";
                object3 = DSAParameter.getInstance(((PrivateKeyInfo)object5).getPrivateKeyAlgorithm().getParameters());
                object2 = new ASN1EncodableVector();
                ((ASN1EncodableVector)object2).add(new ASN1Integer(0L));
                ((ASN1EncodableVector)object2).add(new ASN1Integer(((DSAParameter)object3).getP()));
                ((ASN1EncodableVector)object2).add(new ASN1Integer(((DSAParameter)object3).getQ()));
                ((ASN1EncodableVector)object2).add(new ASN1Integer(((DSAParameter)object3).getG()));
                BigInteger bigInteger = ASN1Integer.getInstance(((PrivateKeyInfo)object5).parsePrivateKey()).getValue();
                BigInteger bigInteger2 = ((DSAParameter)object3).getG().modPow(bigInteger, ((DSAParameter)object3).getP());
                ((ASN1EncodableVector)object2).add(new ASN1Integer(bigInteger2));
                ((ASN1EncodableVector)object2).add(new ASN1Integer(bigInteger));
                byArray = new DERSequence((ASN1EncodableVector)object2).getEncoded();
            } else {
                if (!((ASN1Primitive)object4).equals(X9ObjectIdentifiers.id_ecPublicKey)) throw new IOException("Cannot identify private key");
                string = "EC PRIVATE KEY";
                byArray = ((PrivateKeyInfo)object5).parsePrivateKey().toASN1Primitive().getEncoded();
            }
        } else if (object instanceof SubjectPublicKeyInfo) {
            string = "PUBLIC KEY";
            byArray = ((SubjectPublicKeyInfo)object).getEncoded();
        } else if (object instanceof X509AttributeCertificateHolder) {
            string = "ATTRIBUTE CERTIFICATE";
            byArray = ((X509AttributeCertificateHolder)object).getEncoded();
        } else if (object instanceof PKCS10CertificationRequest) {
            string = "CERTIFICATE REQUEST";
            byArray = ((PKCS10CertificationRequest)object).getEncoded();
        } else if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
            string = "ENCRYPTED PRIVATE KEY";
            byArray = ((PKCS8EncryptedPrivateKeyInfo)object).getEncoded();
        } else {
            if (!(object instanceof ContentInfo)) throw new PemGenerationException("unknown object passed - can't encode.");
            string = "PKCS7";
            byArray = ((ContentInfo)object).getEncoded();
        }
        if (this.d == null) return new PemObject(string, byArray);
        object5 = Strings.toUpperCase(this.d.getAlgorithm());
        if (((String)object5).equals("DESEDE")) {
            object5 = "DES-EDE3-CBC";
        }
        object4 = this.d.getIV();
        object3 = this.d.encrypt(byArray);
        object2 = new ArrayList<PemHeader>(2);
        object2.add(new PemHeader("Proc-Type", "4,ENCRYPTED"));
        object2.add(new PemHeader("DEK-Info", (String)object5 + "," + this.a((byte[])object4)));
        return new PemObject(string, (List)object2, (byte[])object3);
    }

    private String a(byte[] byArray) throws IOException {
        char[] cArray = new char[byArray.length * 2];
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            cArray[2 * i2] = (char)b[n2 >>> 4];
            cArray[2 * i2 + 1] = (char)b[n2 & 0xF];
        }
        return new String(cArray);
    }

    @Override
    public PemObject generate() throws PemGenerationException {
        try {
            return this.a(this.c);
        }
        catch (IOException iOException) {
            throw new PemGenerationException("encoding exception: " + iOException.getMessage(), iOException);
        }
    }
}

