/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.jcajce.spec;

import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;

public class DHUParameterSpec
implements AlgorithmParameterSpec {
    private final PublicKey a;
    private final PrivateKey b;
    private final PublicKey c;
    private final byte[] d;

    public DHUParameterSpec(PublicKey publicKey, PrivateKey privateKey, PublicKey publicKey2, byte[] byArray) {
        this.a = publicKey;
        this.b = privateKey;
        this.c = publicKey2;
        this.d = Arrays.clone(byArray);
    }

    public DHUParameterSpec(PublicKey publicKey, PrivateKey privateKey, PublicKey publicKey2) {
        this(publicKey, privateKey, publicKey2, null);
    }

    public DHUParameterSpec(KeyPair keyPair, PublicKey publicKey, byte[] byArray) {
        this(keyPair.getPublic(), keyPair.getPrivate(), publicKey, byArray);
    }

    public DHUParameterSpec(PrivateKey privateKey, PublicKey publicKey, byte[] byArray) {
        this(null, privateKey, publicKey, byArray);
    }

    public DHUParameterSpec(KeyPair keyPair, PublicKey publicKey) {
        this(keyPair.getPublic(), keyPair.getPrivate(), publicKey, null);
    }

    public DHUParameterSpec(PrivateKey privateKey, PublicKey publicKey) {
        this(null, privateKey, publicKey, null);
    }

    public PrivateKey getEphemeralPrivateKey() {
        return this.b;
    }

    public PublicKey getEphemeralPublicKey() {
        return this.a;
    }

    public PublicKey getOtherPartyEphemeralKey() {
        return this.c;
    }

    public byte[] getUserKeyingMaterial() {
        return Arrays.clone(this.d);
    }
}

