/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.jcajce.provider.symmetric;

import com.aspose.psd.internal.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.crypto.BufferedBlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.CipherKeyGenerator;
import com.aspose.psd.internal.bouncycastle.crypto.engines.SerpentEngine;
import com.aspose.psd.internal.bouncycastle.crypto.engines.TnepresEngine;
import com.aspose.psd.internal.bouncycastle.crypto.engines.TwofishEngine;
import com.aspose.psd.internal.bouncycastle.crypto.generators.Poly1305KeyGenerator;
import com.aspose.psd.internal.bouncycastle.crypto.macs.GMac;
import com.aspose.psd.internal.bouncycastle.crypto.modes.CBCBlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.modes.CFBBlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.modes.GCMBlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.modes.OFBBlockCipher;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.symmetric.m;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.symmetric.n;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.symmetric.p;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;

public final class Serpent {
    private Serpent() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "Serpent IV";
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new SerpentEngine()), 128);
        }
    }

    public static class CFB
    extends BaseBlockCipher {
        public CFB() {
            super(new BufferedBlockCipher(new CFBBlockCipher(new SerpentEngine(), 128)), 128);
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new m());
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Serpent", 192, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends p {
        private static final String a = Serpent.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.Serpent", a + "$ECB");
            configurableProvider.addAlgorithm("KeyGenerator.Serpent", a + "$KeyGen");
            configurableProvider.addAlgorithm("AlgorithmParameters.Serpent", a + "$AlgParams");
            configurableProvider.addAlgorithm("Cipher.Tnepres", a + "$TECB");
            configurableProvider.addAlgorithm("KeyGenerator.Tnepres", a + "$TKeyGen");
            configurableProvider.addAlgorithm("AlgorithmParameters.Tnepres", a + "$TAlgParams");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_128_ECB, a + "$ECB");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_192_ECB, a + "$ECB");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_256_ECB, a + "$ECB");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_128_CBC, a + "$CBC");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_192_CBC, a + "$CBC");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_256_CBC, a + "$CBC");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_128_CFB, a + "$CFB");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_192_CFB, a + "$CFB");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_256_CFB, a + "$CFB");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_128_OFB, a + "$OFB");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_192_OFB, a + "$OFB");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_256_OFB, a + "$OFB");
            this.addGMacAlgorithm(configurableProvider, "SERPENT", a + "$SerpentGMAC", a + "$KeyGen");
            this.addGMacAlgorithm(configurableProvider, "TNEPRES", a + "$TSerpentGMAC", a + "$TKeyGen");
            this.addPoly1305Algorithm(configurableProvider, "SERPENT", a + "$Poly1305", a + "$Poly1305KeyGen");
        }
    }

    public static class OFB
    extends BaseBlockCipher {
        public OFB() {
            super(new BufferedBlockCipher(new OFBBlockCipher(new SerpentEngine(), 128)), 128);
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new com.aspose.psd.internal.bouncycastle.crypto.macs.Poly1305(new TwofishEngine()));
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-Serpent", 256, new Poly1305KeyGenerator());
        }
    }

    public static class SerpentGMAC
    extends BaseMac {
        public SerpentGMAC() {
            super(new GMac(new GCMBlockCipher(new SerpentEngine())));
        }
    }

    public static class TAlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "Tnepres IV";
        }
    }

    public static class TECB
    extends BaseBlockCipher {
        public TECB() {
            super(new n());
        }
    }

    public static class TKeyGen
    extends BaseKeyGenerator {
        public TKeyGen() {
            super("Tnepres", 192, new CipherKeyGenerator());
        }
    }

    public static class TSerpentGMAC
    extends BaseMac {
        public TSerpentGMAC() {
            super(new GMac(new GCMBlockCipher(new TnepresEngine())));
        }
    }
}

