/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.jcajce.provider.digest;

import com.aspose.psd.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.crypto.CipherKeyGenerator;
import com.aspose.psd.internal.bouncycastle.crypto.digests.SHA3Digest;
import com.aspose.psd.internal.bouncycastle.crypto.macs.HMac;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.digest.a;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class SHA3 {
    private SHA3() {
    }

    public static class Digest224
    extends DigestSHA3 {
        public Digest224() {
            super(224);
        }
    }

    public static class Digest256
    extends DigestSHA3 {
        public Digest256() {
            super(256);
        }
    }

    public static class Digest384
    extends DigestSHA3 {
        public Digest384() {
            super(384);
        }
    }

    public static class Digest512
    extends DigestSHA3 {
        public Digest512() {
            super(512);
        }
    }

    public static class DigestSHA3
    extends BCMessageDigest
    implements Cloneable {
        public DigestSHA3(int n2) {
            super(new SHA3Digest(n2));
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            BCMessageDigest bCMessageDigest = (BCMessageDigest)super.clone();
            bCMessageDigest.digest = new SHA3Digest((SHA3Digest)this.digest);
            return bCMessageDigest;
        }
    }

    public static class HashMac224
    extends HashMacSHA3 {
        public HashMac224() {
            super(224);
        }
    }

    public static class HashMac256
    extends HashMacSHA3 {
        public HashMac256() {
            super(256);
        }
    }

    public static class HashMac384
    extends HashMacSHA3 {
        public HashMac384() {
            super(384);
        }
    }

    public static class HashMac512
    extends HashMacSHA3 {
        public HashMac512() {
            super(512);
        }
    }

    public static class HashMacSHA3
    extends BaseMac {
        public HashMacSHA3(int n2) {
            super(new HMac(new SHA3Digest(n2)));
        }
    }

    public static class KeyGenerator224
    extends KeyGeneratorSHA3 {
        public KeyGenerator224() {
            super(224);
        }
    }

    public static class KeyGenerator256
    extends KeyGeneratorSHA3 {
        public KeyGenerator256() {
            super(256);
        }
    }

    public static class KeyGenerator384
    extends KeyGeneratorSHA3 {
        public KeyGenerator384() {
            super(384);
        }
    }

    public static class KeyGenerator512
    extends KeyGeneratorSHA3 {
        public KeyGenerator512() {
            super(512);
        }
    }

    public static class KeyGeneratorSHA3
    extends BaseKeyGenerator {
        public KeyGeneratorSHA3(int n2) {
            super("HMACSHA3-" + n2, n2, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends a {
        private static final String a = SHA3.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("MessageDigest.SHA3-224", a + "$Digest224");
            configurableProvider.addAlgorithm("MessageDigest.SHA3-256", a + "$Digest256");
            configurableProvider.addAlgorithm("MessageDigest.SHA3-384", a + "$Digest384");
            configurableProvider.addAlgorithm("MessageDigest.SHA3-512", a + "$Digest512");
            configurableProvider.addAlgorithm("MessageDigest", NISTObjectIdentifiers.id_sha3_224, a + "$Digest224");
            configurableProvider.addAlgorithm("MessageDigest", NISTObjectIdentifiers.id_sha3_256, a + "$Digest256");
            configurableProvider.addAlgorithm("MessageDigest", NISTObjectIdentifiers.id_sha3_384, a + "$Digest384");
            configurableProvider.addAlgorithm("MessageDigest", NISTObjectIdentifiers.id_sha3_512, a + "$Digest512");
            this.addHMACAlgorithm(configurableProvider, "SHA3-224", a + "$HashMac224", a + "$KeyGenerator224");
            this.addHMACAlias(configurableProvider, "SHA3-224", NISTObjectIdentifiers.id_hmacWithSHA3_224);
            this.addHMACAlgorithm(configurableProvider, "SHA3-256", a + "$HashMac256", a + "$KeyGenerator256");
            this.addHMACAlias(configurableProvider, "SHA3-256", NISTObjectIdentifiers.id_hmacWithSHA3_256);
            this.addHMACAlgorithm(configurableProvider, "SHA3-384", a + "$HashMac384", a + "$KeyGenerator384");
            this.addHMACAlias(configurableProvider, "SHA3-384", NISTObjectIdentifiers.id_hmacWithSHA3_384);
            this.addHMACAlgorithm(configurableProvider, "SHA3-512", a + "$HashMac512", a + "$KeyGenerator512");
            this.addHMACAlias(configurableProvider, "SHA3-512", NISTObjectIdentifiers.id_hmacWithSHA3_512);
        }
    }
}

