/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.rsa;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.DERNull;
import com.aspose.psd.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.x509.DigestInfo;
import com.aspose.psd.internal.bouncycastle.crypto.AsymmetricBlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.Digest;
import com.aspose.psd.internal.bouncycastle.crypto.digests.MD2Digest;
import com.aspose.psd.internal.bouncycastle.crypto.digests.MD4Digest;
import com.aspose.psd.internal.bouncycastle.crypto.digests.NullDigest;
import com.aspose.psd.internal.bouncycastle.crypto.digests.RIPEMD128Digest;
import com.aspose.psd.internal.bouncycastle.crypto.digests.RIPEMD160Digest;
import com.aspose.psd.internal.bouncycastle.crypto.digests.RIPEMD256Digest;
import com.aspose.psd.internal.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.aspose.psd.internal.bouncycastle.crypto.engines.RSABlindedEngine;
import com.aspose.psd.internal.bouncycastle.crypto.params.RSAKeyParameters;
import com.aspose.psd.internal.bouncycastle.crypto.util.DigestFactory;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.rsa.RSAUtil;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public class DigestSignatureSpi
extends SignatureSpi {
    private Digest a;
    private AsymmetricBlockCipher b;
    private AlgorithmIdentifier c;

    protected DigestSignatureSpi(Digest digest, AsymmetricBlockCipher asymmetricBlockCipher) {
        this.a = digest;
        this.b = asymmetricBlockCipher;
        this.c = null;
    }

    protected DigestSignatureSpi(ASN1ObjectIdentifier aSN1ObjectIdentifier, Digest digest, AsymmetricBlockCipher asymmetricBlockCipher) {
        this.a = digest;
        this.b = asymmetricBlockCipher;
        this.c = new AlgorithmIdentifier(aSN1ObjectIdentifier, DERNull.INSTANCE);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Supplied key (" + this.a(publicKey) + ") is not a RSAPublicKey instance");
        }
        RSAKeyParameters rSAKeyParameters = RSAUtil.generatePublicKeyParameter((RSAPublicKey)publicKey);
        this.a.reset();
        this.b.init(false, rSAKeyParameters);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key (" + this.a(privateKey) + ") is not a RSAPrivateKey instance");
        }
        RSAKeyParameters rSAKeyParameters = RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey);
        this.a.reset();
        this.b.init(true, rSAKeyParameters);
    }

    private String a(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName();
    }

    @Override
    protected void engineUpdate(byte by2) throws SignatureException {
        this.a.update(by2);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.a.update(byArray, n2, n3);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = new byte[this.a.getDigestSize()];
        this.a.doFinal(byArray, 0);
        try {
            byte[] byArray2 = this.a(byArray);
            return this.b.processBlock(byArray2, 0, byArray2.length);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SignatureException("key too small for signature type");
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2;
        byte[] byArray3;
        byte[] byArray4 = new byte[this.a.getDigestSize()];
        this.a.doFinal(byArray4, 0);
        try {
            byArray3 = this.b.processBlock(byArray, 0, byArray.length);
            byArray2 = this.a(byArray4);
        }
        catch (Exception exception) {
            return false;
        }
        if (byArray3.length == byArray2.length) {
            return Arrays.constantTimeAreEqual(byArray3, byArray2);
        }
        if (byArray3.length == byArray2.length - 2) {
            int n2;
            byArray2[1] = (byte)(byArray2[1] - 2);
            byArray2[3] = (byte)(byArray2[3] - 2);
            int n3 = 4 + byArray2[3];
            int n4 = n3 + 2;
            int n5 = 0;
            for (n2 = 0; n2 < byArray2.length - n4; ++n2) {
                n5 |= byArray3[n3 + n2] ^ byArray2[n4 + n2];
            }
            for (n2 = 0; n2 < n3; ++n2) {
                n5 |= byArray3[n2] ^ byArray2[n2];
            }
            return n5 == 0;
        }
        Arrays.constantTimeAreEqual(byArray2, byArray2);
        return false;
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String string) {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    private byte[] a(byte[] byArray) throws IOException {
        if (this.c == null) {
            return byArray;
        }
        DigestInfo digestInfo = new DigestInfo(this.c, byArray);
        return digestInfo.getEncoded("DER");
    }

    public static class MD2
    extends DigestSignatureSpi {
        public MD2() {
            super(PKCSObjectIdentifiers.md2, new MD2Digest(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class MD4
    extends DigestSignatureSpi {
        public MD4() {
            super(PKCSObjectIdentifiers.md4, new MD4Digest(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class MD5
    extends DigestSignatureSpi {
        public MD5() {
            super(PKCSObjectIdentifiers.md5, DigestFactory.createMD5(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class RIPEMD128
    extends DigestSignatureSpi {
        public RIPEMD128() {
            super(TeleTrusTObjectIdentifiers.ripemd128, new RIPEMD128Digest(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class RIPEMD160
    extends DigestSignatureSpi {
        public RIPEMD160() {
            super(TeleTrusTObjectIdentifiers.ripemd160, new RIPEMD160Digest(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class RIPEMD256
    extends DigestSignatureSpi {
        public RIPEMD256() {
            super(TeleTrusTObjectIdentifiers.ripemd256, new RIPEMD256Digest(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA1
    extends DigestSignatureSpi {
        public SHA1() {
            super(OIWObjectIdentifiers.idSHA1, DigestFactory.createSHA1(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA224
    extends DigestSignatureSpi {
        public SHA224() {
            super(NISTObjectIdentifiers.id_sha224, DigestFactory.createSHA224(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA256
    extends DigestSignatureSpi {
        public SHA256() {
            super(NISTObjectIdentifiers.id_sha256, DigestFactory.createSHA256(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA384
    extends DigestSignatureSpi {
        public SHA384() {
            super(NISTObjectIdentifiers.id_sha384, DigestFactory.createSHA384(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA3_224
    extends DigestSignatureSpi {
        public SHA3_224() {
            super(NISTObjectIdentifiers.id_sha3_224, DigestFactory.createSHA3_224(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA3_256
    extends DigestSignatureSpi {
        public SHA3_256() {
            super(NISTObjectIdentifiers.id_sha3_256, DigestFactory.createSHA3_256(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA3_384
    extends DigestSignatureSpi {
        public SHA3_384() {
            super(NISTObjectIdentifiers.id_sha3_384, DigestFactory.createSHA3_384(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA3_512
    extends DigestSignatureSpi {
        public SHA3_512() {
            super(NISTObjectIdentifiers.id_sha3_512, DigestFactory.createSHA3_512(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA512
    extends DigestSignatureSpi {
        public SHA512() {
            super(NISTObjectIdentifiers.id_sha512, DigestFactory.createSHA512(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA512_224
    extends DigestSignatureSpi {
        public SHA512_224() {
            super(NISTObjectIdentifiers.id_sha512_224, DigestFactory.createSHA512_224(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class SHA512_256
    extends DigestSignatureSpi {
        public SHA512_256() {
            super(NISTObjectIdentifiers.id_sha512_256, DigestFactory.createSHA512_256(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }

    public static class noneRSA
    extends DigestSignatureSpi {
        public noneRSA() {
            super(new NullDigest(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }
}

