/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.gost;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.psd.internal.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.psd.internal.bouncycastle.crypto.params.GOST3410PublicKeyParameters;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.aspose.psd.internal.bouncycastle.jce.interfaces.GOST3410Params;
import com.aspose.psd.internal.bouncycastle.jce.interfaces.GOST3410PublicKey;
import com.aspose.psd.internal.bouncycastle.jce.spec.GOST3410ParameterSpec;
import com.aspose.psd.internal.bouncycastle.jce.spec.GOST3410PublicKeyParameterSetSpec;
import com.aspose.psd.internal.bouncycastle.jce.spec.GOST3410PublicKeySpec;
import com.aspose.psd.internal.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;

public class BCGOST3410PublicKey
implements GOST3410PublicKey {
    static final long serialVersionUID = -6251023343619275990L;
    private BigInteger a;
    private transient GOST3410Params b;

    BCGOST3410PublicKey(GOST3410PublicKeySpec gOST3410PublicKeySpec) {
        this.a = gOST3410PublicKeySpec.getY();
        this.b = new GOST3410ParameterSpec(new GOST3410PublicKeyParameterSetSpec(gOST3410PublicKeySpec.getP(), gOST3410PublicKeySpec.getQ(), gOST3410PublicKeySpec.getA()));
    }

    BCGOST3410PublicKey(GOST3410PublicKey gOST3410PublicKey) {
        this.a = gOST3410PublicKey.getY();
        this.b = gOST3410PublicKey.getParameters();
    }

    BCGOST3410PublicKey(GOST3410PublicKeyParameters gOST3410PublicKeyParameters, GOST3410ParameterSpec gOST3410ParameterSpec) {
        this.a = gOST3410PublicKeyParameters.getY();
        this.b = gOST3410ParameterSpec;
    }

    BCGOST3410PublicKey(BigInteger bigInteger, GOST3410ParameterSpec gOST3410ParameterSpec) {
        this.a = bigInteger;
        this.b = gOST3410ParameterSpec;
    }

    BCGOST3410PublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters = new GOST3410PublicKeyAlgParameters((ASN1Sequence)subjectPublicKeyInfo.getAlgorithmId().getParameters());
        try {
            DEROctetString dEROctetString = (DEROctetString)subjectPublicKeyInfo.parsePublicKey();
            byte[] byArray = dEROctetString.getOctets();
            byte[] byArray2 = new byte[byArray.length];
            for (int i2 = 0; i2 != byArray.length; ++i2) {
                byArray2[i2] = byArray[byArray.length - 1 - i2];
            }
            this.a = new BigInteger(1, byArray2);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid info structure in GOST3410 public key");
        }
        this.b = GOST3410ParameterSpec.fromPublicKeyAlg(gOST3410PublicKeyAlgParameters);
    }

    @Override
    public String getAlgorithm() {
        return "GOST3410";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        byte[] byArray = this.getY().toByteArray();
        byte[] byArray2 = byArray[0] == 0 ? new byte[byArray.length - 1] : new byte[byArray.length];
        for (int i2 = 0; i2 != byArray2.length; ++i2) {
            byArray2[i2] = byArray[byArray.length - 1 - i2];
        }
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = this.b instanceof GOST3410ParameterSpec ? (this.b.getEncryptionParamSetOID() != null ? new SubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_94, new GOST3410PublicKeyAlgParameters(new ASN1ObjectIdentifier(this.b.getPublicKeyParamSetOID()), new ASN1ObjectIdentifier(this.b.getDigestParamSetOID()), new ASN1ObjectIdentifier(this.b.getEncryptionParamSetOID()))), new DEROctetString(byArray2)) : new SubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_94, new GOST3410PublicKeyAlgParameters(new ASN1ObjectIdentifier(this.b.getPublicKeyParamSetOID()), new ASN1ObjectIdentifier(this.b.getDigestParamSetOID()))), new DEROctetString(byArray2))) : new SubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_94), new DEROctetString(byArray2));
            return KeyUtil.getEncodedSubjectPublicKeyInfo(subjectPublicKeyInfo);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public GOST3410Params getParameters() {
        return this.b;
    }

    @Override
    public BigInteger getY() {
        return this.a;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Strings.lineSeparator();
        stringBuffer.append("GOST3410 Public Key").append(string);
        stringBuffer.append("            y: ").append(this.getY().toString(16)).append(string);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof BCGOST3410PublicKey) {
            BCGOST3410PublicKey bCGOST3410PublicKey = (BCGOST3410PublicKey)object;
            return this.a.equals(bCGOST3410PublicKey.a) && this.b.equals(bCGOST3410PublicKey.b);
        }
        return false;
    }

    public int hashCode() {
        return this.a.hashCode() ^ this.b.hashCode();
    }

    private void a(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        String string = (String)objectInputStream.readObject();
        if (string != null) {
            this.b = new GOST3410ParameterSpec(string, (String)objectInputStream.readObject(), (String)objectInputStream.readObject());
        } else {
            this.b = new GOST3410ParameterSpec(new GOST3410PublicKeyParameterSetSpec((BigInteger)objectInputStream.readObject(), (BigInteger)objectInputStream.readObject(), (BigInteger)objectInputStream.readObject()));
            objectInputStream.readObject();
            objectInputStream.readObject();
        }
    }

    private void a(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.b.getPublicKeyParamSetOID() != null) {
            objectOutputStream.writeObject(this.b.getPublicKeyParamSetOID());
            objectOutputStream.writeObject(this.b.getDigestParamSetOID());
            objectOutputStream.writeObject(this.b.getEncryptionParamSetOID());
        } else {
            objectOutputStream.writeObject(null);
            objectOutputStream.writeObject(this.b.getPublicKeyParameters().getP());
            objectOutputStream.writeObject(this.b.getPublicKeyParameters().getQ());
            objectOutputStream.writeObject(this.b.getPublicKeyParameters().getA());
            objectOutputStream.writeObject(this.b.getDigestParamSetOID());
            objectOutputStream.writeObject(this.b.getEncryptionParamSetOID());
        }
    }
}

