/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.dsa;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.x509.DSAParameter;
import com.aspose.psd.internal.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.dsa.DSAUtil;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import com.aspose.psd.internal.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import com.aspose.psd.internal.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.DSAPrivateKeySpec;
import java.util.Enumeration;

public class BCDSAPrivateKey
implements PKCS12BagAttributeCarrier,
DSAPrivateKey {
    private static final long a = -4677259546958385734L;
    private BigInteger b;
    private transient DSAParams c;
    private transient PKCS12BagAttributeCarrierImpl d = new PKCS12BagAttributeCarrierImpl();

    protected BCDSAPrivateKey() {
    }

    BCDSAPrivateKey(DSAPrivateKey dSAPrivateKey) {
        this.b = dSAPrivateKey.getX();
        this.c = dSAPrivateKey.getParams();
    }

    BCDSAPrivateKey(DSAPrivateKeySpec dSAPrivateKeySpec) {
        this.b = dSAPrivateKeySpec.getX();
        this.c = new DSAParameterSpec(dSAPrivateKeySpec.getP(), dSAPrivateKeySpec.getQ(), dSAPrivateKeySpec.getG());
    }

    public BCDSAPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        DSAParameter dSAParameter = DSAParameter.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
        ASN1Integer aSN1Integer = (ASN1Integer)privateKeyInfo.parsePrivateKey();
        this.b = aSN1Integer.getValue();
        this.c = new DSAParameterSpec(dSAParameter.getP(), dSAParameter.getQ(), dSAParameter.getG());
    }

    BCDSAPrivateKey(DSAPrivateKeyParameters dSAPrivateKeyParameters) {
        this.b = dSAPrivateKeyParameters.getX();
        this.c = new DSAParameterSpec(dSAPrivateKeyParameters.getParameters().getP(), dSAPrivateKeyParameters.getParameters().getQ(), dSAPrivateKeyParameters.getParameters().getG());
    }

    @Override
    public String getAlgorithm() {
        return "DSA";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        return KeyUtil.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, new DSAParameter(this.c.getP(), this.c.getQ(), this.c.getG()).toASN1Primitive()), new ASN1Integer(this.getX()));
    }

    @Override
    public DSAParams getParams() {
        return this.c;
    }

    @Override
    public BigInteger getX() {
        return this.b;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DSAPrivateKey)) {
            return false;
        }
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)object;
        return this.getX().equals(dSAPrivateKey.getX()) && this.getParams().getG().equals(dSAPrivateKey.getParams().getG()) && this.getParams().getP().equals(dSAPrivateKey.getParams().getP()) && this.getParams().getQ().equals(dSAPrivateKey.getParams().getQ());
    }

    public int hashCode() {
        return this.getX().hashCode() ^ this.getParams().getG().hashCode() ^ this.getParams().getP().hashCode() ^ this.getParams().getQ().hashCode();
    }

    @Override
    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.d.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    @Override
    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.d.getBagAttribute(aSN1ObjectIdentifier);
    }

    @Override
    public Enumeration getBagAttributeKeys() {
        return this.d.getBagAttributeKeys();
    }

    private void a(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.c = new DSAParameterSpec((BigInteger)objectInputStream.readObject(), (BigInteger)objectInputStream.readObject(), (BigInteger)objectInputStream.readObject());
        this.d = new PKCS12BagAttributeCarrierImpl();
    }

    private void a(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.c.getP());
        objectOutputStream.writeObject(this.c.getQ());
        objectOutputStream.writeObject(this.c.getG());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Strings.lineSeparator();
        BigInteger bigInteger = this.getParams().getG().modPow(this.b, this.getParams().getP());
        stringBuffer.append("DSA Private Key [").append(DSAUtil.generateKeyFingerprint(bigInteger, this.getParams())).append("]").append(string);
        stringBuffer.append("            y: ").append(bigInteger.toString(16)).append(string);
        return stringBuffer.toString();
    }
}

