/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.est;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.est.AttrOrOID;
import com.aspose.psd.internal.bouncycastle.asn1.est.CsrAttrs;
import com.aspose.psd.internal.bouncycastle.est.ESTException;
import com.aspose.psd.internal.bouncycastle.util.Encodable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;

public class CSRAttributesResponse
implements Encodable {
    private final CsrAttrs a;
    private final HashMap<ASN1ObjectIdentifier, AttrOrOID> b;

    public CSRAttributesResponse(byte[] byArray) throws ESTException {
        this(CSRAttributesResponse.a(byArray));
    }

    public CSRAttributesResponse(CsrAttrs csrAttrs) throws ESTException {
        this.a = csrAttrs;
        this.b = new HashMap(csrAttrs.size());
        AttrOrOID[] attrOrOIDArray = csrAttrs.getAttrOrOIDs();
        for (int i2 = 0; i2 != attrOrOIDArray.length; ++i2) {
            AttrOrOID attrOrOID = attrOrOIDArray[i2];
            if (attrOrOID.isOid()) {
                this.b.put(attrOrOID.getOid(), attrOrOID);
                continue;
            }
            this.b.put(attrOrOID.getAttribute().getAttrType(), attrOrOID);
        }
    }

    private static CsrAttrs a(byte[] byArray) throws ESTException {
        try {
            return CsrAttrs.getInstance(ASN1Primitive.fromByteArray(byArray));
        }
        catch (Exception exception) {
            throw new ESTException("malformed data: " + exception.getMessage(), exception);
        }
    }

    public boolean hasRequirement(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.b.containsKey(aSN1ObjectIdentifier);
    }

    public boolean isAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (this.b.containsKey(aSN1ObjectIdentifier)) {
            return !this.b.get(aSN1ObjectIdentifier).isOid();
        }
        return false;
    }

    public boolean isEmpty() {
        return this.a.size() == 0;
    }

    public Collection<ASN1ObjectIdentifier> getRequirements() {
        return this.b.keySet();
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.a.getEncoded();
    }
}

