/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.util;

import com.aspose.psd.internal.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.crypto.util.PBKDFConfig;
import com.aspose.psd.internal.bouncycastle.crypto.util.g;

public class ScryptConfig
extends PBKDFConfig {
    private final int a;
    private final int b;
    private final int c;
    private final int d;

    private ScryptConfig(Builder builder) {
        super(MiscObjectIdentifiers.id_scrypt);
        this.a = builder.a;
        this.b = builder.b;
        this.c = builder.c;
        this.d = builder.d;
    }

    public int getCostParameter() {
        return this.a;
    }

    public int getBlockSize() {
        return this.b;
    }

    public int getParallelizationParameter() {
        return this.c;
    }

    public int getSaltLength() {
        return this.d;
    }

    /* synthetic */ ScryptConfig(Builder builder, g g2) {
        this(builder);
    }

    public static class Builder {
        private final int a;
        private final int b;
        private final int c;
        private int d = 16;

        public Builder(int n2, int n3, int n4) {
            if (n2 <= 1 || !Builder.a(n2)) {
                throw new IllegalArgumentException("Cost parameter N must be > 1 and a power of 2");
            }
            this.a = n2;
            this.b = n3;
            this.c = n4;
        }

        public Builder withSaltLength(int n2) {
            this.d = n2;
            return this;
        }

        public ScryptConfig build() {
            return new ScryptConfig(this, null);
        }

        private static boolean a(int n2) {
            return (n2 & n2 - 1) == 0;
        }
    }
}

