/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.signers;

import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.DSA;
import com.aspose.psd.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.ECKeyParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.psd.internal.bouncycastle.math.ec.ECAlgorithms;
import com.aspose.psd.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.psd.internal.bouncycastle.math.ec.ECFieldElement;
import com.aspose.psd.internal.bouncycastle.math.ec.ECMultiplier;
import com.aspose.psd.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.psd.internal.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSTU4145Signer
implements DSA {
    private static final BigInteger a = BigInteger.valueOf(1L);
    private ECKeyParameters b;
    private SecureRandom c;

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (bl2) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.c = parametersWithRandom.getRandom();
                cipherParameters = parametersWithRandom.getParameters();
            } else {
                this.c = new SecureRandom();
            }
            this.b = (ECPrivateKeyParameters)cipherParameters;
        } else {
            this.b = (ECPublicKeyParameters)cipherParameters;
        }
    }

    @Override
    public BigInteger[] generateSignature(byte[] byArray) {
        BigInteger bigInteger;
        ECFieldElement eCFieldElement;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        ECFieldElement eCFieldElement2;
        ECDomainParameters eCDomainParameters = this.b.getParameters();
        ECCurve eCCurve = eCDomainParameters.getCurve();
        ECFieldElement eCFieldElement3 = DSTU4145Signer.a(eCCurve, byArray);
        if (eCFieldElement3.isZero()) {
            eCFieldElement3 = eCCurve.fromBigInteger(a);
        }
        BigInteger bigInteger4 = eCDomainParameters.getN();
        BigInteger bigInteger5 = ((ECPrivateKeyParameters)this.b).getD();
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        do {
            bigInteger3 = DSTU4145Signer.a(bigInteger4, this.c);
        } while ((eCFieldElement2 = eCMultiplier.multiply(eCDomainParameters.getG(), bigInteger3).normalize().getAffineXCoord()).isZero() || (bigInteger2 = DSTU4145Signer.a(bigInteger4, eCFieldElement = eCFieldElement3.multiply(eCFieldElement2))).signum() == 0 || (bigInteger = bigInteger2.multiply(bigInteger5).add(bigInteger3).mod(bigInteger4)).signum() == 0);
        return new BigInteger[]{bigInteger2, bigInteger};
    }

    @Override
    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        ECPoint eCPoint;
        if (bigInteger.signum() <= 0 || bigInteger2.signum() <= 0) {
            return false;
        }
        ECDomainParameters eCDomainParameters = this.b.getParameters();
        BigInteger bigInteger3 = eCDomainParameters.getN();
        if (bigInteger.compareTo(bigInteger3) >= 0 || bigInteger2.compareTo(bigInteger3) >= 0) {
            return false;
        }
        ECCurve eCCurve = eCDomainParameters.getCurve();
        ECFieldElement eCFieldElement = DSTU4145Signer.a(eCCurve, byArray);
        if (eCFieldElement.isZero()) {
            eCFieldElement = eCCurve.fromBigInteger(a);
        }
        if ((eCPoint = ECAlgorithms.sumOfTwoMultiplies(eCDomainParameters.getG(), bigInteger2, ((ECPublicKeyParameters)this.b).getQ(), bigInteger).normalize()).isInfinity()) {
            return false;
        }
        ECFieldElement eCFieldElement2 = eCFieldElement.multiply(eCPoint.getAffineXCoord());
        return DSTU4145Signer.a(bigInteger3, eCFieldElement2).compareTo(bigInteger) == 0;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    private static BigInteger a(BigInteger bigInteger, SecureRandom secureRandom) {
        return new BigInteger(bigInteger.bitLength() - 1, secureRandom);
    }

    private static ECFieldElement a(ECCurve eCCurve, byte[] byArray) {
        byte[] byArray2 = Arrays.reverse(byArray);
        return eCCurve.fromBigInteger(DSTU4145Signer.a(new BigInteger(1, byArray2), eCCurve.getFieldSize()));
    }

    private static BigInteger a(BigInteger bigInteger, ECFieldElement eCFieldElement) {
        return DSTU4145Signer.a(eCFieldElement.toBigInteger(), bigInteger.bitLength() - 1);
    }

    private static BigInteger a(BigInteger bigInteger, int n2) {
        if (bigInteger.bitLength() > n2) {
            bigInteger = bigInteger.mod(a.shiftLeft(n2));
        }
        return bigInteger;
    }
}

