/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.prng;

import com.aspose.psd.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.prng.EntropySource;

public class X931RNG {
    private static final long a = 32768L;
    private static final long b = 0x800000L;
    private static final int c = 4096;
    private static final int d = 262144;
    private final BlockCipher e;
    private final EntropySource f;
    private final byte[] g;
    private final byte[] h;
    private final byte[] i;
    private byte[] j;
    private long k = 1L;

    public X931RNG(BlockCipher blockCipher, byte[] byArray, EntropySource entropySource) {
        this.e = blockCipher;
        this.f = entropySource;
        this.g = new byte[blockCipher.getBlockSize()];
        System.arraycopy(byArray, 0, this.g, 0, this.g.length);
        this.h = new byte[blockCipher.getBlockSize()];
        this.i = new byte[blockCipher.getBlockSize()];
    }

    int generate(byte[] byArray, boolean bl2) {
        int n2;
        if (this.i.length == 8) {
            if (this.k > 32768L) {
                return -1;
            }
            if (X931RNG.a(byArray, 512)) {
                throw new IllegalArgumentException("Number of bits per request limited to 4096");
            }
        } else {
            if (this.k > 0x800000L) {
                return -1;
            }
            if (X931RNG.a(byArray, 32768)) {
                throw new IllegalArgumentException("Number of bits per request limited to 262144");
            }
        }
        if (bl2 || this.j == null) {
            this.j = this.f.getEntropy();
            if (this.j.length != this.e.getBlockSize()) {
                throw new IllegalStateException("Insufficient entropy returned");
            }
        }
        int n3 = byArray.length / this.i.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.e.processBlock(this.g, 0, this.h, 0);
            this.a(this.i, this.h, this.j);
            this.a(this.j, this.i, this.h);
            System.arraycopy(this.i, 0, byArray, n2 * this.i.length, this.i.length);
            this.a(this.g);
        }
        n2 = byArray.length - n3 * this.i.length;
        if (n2 > 0) {
            this.e.processBlock(this.g, 0, this.h, 0);
            this.a(this.i, this.h, this.j);
            this.a(this.j, this.i, this.h);
            System.arraycopy(this.i, 0, byArray, n3 * this.i.length, n2);
            this.a(this.g);
        }
        ++this.k;
        return byArray.length;
    }

    void reseed() {
        this.j = this.f.getEntropy();
        if (this.j.length != this.e.getBlockSize()) {
            throw new IllegalStateException("Insufficient entropy returned");
        }
        this.k = 1L;
    }

    EntropySource getEntropySource() {
        return this.f;
    }

    private void a(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            byArray[i2] = (byte)(byArray2[i2] ^ byArray3[i2]);
        }
        this.e.processBlock(byArray, 0, byArray, 0);
    }

    private void a(byte[] byArray) {
        int n2 = byArray.length - 1;
        while (n2 >= 0) {
            int n3 = n2--;
            byArray[n3] = (byte)(byArray[n3] + 1);
            if (byArray[n3] != 0) break;
        }
    }

    private static boolean a(byte[] byArray, int n2) {
        return byArray != null && byArray.length > n2;
    }
}

