/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.modes;

import com.aspose.psd.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.psd.internal.bouncycastle.crypto.StreamBlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithIV;

public class GOFBBlockCipher
extends StreamBlockCipher {
    private byte[] a;
    private byte[] b;
    private byte[] c;
    private int d;
    private final int e;
    private final BlockCipher f;
    boolean firstStep = true;
    int N3;
    int N4;
    static final int C1 = 0x1010104;
    static final int C2 = 0x1010101;

    public GOFBBlockCipher(BlockCipher blockCipher) {
        super(blockCipher);
        this.f = blockCipher;
        this.e = blockCipher.getBlockSize();
        if (this.e != 8) {
            throw new IllegalArgumentException("GCTR only for 64 bit block ciphers");
        }
        this.a = new byte[blockCipher.getBlockSize()];
        this.b = new byte[blockCipher.getBlockSize()];
        this.c = new byte[blockCipher.getBlockSize()];
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.firstStep = true;
        this.N3 = 0;
        this.N4 = 0;
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length < this.a.length) {
                System.arraycopy(byArray, 0, this.a, this.a.length - byArray.length, byArray.length);
                for (int i2 = 0; i2 < this.a.length - byArray.length; ++i2) {
                    this.a[i2] = 0;
                }
            } else {
                System.arraycopy(byArray, 0, this.a, 0, this.a.length);
            }
            this.reset();
            if (parametersWithIV.getParameters() != null) {
                this.f.init(true, parametersWithIV.getParameters());
            }
        } else {
            this.reset();
            if (cipherParameters != null) {
                this.f.init(true, cipherParameters);
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.f.getAlgorithmName() + "/GCTR";
    }

    @Override
    public int getBlockSize() {
        return this.e;
    }

    @Override
    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        this.processBytes(byArray, n2, this.e, byArray2, n3);
        return this.e;
    }

    @Override
    public void reset() {
        this.firstStep = true;
        this.N3 = 0;
        this.N4 = 0;
        System.arraycopy(this.a, 0, this.b, 0, this.a.length);
        this.d = 0;
        this.f.reset();
    }

    private int a(byte[] byArray, int n2) {
        return (byArray[n2 + 3] << 24 & 0xFF000000) + (byArray[n2 + 2] << 16 & 0xFF0000) + (byArray[n2 + 1] << 8 & 0xFF00) + (byArray[n2] & 0xFF);
    }

    private void a(int n2, byte[] byArray, int n3) {
        byArray[n3 + 3] = (byte)(n2 >>> 24);
        byArray[n3 + 2] = (byte)(n2 >>> 16);
        byArray[n3 + 1] = (byte)(n2 >>> 8);
        byArray[n3] = (byte)n2;
    }

    @Override
    protected byte calculateByte(byte by2) {
        if (this.d == 0) {
            if (this.firstStep) {
                this.firstStep = false;
                this.f.processBlock(this.b, 0, this.c, 0);
                this.N3 = this.a(this.c, 0);
                this.N4 = this.a(this.c, 4);
            }
            this.N3 += 0x1010101;
            this.N4 += 0x1010104;
            if (this.N4 < 0x1010104 && this.N4 > 0) {
                ++this.N4;
            }
            this.a(this.N3, this.b, 0);
            this.a(this.N4, this.b, 4);
            this.f.processBlock(this.b, 0, this.c, 0);
        }
        byte by3 = (byte)(this.c[this.d++] ^ by2);
        if (this.d == this.e) {
            this.d = 0;
            System.arraycopy(this.b, this.e, this.b, 0, this.b.length - this.e);
            System.arraycopy(this.c, 0, this.b, this.b.length - this.e, this.e);
        }
        return by3;
    }
}

