/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.modes;

import com.aspose.psd.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.psd.internal.bouncycastle.crypto.StreamBlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.psd.internal.bouncycastle.util.Arrays;

public class CFBBlockCipher
extends StreamBlockCipher {
    private byte[] a;
    private byte[] b;
    private byte[] c;
    private byte[] d;
    private int e;
    private BlockCipher f = null;
    private boolean g;
    private int h;

    public CFBBlockCipher(BlockCipher blockCipher, int n2) {
        super(blockCipher);
        this.f = blockCipher;
        this.e = n2 / 8;
        this.a = new byte[blockCipher.getBlockSize()];
        this.b = new byte[blockCipher.getBlockSize()];
        this.c = new byte[blockCipher.getBlockSize()];
        this.d = new byte[this.e];
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.g = bl2;
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length < this.a.length) {
                System.arraycopy(byArray, 0, this.a, this.a.length - byArray.length, byArray.length);
                for (int i2 = 0; i2 < this.a.length - byArray.length; ++i2) {
                    this.a[i2] = 0;
                }
            } else {
                System.arraycopy(byArray, 0, this.a, 0, this.a.length);
            }
            this.reset();
            if (parametersWithIV.getParameters() != null) {
                this.f.init(true, parametersWithIV.getParameters());
            }
        } else {
            this.reset();
            if (cipherParameters != null) {
                this.f.init(true, cipherParameters);
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.f.getAlgorithmName() + "/CFB" + this.e * 8;
    }

    @Override
    protected byte calculateByte(byte by2) throws DataLengthException, IllegalStateException {
        return this.g ? this.a(by2) : this.b(by2);
    }

    private byte a(byte by2) {
        if (this.h == 0) {
            this.f.processBlock(this.b, 0, this.c, 0);
        }
        byte by3 = (byte)(this.c[this.h] ^ by2);
        this.d[this.h++] = by3;
        if (this.h == this.e) {
            this.h = 0;
            System.arraycopy(this.b, this.e, this.b, 0, this.b.length - this.e);
            System.arraycopy(this.d, 0, this.b, this.b.length - this.e, this.e);
        }
        return by3;
    }

    private byte b(byte by2) {
        if (this.h == 0) {
            this.f.processBlock(this.b, 0, this.c, 0);
        }
        this.d[this.h] = by2;
        byte by3 = (byte)(this.c[this.h++] ^ by2);
        if (this.h == this.e) {
            this.h = 0;
            System.arraycopy(this.b, this.e, this.b, 0, this.b.length - this.e);
            System.arraycopy(this.d, 0, this.b, this.b.length - this.e, this.e);
        }
        return by3;
    }

    @Override
    public int getBlockSize() {
        return this.e;
    }

    @Override
    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        this.processBytes(byArray, n2, this.e, byArray2, n3);
        return this.e;
    }

    public int encryptBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        this.processBytes(byArray, n2, this.e, byArray2, n3);
        return this.e;
    }

    public int decryptBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        this.processBytes(byArray, n2, this.e, byArray2, n3);
        return this.e;
    }

    public byte[] getCurrentIV() {
        return Arrays.clone(this.b);
    }

    @Override
    public void reset() {
        System.arraycopy(this.a, 0, this.b, 0, this.a.length);
        Arrays.fill(this.d, (byte)0);
        this.h = 0;
        this.f.reset();
    }
}

