/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.macs;

import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.psd.internal.bouncycastle.crypto.Mac;
import com.aspose.psd.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithIV;

public class VMPCMac
implements Mac {
    private byte a;
    private byte b = 0;
    private byte[] c = null;
    private byte d = 0;
    private byte[] e;
    private byte[] f;
    private byte[] g;
    private byte h;
    private byte i;
    private byte j;
    private byte k;

    @Override
    public int doFinal(byte[] byArray, int n2) throws DataLengthException, IllegalStateException {
        int n3;
        int n4;
        for (n4 = 1; n4 < 25; ++n4) {
            this.d = this.c[this.d + this.c[this.b & 0xFF] & 0xFF];
            this.k = this.c[this.k + this.j + n4 & 0xFF];
            this.j = this.c[this.j + this.i + n4 & 0xFF];
            this.i = this.c[this.i + this.h + n4 & 0xFF];
            this.h = this.c[this.h + this.d + n4 & 0xFF];
            this.e[this.a & 0x1F] = (byte)(this.e[this.a & 0x1F] ^ this.h);
            this.e[this.a + 1 & 0x1F] = (byte)(this.e[this.a + 1 & 0x1F] ^ this.i);
            this.e[this.a + 2 & 0x1F] = (byte)(this.e[this.a + 2 & 0x1F] ^ this.j);
            this.e[this.a + 3 & 0x1F] = (byte)(this.e[this.a + 3 & 0x1F] ^ this.k);
            this.a = (byte)(this.a + 4 & 0x1F);
            n3 = this.c[this.b & 0xFF];
            this.c[this.b & 0xFF] = this.c[this.d & 0xFF];
            this.c[this.d & 0xFF] = n3;
            this.b = (byte)(this.b + 1 & 0xFF);
        }
        for (n4 = 0; n4 < 768; ++n4) {
            this.d = this.c[this.d + this.c[n4 & 0xFF] + this.e[n4 & 0x1F] & 0xFF];
            n3 = this.c[n4 & 0xFF];
            this.c[n4 & 0xFF] = this.c[this.d & 0xFF];
            this.c[this.d & 0xFF] = n3;
        }
        byte[] byArray2 = new byte[20];
        for (n3 = 0; n3 < 20; ++n3) {
            this.d = this.c[this.d + this.c[n3 & 0xFF] & 0xFF];
            byArray2[n3] = this.c[this.c[this.c[this.d & 0xFF] & 0xFF] + 1 & 0xFF];
            byte by2 = this.c[n3 & 0xFF];
            this.c[n3 & 0xFF] = this.c[this.d & 0xFF];
            this.c[this.d & 0xFF] = by2;
        }
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        this.reset();
        return byArray2.length;
    }

    @Override
    public String getAlgorithmName() {
        return "VMPC-MAC";
    }

    @Override
    public int getMacSize() {
        return 20;
    }

    @Override
    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("VMPC-MAC Init parameters must include an IV");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
        KeyParameter keyParameter = (KeyParameter)parametersWithIV.getParameters();
        if (!(parametersWithIV.getParameters() instanceof KeyParameter)) {
            throw new IllegalArgumentException("VMPC-MAC Init parameters must include a key");
        }
        this.f = parametersWithIV.getIV();
        if (this.f == null || this.f.length < 1 || this.f.length > 768) {
            throw new IllegalArgumentException("VMPC-MAC requires 1 to 768 bytes of IV");
        }
        this.g = keyParameter.getKey();
        this.reset();
    }

    private void a(byte[] byArray, byte[] byArray2) {
        byte by2;
        int n2;
        this.d = 0;
        this.c = new byte[256];
        for (n2 = 0; n2 < 256; ++n2) {
            this.c[n2] = (byte)n2;
        }
        for (n2 = 0; n2 < 768; ++n2) {
            this.d = this.c[this.d + this.c[n2 & 0xFF] + byArray[n2 % byArray.length] & 0xFF];
            by2 = this.c[n2 & 0xFF];
            this.c[n2 & 0xFF] = this.c[this.d & 0xFF];
            this.c[this.d & 0xFF] = by2;
        }
        for (n2 = 0; n2 < 768; ++n2) {
            this.d = this.c[this.d + this.c[n2 & 0xFF] + byArray2[n2 % byArray2.length] & 0xFF];
            by2 = this.c[n2 & 0xFF];
            this.c[n2 & 0xFF] = this.c[this.d & 0xFF];
            this.c[this.d & 0xFF] = by2;
        }
        this.b = 0;
    }

    @Override
    public void reset() {
        this.a(this.g, this.f);
        this.b = 0;
        this.k = 0;
        this.j = 0;
        this.i = 0;
        this.h = 0;
        this.a = 0;
        this.e = new byte[32];
        for (int i2 = 0; i2 < 32; ++i2) {
            this.e[i2] = 0;
        }
    }

    @Override
    public void update(byte by2) throws IllegalStateException {
        this.d = this.c[this.d + this.c[this.b & 0xFF] & 0xFF];
        byte by3 = (byte)(by2 ^ this.c[this.c[this.c[this.d & 0xFF] & 0xFF] + 1 & 0xFF]);
        this.k = this.c[this.k + this.j & 0xFF];
        this.j = this.c[this.j + this.i & 0xFF];
        this.i = this.c[this.i + this.h & 0xFF];
        this.h = this.c[this.h + this.d + by3 & 0xFF];
        this.e[this.a & 0x1F] = (byte)(this.e[this.a & 0x1F] ^ this.h);
        this.e[this.a + 1 & 0x1F] = (byte)(this.e[this.a + 1 & 0x1F] ^ this.i);
        this.e[this.a + 2 & 0x1F] = (byte)(this.e[this.a + 2 & 0x1F] ^ this.j);
        this.e[this.a + 3 & 0x1F] = (byte)(this.e[this.a + 3 & 0x1F] ^ this.k);
        this.a = (byte)(this.a + 4 & 0x1F);
        byte by4 = this.c[this.b & 0xFF];
        this.c[this.b & 0xFF] = this.c[this.d & 0xFF];
        this.c[this.d & 0xFF] = by4;
        this.b = (byte)(this.b + 1 & 0xFF);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) throws DataLengthException, IllegalStateException {
        if (n2 + n3 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            this.update(byArray[n2 + i2]);
        }
    }
}

