/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.macs;

import com.aspose.psd.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.psd.internal.bouncycastle.crypto.Mac;
import com.aspose.psd.internal.bouncycastle.crypto.OutputLengthException;
import com.aspose.psd.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.psd.internal.bouncycastle.util.Pack;

public class Poly1305
implements Mac {
    private static final int a = 16;
    private final BlockCipher b;
    private final byte[] c = new byte[1];
    private int d;
    private int e;
    private int f;
    private int g;
    private int h;
    private int i;
    private int j;
    private int k;
    private int l;
    private int m;
    private int n;
    private int o;
    private int p;
    private final byte[] q = new byte[16];
    private int r = 0;
    private int s;
    private int t;
    private int u;
    private int v;
    private int w;

    public Poly1305() {
        this.b = null;
    }

    public Poly1305(BlockCipher blockCipher) {
        if (blockCipher.getBlockSize() != 16) {
            throw new IllegalArgumentException("Poly1305 requires a 128 bit block cipher.");
        }
        this.b = blockCipher;
    }

    @Override
    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        CipherParameters cipherParameters2;
        byte[] byArray = null;
        if (this.b != null) {
            if (!(cipherParameters instanceof ParametersWithIV)) {
                throw new IllegalArgumentException("Poly1305 requires an IV when used with a block cipher.");
            }
            cipherParameters2 = (ParametersWithIV)cipherParameters;
            byArray = ((ParametersWithIV)cipherParameters2).getIV();
            cipherParameters = ((ParametersWithIV)cipherParameters2).getParameters();
        }
        if (!(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("Poly1305 requires a key.");
        }
        cipherParameters2 = (KeyParameter)cipherParameters;
        this.a(((KeyParameter)cipherParameters2).getKey(), byArray);
        this.reset();
    }

    private void a(byte[] byArray, byte[] byArray2) {
        int n2;
        byte[] byArray3;
        if (byArray.length != 32) {
            throw new IllegalArgumentException("Poly1305 key must be 256 bits.");
        }
        if (this.b != null && (byArray2 == null || byArray2.length != 16)) {
            throw new IllegalArgumentException("Poly1305 requires a 128 bit IV.");
        }
        int n3 = Pack.littleEndianToInt(byArray, 0);
        int n4 = Pack.littleEndianToInt(byArray, 4);
        int n5 = Pack.littleEndianToInt(byArray, 8);
        int n6 = Pack.littleEndianToInt(byArray, 12);
        this.d = n3 & 0x3FFFFFF;
        this.e = (n3 >>> 26 | n4 << 6) & 0x3FFFF03;
        this.f = (n4 >>> 20 | n5 << 12) & 0x3FFC0FF;
        this.g = (n5 >>> 14 | n6 << 18) & 0x3F03FFF;
        this.h = n6 >>> 8 & 0xFFFFF;
        this.i = this.e * 5;
        this.j = this.f * 5;
        this.k = this.g * 5;
        this.l = this.h * 5;
        if (this.b == null) {
            byArray3 = byArray;
            n2 = 16;
        } else {
            byArray3 = new byte[16];
            n2 = 0;
            this.b.init(true, new KeyParameter(byArray, 16, 16));
            this.b.processBlock(byArray2, 0, byArray3, 0);
        }
        this.m = Pack.littleEndianToInt(byArray3, n2 + 0);
        this.n = Pack.littleEndianToInt(byArray3, n2 + 4);
        this.o = Pack.littleEndianToInt(byArray3, n2 + 8);
        this.p = Pack.littleEndianToInt(byArray3, n2 + 12);
    }

    @Override
    public String getAlgorithmName() {
        return this.b == null ? "Poly1305" : "Poly1305-" + this.b.getAlgorithmName();
    }

    @Override
    public int getMacSize() {
        return 16;
    }

    @Override
    public void update(byte by2) throws IllegalStateException {
        this.c[0] = by2;
        this.update(this.c, 0, 1);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) throws DataLengthException, IllegalStateException {
        int n4 = 0;
        while (n3 > n4) {
            if (this.r == 16) {
                this.a();
                this.r = 0;
            }
            int n5 = Math.min(n3 - n4, 16 - this.r);
            System.arraycopy(byArray, n4 + n2, this.q, this.r, n5);
            n4 += n5;
            this.r += n5;
        }
    }

    private void a() {
        if (this.r < 16) {
            this.q[this.r] = 1;
            for (int i2 = this.r + 1; i2 < 16; ++i2) {
                this.q[i2] = 0;
            }
        }
        long l2 = 0xFFFFFFFFL & (long)Pack.littleEndianToInt(this.q, 0);
        long l3 = 0xFFFFFFFFL & (long)Pack.littleEndianToInt(this.q, 4);
        long l4 = 0xFFFFFFFFL & (long)Pack.littleEndianToInt(this.q, 8);
        long l5 = 0xFFFFFFFFL & (long)Pack.littleEndianToInt(this.q, 12);
        this.s = (int)((long)this.s + (l2 & 0x3FFFFFFL));
        this.t = (int)((long)this.t + ((l3 << 32 | l2) >>> 26 & 0x3FFFFFFL));
        this.u = (int)((long)this.u + ((l4 << 32 | l3) >>> 20 & 0x3FFFFFFL));
        this.v = (int)((long)this.v + ((l5 << 32 | l4) >>> 14 & 0x3FFFFFFL));
        this.w = (int)((long)this.w + (l5 >>> 8));
        if (this.r == 16) {
            this.w += 0x1000000;
        }
        long l6 = Poly1305.a(this.s, this.d) + Poly1305.a(this.t, this.l) + Poly1305.a(this.u, this.k) + Poly1305.a(this.v, this.j) + Poly1305.a(this.w, this.i);
        long l7 = Poly1305.a(this.s, this.e) + Poly1305.a(this.t, this.d) + Poly1305.a(this.u, this.l) + Poly1305.a(this.v, this.k) + Poly1305.a(this.w, this.j);
        long l8 = Poly1305.a(this.s, this.f) + Poly1305.a(this.t, this.e) + Poly1305.a(this.u, this.d) + Poly1305.a(this.v, this.l) + Poly1305.a(this.w, this.k);
        long l9 = Poly1305.a(this.s, this.g) + Poly1305.a(this.t, this.f) + Poly1305.a(this.u, this.e) + Poly1305.a(this.v, this.d) + Poly1305.a(this.w, this.l);
        long l10 = Poly1305.a(this.s, this.h) + Poly1305.a(this.t, this.g) + Poly1305.a(this.u, this.f) + Poly1305.a(this.v, this.e) + Poly1305.a(this.w, this.d);
        this.s = (int)l6 & 0x3FFFFFF;
        this.t = (int)(l7 += l6 >>> 26) & 0x3FFFFFF;
        this.u = (int)(l8 += l7 >>> 26) & 0x3FFFFFF;
        this.v = (int)(l9 += l8 >>> 26) & 0x3FFFFFF;
        this.w = (int)(l10 += l9 >>> 26) & 0x3FFFFFF;
        this.s += (int)(l10 >>> 26) * 5;
        this.t += this.s >>> 26;
        this.s &= 0x3FFFFFF;
    }

    @Override
    public int doFinal(byte[] byArray, int n2) throws DataLengthException, IllegalStateException {
        if (n2 + 16 > byArray.length) {
            throw new OutputLengthException("Output buffer is too short.");
        }
        if (this.r > 0) {
            this.a();
        }
        this.t += this.s >>> 26;
        this.s &= 0x3FFFFFF;
        this.u += this.t >>> 26;
        this.t &= 0x3FFFFFF;
        this.v += this.u >>> 26;
        this.u &= 0x3FFFFFF;
        this.w += this.v >>> 26;
        this.v &= 0x3FFFFFF;
        this.s += (this.w >>> 26) * 5;
        this.w &= 0x3FFFFFF;
        this.t += this.s >>> 26;
        this.s &= 0x3FFFFFF;
        int n3 = this.s + 5;
        int n4 = n3 >>> 26;
        n3 &= 0x3FFFFFF;
        int n5 = this.t + n4;
        n4 = n5 >>> 26;
        n5 &= 0x3FFFFFF;
        int n6 = this.u + n4;
        n4 = n6 >>> 26;
        n6 &= 0x3FFFFFF;
        int n7 = this.v + n4;
        n4 = n7 >>> 26;
        n7 &= 0x3FFFFFF;
        int n8 = this.w + n4 - 0x4000000;
        n4 = (n8 >>> 31) - 1;
        int n9 = ~n4;
        this.s = this.s & n9 | n3 & n4;
        this.t = this.t & n9 | n5 & n4;
        this.u = this.u & n9 | n6 & n4;
        this.v = this.v & n9 | n7 & n4;
        this.w = this.w & n9 | n8 & n4;
        long l2 = ((long)(this.s | this.t << 26) & 0xFFFFFFFFL) + (0xFFFFFFFFL & (long)this.m);
        long l3 = ((long)(this.t >>> 6 | this.u << 20) & 0xFFFFFFFFL) + (0xFFFFFFFFL & (long)this.n);
        long l4 = ((long)(this.u >>> 12 | this.v << 14) & 0xFFFFFFFFL) + (0xFFFFFFFFL & (long)this.o);
        long l5 = ((long)(this.v >>> 18 | this.w << 8) & 0xFFFFFFFFL) + (0xFFFFFFFFL & (long)this.p);
        Pack.intToLittleEndian((int)l2, byArray, n2);
        Pack.intToLittleEndian((int)(l3 += l2 >>> 32), byArray, n2 + 4);
        Pack.intToLittleEndian((int)(l4 += l3 >>> 32), byArray, n2 + 8);
        Pack.intToLittleEndian((int)(l5 += l4 >>> 32), byArray, n2 + 12);
        this.reset();
        return 16;
    }

    @Override
    public void reset() {
        this.r = 0;
        this.w = 0;
        this.v = 0;
        this.u = 0;
        this.t = 0;
        this.s = 0;
    }

    private static final long a(int n2, int n3) {
        return ((long)n2 & 0xFFFFFFFFL) * (long)n3;
    }
}

