/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.macs;

import com.aspose.psd.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.Mac;
import com.aspose.psd.internal.bouncycastle.crypto.engines.DESEngine;
import com.aspose.psd.internal.bouncycastle.crypto.modes.CBCBlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.paddings.BlockCipherPadding;
import com.aspose.psd.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithIV;

public class ISO9797Alg3Mac
implements Mac {
    private byte[] a;
    private byte[] b;
    private int c;
    private BlockCipher d;
    private BlockCipherPadding e;
    private int f;
    private KeyParameter g;
    private KeyParameter h;

    public ISO9797Alg3Mac(BlockCipher blockCipher) {
        this(blockCipher, blockCipher.getBlockSize() * 8, null);
    }

    public ISO9797Alg3Mac(BlockCipher blockCipher, BlockCipherPadding blockCipherPadding) {
        this(blockCipher, blockCipher.getBlockSize() * 8, blockCipherPadding);
    }

    public ISO9797Alg3Mac(BlockCipher blockCipher, int n2) {
        this(blockCipher, n2, null);
    }

    public ISO9797Alg3Mac(BlockCipher blockCipher, int n2, BlockCipherPadding blockCipherPadding) {
        if (n2 % 8 != 0) {
            throw new IllegalArgumentException("MAC size must be multiple of 8");
        }
        if (!(blockCipher instanceof DESEngine)) {
            throw new IllegalArgumentException("cipher must be instance of DESEngine");
        }
        this.d = new CBCBlockCipher(blockCipher);
        this.e = blockCipherPadding;
        this.f = n2 / 8;
        this.a = new byte[blockCipher.getBlockSize()];
        this.b = new byte[blockCipher.getBlockSize()];
        this.c = 0;
    }

    @Override
    public String getAlgorithmName() {
        return "ISO9797Alg3";
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        KeyParameter keyParameter;
        this.reset();
        if (!(cipherParameters instanceof KeyParameter) && !(cipherParameters instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("params must be an instance of KeyParameter or ParametersWithIV");
        }
        KeyParameter keyParameter2 = cipherParameters instanceof KeyParameter ? (KeyParameter)cipherParameters : (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
        byte[] byArray = keyParameter2.getKey();
        if (byArray.length == 16) {
            keyParameter = new KeyParameter(byArray, 0, 8);
            this.g = new KeyParameter(byArray, 8, 8);
            this.h = keyParameter;
        } else if (byArray.length == 24) {
            keyParameter = new KeyParameter(byArray, 0, 8);
            this.g = new KeyParameter(byArray, 8, 8);
            this.h = new KeyParameter(byArray, 16, 8);
        } else {
            throw new IllegalArgumentException("Key must be either 112 or 168 bit long");
        }
        if (cipherParameters instanceof ParametersWithIV) {
            this.d.init(true, new ParametersWithIV(keyParameter, ((ParametersWithIV)cipherParameters).getIV()));
        } else {
            this.d.init(true, keyParameter);
        }
    }

    @Override
    public int getMacSize() {
        return this.f;
    }

    @Override
    public void update(byte by2) {
        if (this.c == this.b.length) {
            this.d.processBlock(this.b, 0, this.a, 0);
            this.c = 0;
        }
        this.b[this.c++] = by2;
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n4 = this.d.getBlockSize();
        int n5 = 0;
        int n6 = n4 - this.c;
        if (n3 > n6) {
            System.arraycopy(byArray, n2, this.b, this.c, n6);
            n5 += this.d.processBlock(this.b, 0, this.a, 0);
            this.c = 0;
            n3 -= n6;
            n2 += n6;
            while (n3 > n4) {
                n5 += this.d.processBlock(byArray, n2, this.a, 0);
                n3 -= n4;
                n2 += n4;
            }
        }
        System.arraycopy(byArray, n2, this.b, this.c, n3);
        this.c += n3;
    }

    @Override
    public int doFinal(byte[] byArray, int n2) {
        int n3 = this.d.getBlockSize();
        if (this.e == null) {
            while (this.c < n3) {
                this.b[this.c] = 0;
                ++this.c;
            }
        } else {
            if (this.c == n3) {
                this.d.processBlock(this.b, 0, this.a, 0);
                this.c = 0;
            }
            this.e.addPadding(this.b, this.c);
        }
        this.d.processBlock(this.b, 0, this.a, 0);
        DESEngine dESEngine = new DESEngine();
        dESEngine.init(false, this.g);
        dESEngine.processBlock(this.a, 0, this.a, 0);
        dESEngine.init(true, this.h);
        dESEngine.processBlock(this.a, 0, this.a, 0);
        System.arraycopy(this.a, 0, byArray, n2, this.f);
        this.reset();
        return this.f;
    }

    @Override
    public void reset() {
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            this.b[i2] = 0;
        }
        this.c = 0;
        this.d.reset();
    }
}

