/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.agreement;

import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.Digest;
import com.aspose.psd.internal.bouncycastle.crypto.digests.SM3Digest;
import com.aspose.psd.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithID;
import com.aspose.psd.internal.bouncycastle.crypto.params.SM2KeyExchangePrivateParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.SM2KeyExchangePublicParameters;
import com.aspose.psd.internal.bouncycastle.math.ec.ECAlgorithms;
import com.aspose.psd.internal.bouncycastle.math.ec.ECFieldElement;
import com.aspose.psd.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import com.aspose.psd.internal.bouncycastle.util.Memoable;
import com.aspose.psd.internal.bouncycastle.util.Pack;
import java.math.BigInteger;

public class SM2KeyExchange {
    private final Digest a;
    private byte[] b;
    private ECPrivateKeyParameters c;
    private ECPoint d;
    private ECPoint e;
    private ECDomainParameters f;
    private int g;
    private ECPrivateKeyParameters h;
    private boolean i;

    public SM2KeyExchange() {
        this(new SM3Digest());
    }

    public SM2KeyExchange(Digest digest) {
        this.a = digest;
    }

    public void init(CipherParameters cipherParameters) {
        SM2KeyExchangePrivateParameters sM2KeyExchangePrivateParameters;
        if (cipherParameters instanceof ParametersWithID) {
            sM2KeyExchangePrivateParameters = (SM2KeyExchangePrivateParameters)((ParametersWithID)cipherParameters).getParameters();
            this.b = ((ParametersWithID)cipherParameters).getID();
        } else {
            sM2KeyExchangePrivateParameters = (SM2KeyExchangePrivateParameters)cipherParameters;
            this.b = new byte[0];
        }
        this.i = sM2KeyExchangePrivateParameters.isInitiator();
        this.c = sM2KeyExchangePrivateParameters.getStaticPrivateKey();
        this.h = sM2KeyExchangePrivateParameters.getEphemeralPrivateKey();
        this.f = this.c.getParameters();
        this.d = sM2KeyExchangePrivateParameters.getStaticPublicPoint();
        this.e = sM2KeyExchangePrivateParameters.getEphemeralPublicPoint();
        this.g = this.f.getCurve().getFieldSize() / 2 - 1;
    }

    public byte[] calculateKey(int n2, CipherParameters cipherParameters) {
        byte[] byArray;
        SM2KeyExchangePublicParameters sM2KeyExchangePublicParameters;
        if (cipherParameters instanceof ParametersWithID) {
            sM2KeyExchangePublicParameters = (SM2KeyExchangePublicParameters)((ParametersWithID)cipherParameters).getParameters();
            byArray = ((ParametersWithID)cipherParameters).getID();
        } else {
            sM2KeyExchangePublicParameters = (SM2KeyExchangePublicParameters)cipherParameters;
            byArray = new byte[]{};
        }
        byte[] byArray2 = this.a(this.a, this.b, this.d);
        byte[] byArray3 = this.a(this.a, byArray, sM2KeyExchangePublicParameters.getStaticPublicKey().getQ());
        ECPoint eCPoint = this.a(sM2KeyExchangePublicParameters);
        byte[] byArray4 = this.i ? this.a(eCPoint, byArray2, byArray3, n2) : this.a(eCPoint, byArray3, byArray2, n2);
        return byArray4;
    }

    public byte[][] calculateKeyWithConfirmation(int n2, byte[] byArray, CipherParameters cipherParameters) {
        byte[] byArray2;
        SM2KeyExchangePublicParameters sM2KeyExchangePublicParameters;
        if (cipherParameters instanceof ParametersWithID) {
            sM2KeyExchangePublicParameters = (SM2KeyExchangePublicParameters)((ParametersWithID)cipherParameters).getParameters();
            byArray2 = ((ParametersWithID)cipherParameters).getID();
        } else {
            sM2KeyExchangePublicParameters = (SM2KeyExchangePublicParameters)cipherParameters;
            byArray2 = new byte[]{};
        }
        if (this.i && byArray == null) {
            throw new IllegalArgumentException("if initiating, confirmationTag must be set");
        }
        byte[] byArray3 = this.a(this.a, this.b, this.d);
        byte[] byArray4 = this.a(this.a, byArray2, sM2KeyExchangePublicParameters.getStaticPublicKey().getQ());
        ECPoint eCPoint = this.a(sM2KeyExchangePublicParameters);
        if (this.i) {
            byte[] byArray5 = this.a(eCPoint, byArray3, byArray4, n2);
            byte[] byArray6 = this.a(this.a, eCPoint, byArray3, byArray4, this.e, sM2KeyExchangePublicParameters.getEphemeralPublicKey().getQ());
            byte[] byArray7 = this.a(this.a, eCPoint, byArray6);
            if (!Arrays.constantTimeAreEqual(byArray7, byArray)) {
                throw new IllegalStateException("confirmation tag mismatch");
            }
            return new byte[][]{byArray5, this.b(this.a, eCPoint, byArray6)};
        }
        byte[] byArray8 = this.a(eCPoint, byArray4, byArray3, n2);
        byte[] byArray9 = this.a(this.a, eCPoint, byArray4, byArray3, sM2KeyExchangePublicParameters.getEphemeralPublicKey().getQ(), this.e);
        return new byte[][]{byArray8, this.a(this.a, eCPoint, byArray9), this.b(this.a, eCPoint, byArray9)};
    }

    private ECPoint a(SM2KeyExchangePublicParameters sM2KeyExchangePublicParameters) {
        ECPoint eCPoint = sM2KeyExchangePublicParameters.getStaticPublicKey().getQ();
        ECPoint eCPoint2 = sM2KeyExchangePublicParameters.getEphemeralPublicKey().getQ();
        BigInteger bigInteger = this.a(this.e.getAffineXCoord().toBigInteger());
        BigInteger bigInteger2 = this.a(eCPoint2.getAffineXCoord().toBigInteger());
        BigInteger bigInteger3 = this.c.getD().add(bigInteger.multiply(this.h.getD()));
        BigInteger bigInteger4 = this.f.getH().multiply(bigInteger3).mod(this.f.getN());
        BigInteger bigInteger5 = bigInteger4.multiply(bigInteger2).mod(this.f.getN());
        return ECAlgorithms.sumOfTwoMultiplies(eCPoint, bigInteger4, eCPoint2, bigInteger5).normalize();
    }

    private byte[] a(ECPoint eCPoint, byte[] byArray, byte[] byArray2, int n2) {
        int n3 = this.a.getDigestSize();
        byte[] byArray3 = new byte[Math.max(4, n3)];
        byte[] byArray4 = new byte[(n2 + 7) / 8];
        int n4 = 0;
        Memoable memoable = null;
        Memoable memoable2 = null;
        if (this.a instanceof Memoable) {
            this.a(this.a, eCPoint.getAffineXCoord());
            this.a(this.a, eCPoint.getAffineYCoord());
            this.a.update(byArray, 0, byArray.length);
            this.a.update(byArray2, 0, byArray2.length);
            memoable = (Memoable)((Object)this.a);
            memoable2 = memoable.copy();
        }
        int n5 = 0;
        while (n4 < byArray4.length) {
            if (memoable != null) {
                memoable.reset(memoable2);
            } else {
                this.a(this.a, eCPoint.getAffineXCoord());
                this.a(this.a, eCPoint.getAffineYCoord());
                this.a.update(byArray, 0, byArray.length);
                this.a.update(byArray2, 0, byArray2.length);
            }
            Pack.intToBigEndian(++n5, byArray3, 0);
            this.a.update(byArray3, 0, 4);
            this.a.doFinal(byArray3, 0);
            int n6 = Math.min(n3, byArray4.length - n4);
            System.arraycopy(byArray3, 0, byArray4, n4, n6);
            n4 += n6;
        }
        return byArray4;
    }

    private BigInteger a(BigInteger bigInteger) {
        return bigInteger.and(BigInteger.valueOf(1L).shiftLeft(this.g).subtract(BigInteger.valueOf(1L))).setBit(this.g);
    }

    private byte[] a(Digest digest, ECPoint eCPoint, byte[] byArray) {
        digest.update((byte)2);
        this.a(digest, eCPoint.getAffineYCoord());
        digest.update(byArray, 0, byArray.length);
        return this.a();
    }

    private byte[] a(Digest digest, ECPoint eCPoint, byte[] byArray, byte[] byArray2, ECPoint eCPoint2, ECPoint eCPoint3) {
        this.a(digest, eCPoint.getAffineXCoord());
        digest.update(byArray, 0, byArray.length);
        digest.update(byArray2, 0, byArray2.length);
        this.a(digest, eCPoint2.getAffineXCoord());
        this.a(digest, eCPoint2.getAffineYCoord());
        this.a(digest, eCPoint3.getAffineXCoord());
        this.a(digest, eCPoint3.getAffineYCoord());
        return this.a();
    }

    private byte[] b(Digest digest, ECPoint eCPoint, byte[] byArray) {
        digest.update((byte)3);
        this.a(digest, eCPoint.getAffineYCoord());
        digest.update(byArray, 0, byArray.length);
        return this.a();
    }

    private byte[] a(Digest digest, byte[] byArray, ECPoint eCPoint) {
        this.a(digest, byArray);
        this.a(digest, this.f.getCurve().getA());
        this.a(digest, this.f.getCurve().getB());
        this.a(digest, this.f.getG().getAffineXCoord());
        this.a(digest, this.f.getG().getAffineYCoord());
        this.a(digest, eCPoint.getAffineXCoord());
        this.a(digest, eCPoint.getAffineYCoord());
        return this.a();
    }

    private void a(Digest digest, byte[] byArray) {
        int n2 = byArray.length * 8;
        digest.update((byte)(n2 >>> 8));
        digest.update((byte)n2);
        digest.update(byArray, 0, byArray.length);
    }

    private void a(Digest digest, ECFieldElement eCFieldElement) {
        byte[] byArray = eCFieldElement.getEncoded();
        digest.update(byArray, 0, byArray.length);
    }

    private byte[] a() {
        byte[] byArray = new byte[this.a.getDigestSize()];
        this.a.doFinal(byArray, 0);
        return byArray;
    }
}

