/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.cms.jcajce;

import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.cms.CMSException;
import com.aspose.psd.internal.bouncycastle.cms.KEKRecipient;
import com.aspose.psd.internal.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import com.aspose.psd.internal.bouncycastle.cms.jcajce.b;
import com.aspose.psd.internal.bouncycastle.cms.jcajce.w;
import com.aspose.psd.internal.bouncycastle.cms.jcajce.x;
import com.aspose.psd.internal.bouncycastle.operator.OperatorException;
import com.aspose.psd.internal.bouncycastle.operator.SymmetricKeyUnwrapper;
import java.security.Key;
import java.security.Provider;
import javax.crypto.SecretKey;

public abstract class JceKEKRecipient
implements KEKRecipient {
    private SecretKey a;
    protected EnvelopedDataHelper helper;
    protected EnvelopedDataHelper contentHelper;
    protected boolean validateKeySize;

    public JceKEKRecipient(SecretKey secretKey) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new b());
        this.validateKeySize = false;
        this.a = secretKey;
    }

    public JceKEKRecipient setProvider(Provider provider) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new x(provider));
        return this;
    }

    public JceKEKRecipient setProvider(String string) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new w(string));
        return this;
    }

    public JceKEKRecipient setContentProvider(Provider provider) {
        this.contentHelper = new EnvelopedDataHelper(new x(provider));
        return this;
    }

    public JceKEKRecipient setContentProvider(String string) {
        this.contentHelper = new EnvelopedDataHelper(new w(string));
        return this;
    }

    public JceKEKRecipient setKeySizeValidation(boolean bl2) {
        this.validateKeySize = bl2;
        return this;
    }

    protected Key extractSecretKey(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CMSException {
        SymmetricKeyUnwrapper symmetricKeyUnwrapper = this.helper.createSymmetricUnwrapper(algorithmIdentifier, this.a);
        try {
            Key key = this.helper.getJceKey(algorithmIdentifier2.getAlgorithm(), symmetricKeyUnwrapper.generateUnwrappedKey(algorithmIdentifier2, byArray));
            if (this.validateKeySize) {
                this.helper.keySizeCheck(algorithmIdentifier2, key);
            }
            return key;
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception unwrapping key: " + operatorException.getMessage(), operatorException);
        }
    }
}

