/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.cms;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.cms.PasswordRecipientInfo;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.cms.CMSAlgorithm;
import com.aspose.psd.internal.bouncycastle.cms.CMSException;
import com.aspose.psd.internal.bouncycastle.cms.PasswordRecipient;
import com.aspose.psd.internal.bouncycastle.cms.PasswordRecipientId;
import com.aspose.psd.internal.bouncycastle.cms.Recipient;
import com.aspose.psd.internal.bouncycastle.cms.RecipientInformation;
import com.aspose.psd.internal.bouncycastle.cms.RecipientOperator;
import com.aspose.psd.internal.bouncycastle.cms.a;
import com.aspose.psd.internal.bouncycastle.cms.l;
import com.aspose.psd.internal.bouncycastle.util.Integers;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PasswordRecipientInformation
extends RecipientInformation {
    static Map KEYSIZES = new HashMap();
    static Map BLOCKSIZES = new HashMap();
    private PasswordRecipientInfo a;

    PasswordRecipientInformation(PasswordRecipientInfo passwordRecipientInfo, AlgorithmIdentifier algorithmIdentifier, l l2, a a2) {
        super(passwordRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, l2, a2);
        this.a = passwordRecipientInfo;
        this.rid = new PasswordRecipientId();
    }

    public String getKeyDerivationAlgOID() {
        if (this.a.getKeyDerivationAlgorithm() != null) {
            return this.a.getKeyDerivationAlgorithm().getAlgorithm().getId();
        }
        return null;
    }

    public byte[] getKeyDerivationAlgParams() {
        try {
            ASN1Encodable aSN1Encodable;
            if (this.a.getKeyDerivationAlgorithm() != null && (aSN1Encodable = this.a.getKeyDerivationAlgorithm().getParameters()) != null) {
                return aSN1Encodable.toASN1Primitive().getEncoded();
            }
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    public AlgorithmIdentifier getKeyDerivationAlgorithm() {
        return this.a.getKeyDerivationAlgorithm();
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        PasswordRecipient passwordRecipient = (PasswordRecipient)recipient;
        AlgorithmIdentifier algorithmIdentifier = AlgorithmIdentifier.getInstance(this.a.getKeyEncryptionAlgorithm());
        AlgorithmIdentifier algorithmIdentifier2 = AlgorithmIdentifier.getInstance(algorithmIdentifier.getParameters());
        int n2 = (Integer)KEYSIZES.get(algorithmIdentifier2.getAlgorithm());
        byte[] byArray = passwordRecipient.calculateDerivedKey(passwordRecipient.getPasswordConversionScheme(), this.getKeyDerivationAlgorithm(), n2);
        return passwordRecipient.getRecipientOperator(algorithmIdentifier2, this.messageAlgorithm, byArray, this.a.getEncryptedKey().getOctets());
    }

    static {
        BLOCKSIZES.put(CMSAlgorithm.DES_EDE3_CBC, Integers.valueOf(8));
        BLOCKSIZES.put(CMSAlgorithm.AES128_CBC, Integers.valueOf(16));
        BLOCKSIZES.put(CMSAlgorithm.AES192_CBC, Integers.valueOf(16));
        BLOCKSIZES.put(CMSAlgorithm.AES256_CBC, Integers.valueOf(16));
        KEYSIZES.put(CMSAlgorithm.DES_EDE3_CBC, Integers.valueOf(192));
        KEYSIZES.put(CMSAlgorithm.AES128_CBC, Integers.valueOf(128));
        KEYSIZES.put(CMSAlgorithm.AES192_CBC, Integers.valueOf(192));
        KEYSIZES.put(CMSAlgorithm.AES256_CBC, Integers.valueOf(256));
    }
}

