/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.cms;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.cms.PasswordRecipientInfo;
import com.aspose.psd.internal.bouncycastle.asn1.cms.RecipientInfo;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PBKDF2Params;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.cms.CMSException;
import com.aspose.psd.internal.bouncycastle.cms.PasswordRecipient;
import com.aspose.psd.internal.bouncycastle.cms.PasswordRecipientInformation;
import com.aspose.psd.internal.bouncycastle.cms.RecipientInfoGenerator;
import com.aspose.psd.internal.bouncycastle.operator.GenericKey;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public abstract class PasswordRecipientInfoGenerator
implements RecipientInfoGenerator {
    protected char[] password;
    private AlgorithmIdentifier a;
    private ASN1ObjectIdentifier b;
    private SecureRandom c;
    private int d;
    private int e;
    private int f;
    private PasswordRecipient.PRF g;
    private byte[] h;
    private int i;

    protected PasswordRecipientInfoGenerator(ASN1ObjectIdentifier aSN1ObjectIdentifier, char[] cArray) {
        this(aSN1ObjectIdentifier, cArray, PasswordRecipientInfoGenerator.a(aSN1ObjectIdentifier), (Integer)PasswordRecipientInformation.BLOCKSIZES.get(aSN1ObjectIdentifier));
    }

    protected PasswordRecipientInfoGenerator(ASN1ObjectIdentifier aSN1ObjectIdentifier, char[] cArray, int n2, int n3) {
        this.password = cArray;
        this.d = 1;
        this.b = aSN1ObjectIdentifier;
        this.e = n2;
        this.f = n3;
        this.g = PasswordRecipient.PRF.HMacSHA1;
        this.i = 1024;
    }

    private static int a(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Integer n2 = (Integer)PasswordRecipientInformation.KEYSIZES.get(aSN1ObjectIdentifier);
        if (n2 == null) {
            throw new IllegalArgumentException("cannot find key size for algorithm: " + aSN1ObjectIdentifier);
        }
        return n2;
    }

    public PasswordRecipientInfoGenerator setPasswordConversionScheme(int n2) {
        this.d = n2;
        return this;
    }

    public PasswordRecipientInfoGenerator setPRF(PasswordRecipient.PRF pRF) {
        this.g = pRF;
        return this;
    }

    public PasswordRecipientInfoGenerator setSaltAndIterationCount(byte[] byArray, int n2) {
        this.h = Arrays.clone(byArray);
        this.i = n2;
        return this;
    }

    public PasswordRecipientInfoGenerator setSecureRandom(SecureRandom secureRandom) {
        this.c = secureRandom;
        return this;
    }

    @Override
    public RecipientInfo generate(GenericKey genericKey) throws CMSException {
        byte[] byArray = new byte[this.f];
        if (this.c == null) {
            this.c = new SecureRandom();
        }
        this.c.nextBytes(byArray);
        if (this.h == null) {
            this.h = new byte[20];
            this.c.nextBytes(this.h);
        }
        this.a = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBKDF2, new PBKDF2Params(this.h, this.i, this.g.prfAlgID));
        byte[] byArray2 = this.calculateDerivedKey(this.d, this.a, this.e);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(this.b, new DEROctetString(byArray));
        byte[] byArray3 = this.generateEncryptedBytes(algorithmIdentifier, byArray2, genericKey);
        DEROctetString dEROctetString = new DEROctetString(byArray3);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(new DEROctetString(byArray));
        AlgorithmIdentifier algorithmIdentifier2 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_PWRI_KEK, new DERSequence(aSN1EncodableVector));
        return new RecipientInfo(new PasswordRecipientInfo(this.a, algorithmIdentifier2, dEROctetString));
    }

    protected abstract byte[] calculateDerivedKey(int var1, AlgorithmIdentifier var2, int var3) throws CMSException;

    protected abstract byte[] generateEncryptedBytes(AlgorithmIdentifier var1, byte[] var2, GenericKey var3) throws CMSException;
}

