/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.cms;

import com.aspose.psd.internal.bouncycastle.asn1.cms.ContentInfo;
import com.aspose.psd.internal.bouncycastle.asn1.cms.EncryptedContentInfo;
import com.aspose.psd.internal.bouncycastle.asn1.cms.EncryptedData;
import com.aspose.psd.internal.bouncycastle.cms.CMSException;
import com.aspose.psd.internal.bouncycastle.cms.CMSTypedStream;
import com.aspose.psd.internal.bouncycastle.cms.o;
import com.aspose.psd.internal.bouncycastle.operator.InputDecryptor;
import com.aspose.psd.internal.bouncycastle.operator.InputDecryptorProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class CMSEncryptedData {
    private ContentInfo a;
    private EncryptedData b;

    public CMSEncryptedData(ContentInfo contentInfo) {
        this.a = contentInfo;
        this.b = EncryptedData.getInstance(contentInfo.getContent());
    }

    public byte[] getContent(InputDecryptorProvider inputDecryptorProvider) throws CMSException {
        try {
            return o.b(this.getContentStream(inputDecryptorProvider).getContentStream());
        }
        catch (IOException iOException) {
            throw new CMSException("unable to parse internal stream: " + iOException.getMessage(), iOException);
        }
    }

    public CMSTypedStream getContentStream(InputDecryptorProvider inputDecryptorProvider) throws CMSException {
        try {
            EncryptedContentInfo encryptedContentInfo = this.b.getEncryptedContentInfo();
            InputDecryptor inputDecryptor = inputDecryptorProvider.get(encryptedContentInfo.getContentEncryptionAlgorithm());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(encryptedContentInfo.getEncryptedContent().getOctets());
            return new CMSTypedStream(encryptedContentInfo.getContentType(), inputDecryptor.getInputStream(byteArrayInputStream));
        }
        catch (Exception exception) {
            throw new CMSException("unable to create stream: " + exception.getMessage(), exception);
        }
    }

    public ContentInfo toASN1Structure() {
        return this.a;
    }
}

