/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.cms;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.cms.CompressedData;
import com.aspose.psd.internal.bouncycastle.asn1.cms.ContentInfo;
import com.aspose.psd.internal.bouncycastle.cms.CMSException;
import com.aspose.psd.internal.bouncycastle.cms.o;
import com.aspose.psd.internal.bouncycastle.operator.InputExpander;
import com.aspose.psd.internal.bouncycastle.operator.InputExpanderProvider;
import com.aspose.psd.internal.bouncycastle.util.Encodable;
import java.io.IOException;
import java.io.InputStream;

public class CMSCompressedData
implements Encodable {
    ContentInfo contentInfo;
    CompressedData comData;

    public CMSCompressedData(byte[] byArray) throws CMSException {
        this(o.a(byArray));
    }

    public CMSCompressedData(InputStream inputStream) throws CMSException {
        this(o.a(inputStream));
    }

    public CMSCompressedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        try {
            this.comData = CompressedData.getInstance(contentInfo.getContent());
        }
        catch (ClassCastException classCastException) {
            throw new CMSException("Malformed content.", classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("Malformed content.", illegalArgumentException);
        }
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentInfo.getContentType();
    }

    public byte[] getContent(InputExpanderProvider inputExpanderProvider) throws CMSException {
        ContentInfo contentInfo = this.comData.getEncapContentInfo();
        ASN1OctetString aSN1OctetString = (ASN1OctetString)contentInfo.getContent();
        InputExpander inputExpander = inputExpanderProvider.get(this.comData.getCompressionAlgorithmIdentifier());
        InputStream inputStream = inputExpander.getInputStream(aSN1OctetString.getOctetStream());
        try {
            return o.b(inputStream);
        }
        catch (IOException iOException) {
            throw new CMSException("exception reading compressed stream.", iOException);
        }
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }
}

