/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.cert.path.validations;

import com.aspose.psd.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.psd.internal.bouncycastle.asn1.x509.KeyUsage;
import com.aspose.psd.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.psd.internal.bouncycastle.cert.path.CertPathValidation;
import com.aspose.psd.internal.bouncycastle.cert.path.CertPathValidationContext;
import com.aspose.psd.internal.bouncycastle.cert.path.CertPathValidationException;
import com.aspose.psd.internal.bouncycastle.util.Memoable;

public class KeyUsageValidation
implements CertPathValidation {
    private boolean a;

    public KeyUsageValidation() {
        this(true);
    }

    public KeyUsageValidation(boolean bl2) {
        this.a = bl2;
    }

    @Override
    public void validate(CertPathValidationContext certPathValidationContext, X509CertificateHolder x509CertificateHolder) throws CertPathValidationException {
        certPathValidationContext.addHandledExtension(Extension.keyUsage);
        if (!certPathValidationContext.isEndEntity()) {
            KeyUsage keyUsage = KeyUsage.fromExtensions(x509CertificateHolder.getExtensions());
            if (keyUsage != null) {
                if (!keyUsage.hasUsages(4)) {
                    throw new CertPathValidationException("Issuer certificate KeyUsage extension does not permit key signing");
                }
            } else if (this.a) {
                throw new CertPathValidationException("KeyUsage extension not present in CA certificate");
            }
        }
    }

    @Override
    public Memoable copy() {
        return new KeyUsageValidation(this.a);
    }

    @Override
    public void reset(Memoable memoable) {
        KeyUsageValidation keyUsageValidation = (KeyUsageValidation)memoable;
        this.a = keyUsageValidation.a;
    }
}

