/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.cert.crmf;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.cms.ContentInfo;
import com.aspose.psd.internal.bouncycastle.asn1.cms.EnvelopedData;
import com.aspose.psd.internal.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.crmf.EncryptedKey;
import com.aspose.psd.internal.bouncycastle.asn1.crmf.PKIArchiveOptions;
import com.aspose.psd.internal.bouncycastle.cert.crmf.CRMFException;
import com.aspose.psd.internal.bouncycastle.cert.crmf.Control;
import com.aspose.psd.internal.bouncycastle.cms.CMSEnvelopedData;
import com.aspose.psd.internal.bouncycastle.cms.CMSException;

public class PKIArchiveControl
implements Control {
    public static final int encryptedPrivKey = 0;
    public static final int keyGenParameters = 1;
    public static final int archiveRemGenPrivKey = 2;
    private static final ASN1ObjectIdentifier a = CRMFObjectIdentifiers.id_regCtrl_pkiArchiveOptions;
    private final PKIArchiveOptions b;

    public PKIArchiveControl(PKIArchiveOptions pKIArchiveOptions) {
        this.b = pKIArchiveOptions;
    }

    @Override
    public ASN1ObjectIdentifier getType() {
        return a;
    }

    @Override
    public ASN1Encodable getValue() {
        return this.b;
    }

    public int getArchiveType() {
        return this.b.getType();
    }

    public boolean isEnvelopedData() {
        EncryptedKey encryptedKey = EncryptedKey.getInstance(this.b.getValue());
        return !encryptedKey.isEncryptedValue();
    }

    public CMSEnvelopedData getEnvelopedData() throws CRMFException {
        try {
            EncryptedKey encryptedKey = EncryptedKey.getInstance(this.b.getValue());
            EnvelopedData envelopedData = EnvelopedData.getInstance(encryptedKey.getValue());
            return new CMSEnvelopedData(new ContentInfo(CMSObjectIdentifiers.envelopedData, envelopedData));
        }
        catch (CMSException cMSException) {
            throw new CRMFException("CMS parsing error: " + cMSException.getMessage(), cMSException.getCause());
        }
        catch (Exception exception) {
            throw new CRMFException("CRMF parsing error: " + exception.getMessage(), exception);
        }
    }
}

