/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.cert.cmp;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.cmp.CertConfirmContent;
import com.aspose.psd.internal.bouncycastle.asn1.cmp.CertStatus;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.psd.internal.bouncycastle.cert.cmp.CMPException;
import com.aspose.psd.internal.bouncycastle.cert.cmp.CertificateConfirmationContent;
import com.aspose.psd.internal.bouncycastle.cert.cmp.a;
import com.aspose.psd.internal.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import com.aspose.psd.internal.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import com.aspose.psd.internal.bouncycastle.operator.DigestCalculator;
import com.aspose.psd.internal.bouncycastle.operator.DigestCalculatorProvider;
import com.aspose.psd.internal.bouncycastle.operator.OperatorCreationException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class CertificateConfirmationContentBuilder {
    private DigestAlgorithmIdentifierFinder a;
    private List b = new ArrayList();
    private List c = new ArrayList();

    public CertificateConfirmationContentBuilder() {
        this(new DefaultDigestAlgorithmIdentifierFinder());
    }

    public CertificateConfirmationContentBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.a = digestAlgorithmIdentifierFinder;
    }

    public CertificateConfirmationContentBuilder addAcceptedCertificate(X509CertificateHolder x509CertificateHolder, BigInteger bigInteger) {
        this.b.add(x509CertificateHolder);
        this.c.add(bigInteger);
        return this;
    }

    public CertificateConfirmationContent build(DigestCalculatorProvider digestCalculatorProvider) throws CMPException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i2 = 0; i2 != this.b.size(); ++i2) {
            DigestCalculator digestCalculator;
            X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)this.b.get(i2);
            BigInteger bigInteger = (BigInteger)this.c.get(i2);
            AlgorithmIdentifier algorithmIdentifier = this.a.find(x509CertificateHolder.toASN1Structure().getSignatureAlgorithm());
            if (algorithmIdentifier == null) {
                throw new CMPException("cannot find algorithm for digest from signature");
            }
            try {
                digestCalculator = digestCalculatorProvider.get(algorithmIdentifier);
            }
            catch (OperatorCreationException operatorCreationException) {
                throw new CMPException("unable to create digest: " + operatorCreationException.getMessage(), operatorCreationException);
            }
            com.aspose.psd.internal.bouncycastle.cert.cmp.a.a(x509CertificateHolder.toASN1Structure(), digestCalculator.getOutputStream());
            aSN1EncodableVector.add(new CertStatus(digestCalculator.getDigest(), bigInteger));
        }
        return new CertificateConfirmationContent(CertConfirmContent.getInstance(new DERSequence(aSN1EncodableVector)), this.a);
    }
}

