/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.x509;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.DERIA5String;
import com.aspose.psd.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.psd.internal.bouncycastle.asn1.x509.GeneralName;
import com.aspose.psd.internal.bouncycastle.asn1.x509.GeneralSubtree;
import com.aspose.psd.internal.bouncycastle.asn1.x509.NameConstraintValidator;
import com.aspose.psd.internal.bouncycastle.asn1.x509.NameConstraintValidatorException;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import com.aspose.psd.internal.bouncycastle.util.Integers;
import com.aspose.psd.internal.bouncycastle.util.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PKIXNameConstraintValidator
implements NameConstraintValidator {
    private Set a = new HashSet();
    private Set b = new HashSet();
    private Set c = new HashSet();
    private Set d = new HashSet();
    private Set e = new HashSet();
    private Set f;
    private Set g;
    private Set h;
    private Set i;
    private Set j;

    @Override
    public void checkPermitted(GeneralName generalName) throws NameConstraintValidatorException {
        switch (generalName.getTagNo()) {
            case 1: {
                this.b(this.h, this.a(generalName));
                break;
            }
            case 2: {
                this.d(this.g, DERIA5String.getInstance(generalName.getName()).getString());
                break;
            }
            case 4: {
                this.a(X500Name.getInstance(generalName.getName()));
                break;
            }
            case 6: {
                this.i(this.i, DERIA5String.getInstance(generalName.getName()).getString());
                break;
            }
            case 7: {
                byte[] byArray = ASN1OctetString.getInstance(generalName.getName()).getOctets();
                this.b(this.j, byArray);
            }
        }
    }

    @Override
    public void checkExcluded(GeneralName generalName) throws NameConstraintValidatorException {
        switch (generalName.getTagNo()) {
            case 1: {
                this.c(this.c, this.a(generalName));
                break;
            }
            case 2: {
                this.e(this.b, DERIA5String.getInstance(generalName.getName()).getString());
                break;
            }
            case 4: {
                this.b(X500Name.getInstance(generalName.getName()));
                break;
            }
            case 6: {
                this.g(this.d, DERIA5String.getInstance(generalName.getName()).getString());
                break;
            }
            case 7: {
                byte[] byArray = ASN1OctetString.getInstance(generalName.getName()).getOctets();
                this.c(this.e, byArray);
            }
        }
    }

    @Override
    public void intersectPermittedSubtree(GeneralSubtree generalSubtree) {
        this.intersectPermittedSubtree(new GeneralSubtree[]{generalSubtree});
    }

    @Override
    public void intersectPermittedSubtree(GeneralSubtree[] generalSubtreeArray) {
        HashMap hashMap = new HashMap();
        for (int i2 = 0; i2 != generalSubtreeArray.length; ++i2) {
            GeneralSubtree object = generalSubtreeArray[i2];
            Integer n2 = Integers.valueOf(object.getBase().getTagNo());
            if (hashMap.get(n2) == null) {
                hashMap.put(n2, new HashSet());
            }
            ((Set)hashMap.get(n2)).add(object);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            switch ((Integer)entry.getKey()) {
                case 1: {
                    this.h = this.b(this.h, (Set)entry.getValue());
                    break;
                }
                case 2: {
                    this.g = this.d(this.g, (Set)entry.getValue());
                    break;
                }
                case 4: {
                    this.f = this.a(this.f, (Set)entry.getValue());
                    break;
                }
                case 6: {
                    this.i = this.e(this.i, (Set)entry.getValue());
                    break;
                }
                case 7: {
                    this.j = this.c(this.j, (Set)entry.getValue());
                }
            }
        }
    }

    @Override
    public void intersectEmptyPermittedSubtree(int n2) {
        switch (n2) {
            case 1: {
                this.h = new HashSet();
                break;
            }
            case 2: {
                this.g = new HashSet();
                break;
            }
            case 4: {
                this.f = new HashSet();
                break;
            }
            case 6: {
                this.i = new HashSet();
                break;
            }
            case 7: {
                this.j = new HashSet();
            }
        }
    }

    @Override
    public void addExcludedSubtree(GeneralSubtree generalSubtree) {
        GeneralName generalName = generalSubtree.getBase();
        switch (generalName.getTagNo()) {
            case 1: {
                this.c = this.a(this.c, this.a(generalName));
                break;
            }
            case 2: {
                this.b = this.f(this.b, this.a(generalName));
                break;
            }
            case 4: {
                this.a = this.c(this.a, (ASN1Sequence)generalName.getName().toASN1Primitive());
                break;
            }
            case 6: {
                this.d = this.h(this.d, this.a(generalName));
                break;
            }
            case 7: {
                this.e = this.a(this.e, ASN1OctetString.getInstance(generalName.getName()).getOctets());
            }
        }
    }

    public int hashCode() {
        return this.a((Collection)this.a) + this.a((Collection)this.b) + this.a((Collection)this.c) + this.a((Collection)this.e) + this.a((Collection)this.d) + this.a((Collection)this.f) + this.a((Collection)this.g) + this.a((Collection)this.h) + this.a((Collection)this.j) + this.a((Collection)this.i);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PKIXNameConstraintValidator)) {
            return false;
        }
        PKIXNameConstraintValidator pKIXNameConstraintValidator = (PKIXNameConstraintValidator)object;
        return this.a((Collection)pKIXNameConstraintValidator.a, (Collection)this.a) && this.a((Collection)pKIXNameConstraintValidator.b, (Collection)this.b) && this.a((Collection)pKIXNameConstraintValidator.c, (Collection)this.c) && this.a((Collection)pKIXNameConstraintValidator.e, (Collection)this.e) && this.a((Collection)pKIXNameConstraintValidator.d, (Collection)this.d) && this.a((Collection)pKIXNameConstraintValidator.f, (Collection)this.f) && this.a((Collection)pKIXNameConstraintValidator.g, (Collection)this.g) && this.a((Collection)pKIXNameConstraintValidator.h, (Collection)this.h) && this.a((Collection)pKIXNameConstraintValidator.j, (Collection)this.j) && this.a((Collection)pKIXNameConstraintValidator.i, (Collection)this.i);
    }

    public String toString() {
        String string = "";
        string = string + "permitted:\n";
        if (this.f != null) {
            string = string + "DN:\n";
            string = string + this.f.toString() + "\n";
        }
        if (this.g != null) {
            string = string + "DNS:\n";
            string = string + this.g.toString() + "\n";
        }
        if (this.h != null) {
            string = string + "Email:\n";
            string = string + this.h.toString() + "\n";
        }
        if (this.i != null) {
            string = string + "URI:\n";
            string = string + this.i.toString() + "\n";
        }
        if (this.j != null) {
            string = string + "IP:\n";
            string = string + this.a(this.j) + "\n";
        }
        string = string + "excluded:\n";
        if (!this.a.isEmpty()) {
            string = string + "DN:\n";
            string = string + this.a.toString() + "\n";
        }
        if (!this.b.isEmpty()) {
            string = string + "DNS:\n";
            string = string + this.b.toString() + "\n";
        }
        if (!this.c.isEmpty()) {
            string = string + "Email:\n";
            string = string + this.c.toString() + "\n";
        }
        if (!this.d.isEmpty()) {
            string = string + "URI:\n";
            string = string + this.d.toString() + "\n";
        }
        if (!this.e.isEmpty()) {
            string = string + "IP:\n";
            string = string + this.a(this.e) + "\n";
        }
        return string;
    }

    private void a(X500Name x500Name) throws NameConstraintValidatorException {
        this.a(this.f, ASN1Sequence.getInstance(x500Name.toASN1Primitive()));
    }

    private void b(X500Name x500Name) throws NameConstraintValidatorException {
        this.b(this.a, ASN1Sequence.getInstance(x500Name));
    }

    private static boolean a(ASN1Sequence aSN1Sequence, ASN1Sequence aSN1Sequence2) {
        if (aSN1Sequence2.size() < 1) {
            return false;
        }
        if (aSN1Sequence2.size() > aSN1Sequence.size()) {
            return false;
        }
        for (int i2 = aSN1Sequence2.size() - 1; i2 >= 0; --i2) {
            if (aSN1Sequence2.getObjectAt(i2).equals(aSN1Sequence.getObjectAt(i2))) continue;
            return false;
        }
        return true;
    }

    private void a(Set set, ASN1Sequence aSN1Sequence) throws NameConstraintValidatorException {
        if (set == null) {
            return;
        }
        if (set.isEmpty() && aSN1Sequence.size() == 0) {
            return;
        }
        for (ASN1Sequence aSN1Sequence2 : set) {
            if (!PKIXNameConstraintValidator.a(aSN1Sequence, aSN1Sequence2)) continue;
            return;
        }
        throw new NameConstraintValidatorException("Subject distinguished name is not from a permitted subtree");
    }

    private void b(Set set, ASN1Sequence aSN1Sequence) throws NameConstraintValidatorException {
        if (set.isEmpty()) {
            return;
        }
        for (ASN1Sequence aSN1Sequence2 : set) {
            if (!PKIXNameConstraintValidator.a(aSN1Sequence, aSN1Sequence2)) continue;
            throw new NameConstraintValidatorException("Subject distinguished name is from an excluded subtree");
        }
    }

    private Set a(Set set, Set set2) {
        HashSet<ASN1Sequence> hashSet = new HashSet<ASN1Sequence>();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(((GeneralSubtree)iterator.next()).getBase().getName().toASN1Primitive());
            if (set == null) {
                if (aSN1Sequence == null) continue;
                hashSet.add(aSN1Sequence);
                continue;
            }
            for (ASN1Sequence aSN1Sequence2 : set) {
                if (PKIXNameConstraintValidator.a(aSN1Sequence, aSN1Sequence2)) {
                    hashSet.add(aSN1Sequence);
                    continue;
                }
                if (!PKIXNameConstraintValidator.a(aSN1Sequence2, aSN1Sequence)) continue;
                hashSet.add(aSN1Sequence2);
            }
        }
        return hashSet;
    }

    private Set c(Set set, ASN1Sequence aSN1Sequence) {
        if (set.isEmpty()) {
            if (aSN1Sequence == null) {
                return set;
            }
            set.add(aSN1Sequence);
            return set;
        }
        HashSet<ASN1Sequence> hashSet = new HashSet<ASN1Sequence>();
        for (ASN1Sequence aSN1Sequence2 : set) {
            if (PKIXNameConstraintValidator.a(aSN1Sequence, aSN1Sequence2)) {
                hashSet.add(aSN1Sequence2);
                continue;
            }
            if (PKIXNameConstraintValidator.a(aSN1Sequence2, aSN1Sequence)) {
                hashSet.add(aSN1Sequence);
                continue;
            }
            hashSet.add(aSN1Sequence2);
            hashSet.add(aSN1Sequence);
        }
        return hashSet;
    }

    private Set b(Set set, Set set2) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            String string = this.a(((GeneralSubtree)iterator.next()).getBase());
            if (set == null) {
                if (string == null) continue;
                hashSet.add(string);
                continue;
            }
            for (String string2 : set) {
                this.c(string, string2, hashSet);
            }
        }
        return hashSet;
    }

    private Set a(Set set, String string) {
        if (set.isEmpty()) {
            if (string == null) {
                return set;
            }
            set.add(string);
            return set;
        }
        HashSet hashSet = new HashSet();
        for (String string2 : set) {
            this.a(string2, string, hashSet);
        }
        return hashSet;
    }

    private Set c(Set set, Set set2) {
        HashSet<byte[]> hashSet = new HashSet<byte[]>();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            byte[] byArray = ASN1OctetString.getInstance(((GeneralSubtree)iterator.next()).getBase().getName()).getOctets();
            if (set == null) {
                if (byArray == null) continue;
                hashSet.add(byArray);
                continue;
            }
            for (byte[] byArray2 : set) {
                hashSet.addAll(this.b(byArray2, byArray));
            }
        }
        return hashSet;
    }

    private Set a(Set set, byte[] byArray) {
        if (set.isEmpty()) {
            if (byArray == null) {
                return set;
            }
            set.add(byArray);
            return set;
        }
        HashSet hashSet = new HashSet();
        for (byte[] byArray2 : set) {
            hashSet.addAll(this.a(byArray2, byArray));
        }
        return hashSet;
    }

    private Set a(byte[] byArray, byte[] byArray2) {
        HashSet<byte[]> hashSet = new HashSet<byte[]>();
        if (Arrays.areEqual(byArray, byArray2)) {
            hashSet.add(byArray);
        } else {
            hashSet.add(byArray);
            hashSet.add(byArray2);
        }
        return hashSet;
    }

    private Set b(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return Collections.EMPTY_SET;
        }
        byte[][] byArray3 = this.d(byArray, byArray2);
        byte[] byArray4 = byArray3[0];
        byte[] byArray5 = byArray3[1];
        byte[] byArray6 = byArray3[2];
        byte[] byArray7 = byArray3[3];
        byte[][] byArray8 = this.a(byArray4, byArray5, byArray6, byArray7);
        byte[] byArray9 = PKIXNameConstraintValidator.g(byArray8[1], byArray8[3]);
        byte[] byArray10 = PKIXNameConstraintValidator.f(byArray8[0], byArray8[2]);
        if (PKIXNameConstraintValidator.h(byArray10, byArray9) == 1) {
            return Collections.EMPTY_SET;
        }
        byte[] byArray11 = PKIXNameConstraintValidator.i(byArray8[0], byArray8[2]);
        byte[] byArray12 = PKIXNameConstraintValidator.i(byArray5, byArray7);
        return Collections.singleton(this.c(byArray11, byArray12));
    }

    private byte[] c(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        byte[] byArray3 = new byte[n2 * 2];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        System.arraycopy(byArray2, 0, byArray3, n2, n2);
        return byArray3;
    }

    private byte[][] d(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length / 2;
        byte[] byArray3 = new byte[n2];
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        System.arraycopy(byArray, n2, byArray4, 0, n2);
        byte[] byArray5 = new byte[n2];
        byte[] byArray6 = new byte[n2];
        System.arraycopy(byArray2, 0, byArray5, 0, n2);
        System.arraycopy(byArray2, n2, byArray6, 0, n2);
        return new byte[][]{byArray3, byArray4, byArray5, byArray6};
    }

    private byte[][] a(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        int n2 = byArray.length;
        byte[] byArray5 = new byte[n2];
        byte[] byArray6 = new byte[n2];
        byte[] byArray7 = new byte[n2];
        byte[] byArray8 = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray5[i2] = (byte)(byArray[i2] & byArray2[i2]);
            byArray6[i2] = (byte)(byArray[i2] & byArray2[i2] | ~byArray2[i2]);
            byArray7[i2] = (byte)(byArray3[i2] & byArray4[i2]);
            byArray8[i2] = (byte)(byArray3[i2] & byArray4[i2] | ~byArray4[i2]);
        }
        return new byte[][]{byArray5, byArray6, byArray7, byArray8};
    }

    private void b(Set set, String string) throws NameConstraintValidatorException {
        if (set == null) {
            return;
        }
        for (String string2 : set) {
            if (!this.a(string, string2)) continue;
            return;
        }
        if (string.length() == 0 && set.size() == 0) {
            return;
        }
        throw new NameConstraintValidatorException("Subject email address is not from a permitted subtree.");
    }

    private void c(Set set, String string) throws NameConstraintValidatorException {
        if (set.isEmpty()) {
            return;
        }
        for (String string2 : set) {
            if (!this.a(string, string2)) continue;
            throw new NameConstraintValidatorException("Email address is from an excluded subtree.");
        }
    }

    private void b(Set set, byte[] byArray) throws NameConstraintValidatorException {
        if (set == null) {
            return;
        }
        for (byte[] byArray2 : set) {
            if (!this.e(byArray, byArray2)) continue;
            return;
        }
        if (byArray.length == 0 && set.size() == 0) {
            return;
        }
        throw new NameConstraintValidatorException("IP is not from a permitted subtree.");
    }

    private void c(Set set, byte[] byArray) throws NameConstraintValidatorException {
        if (set.isEmpty()) {
            return;
        }
        for (byte[] byArray2 : set) {
            if (!this.e(byArray, byArray2)) continue;
            throw new NameConstraintValidatorException("IP is from an excluded subtree.");
        }
    }

    private boolean e(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        if (n2 != byArray2.length / 2) {
            return false;
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray2, n2, byArray3, 0, n2);
        byte[] byArray4 = new byte[n2];
        byte[] byArray5 = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray4[i2] = (byte)(byArray2[i2] & byArray3[i2]);
            byArray5[i2] = (byte)(byArray[i2] & byArray3[i2]);
        }
        return Arrays.areEqual(byArray4, byArray5);
    }

    private boolean a(String string, String string2) {
        String string3 = string.substring(string.indexOf(64) + 1);
        return string2.indexOf(64) != -1 ? string.equalsIgnoreCase(string2) : (string2.charAt(0) != '.' ? string3.equalsIgnoreCase(string2) : this.b(string3, string2));
    }

    private boolean b(String string, String string2) {
        String string3 = string2;
        if (string3.startsWith(".")) {
            string3 = string3.substring(1);
        }
        String[] stringArray = Strings.split(string3, '.');
        String[] stringArray2 = Strings.split(string, '.');
        if (stringArray2.length <= stringArray.length) {
            return false;
        }
        int n2 = stringArray2.length - stringArray.length;
        for (int i2 = -1; i2 < stringArray.length; ++i2) {
            if (!(i2 == -1 ? stringArray2[i2 + n2].equals("") : !stringArray[i2].equalsIgnoreCase(stringArray2[i2 + n2]))) continue;
            return false;
        }
        return true;
    }

    private void d(Set set, String string) throws NameConstraintValidatorException {
        if (set == null) {
            return;
        }
        for (String string2 : set) {
            if (!this.b(string, string2) && !string.equalsIgnoreCase(string2)) continue;
            return;
        }
        if (string.length() == 0 && set.size() == 0) {
            return;
        }
        throw new NameConstraintValidatorException("DNS is not from a permitted subtree.");
    }

    private void e(Set set, String string) throws NameConstraintValidatorException {
        if (set.isEmpty()) {
            return;
        }
        for (String string2 : set) {
            if (!this.b(string, string2) && !string.equalsIgnoreCase(string2)) continue;
            throw new NameConstraintValidatorException("DNS is from an excluded subtree.");
        }
    }

    private void a(String string, String string2, Set set) {
        if (string.indexOf(64) != -1) {
            String string3 = string.substring(string.indexOf(64) + 1);
            if (string2.indexOf(64) != -1) {
                if (string.equalsIgnoreCase(string2)) {
                    set.add(string);
                } else {
                    set.add(string);
                    set.add(string2);
                }
            } else if (string2.startsWith(".")) {
                if (this.b(string3, string2)) {
                    set.add(string2);
                } else {
                    set.add(string);
                    set.add(string2);
                }
            } else if (string3.equalsIgnoreCase(string2)) {
                set.add(string2);
            } else {
                set.add(string);
                set.add(string2);
            }
        } else if (string.startsWith(".")) {
            if (string2.indexOf(64) != -1) {
                String string4 = string2.substring(string.indexOf(64) + 1);
                if (this.b(string4, string)) {
                    set.add(string);
                } else {
                    set.add(string);
                    set.add(string2);
                }
            } else if (string2.startsWith(".")) {
                if (this.b(string, string2) || string.equalsIgnoreCase(string2)) {
                    set.add(string2);
                } else if (this.b(string2, string)) {
                    set.add(string);
                } else {
                    set.add(string);
                    set.add(string2);
                }
            } else if (this.b(string2, string)) {
                set.add(string);
            } else {
                set.add(string);
                set.add(string2);
            }
        } else if (string2.indexOf(64) != -1) {
            String string5 = string2.substring(string.indexOf(64) + 1);
            if (string5.equalsIgnoreCase(string)) {
                set.add(string);
            } else {
                set.add(string);
                set.add(string2);
            }
        } else if (string2.startsWith(".")) {
            if (this.b(string, string2)) {
                set.add(string2);
            } else {
                set.add(string);
                set.add(string2);
            }
        } else if (string.equalsIgnoreCase(string2)) {
            set.add(string);
        } else {
            set.add(string);
            set.add(string2);
        }
    }

    private void b(String string, String string2, Set set) {
        if (string.indexOf(64) != -1) {
            String string3 = string.substring(string.indexOf(64) + 1);
            if (string2.indexOf(64) != -1) {
                if (string.equalsIgnoreCase(string2)) {
                    set.add(string);
                } else {
                    set.add(string);
                    set.add(string2);
                }
            } else if (string2.startsWith(".")) {
                if (this.b(string3, string2)) {
                    set.add(string2);
                } else {
                    set.add(string);
                    set.add(string2);
                }
            } else if (string3.equalsIgnoreCase(string2)) {
                set.add(string2);
            } else {
                set.add(string);
                set.add(string2);
            }
        } else if (string.startsWith(".")) {
            if (string2.indexOf(64) != -1) {
                String string4 = string2.substring(string.indexOf(64) + 1);
                if (this.b(string4, string)) {
                    set.add(string);
                } else {
                    set.add(string);
                    set.add(string2);
                }
            } else if (string2.startsWith(".")) {
                if (this.b(string, string2) || string.equalsIgnoreCase(string2)) {
                    set.add(string2);
                } else if (this.b(string2, string)) {
                    set.add(string);
                } else {
                    set.add(string);
                    set.add(string2);
                }
            } else if (this.b(string2, string)) {
                set.add(string);
            } else {
                set.add(string);
                set.add(string2);
            }
        } else if (string2.indexOf(64) != -1) {
            String string5 = string2.substring(string.indexOf(64) + 1);
            if (string5.equalsIgnoreCase(string)) {
                set.add(string);
            } else {
                set.add(string);
                set.add(string2);
            }
        } else if (string2.startsWith(".")) {
            if (this.b(string, string2)) {
                set.add(string2);
            } else {
                set.add(string);
                set.add(string2);
            }
        } else if (string.equalsIgnoreCase(string2)) {
            set.add(string);
        } else {
            set.add(string);
            set.add(string2);
        }
    }

    private Set d(Set set, Set set2) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            String string = this.a(((GeneralSubtree)iterator.next()).getBase());
            if (set == null) {
                if (string == null) continue;
                hashSet.add(string);
                continue;
            }
            for (String string2 : set) {
                if (this.b(string2, string)) {
                    hashSet.add(string2);
                    continue;
                }
                if (!this.b(string, string2)) continue;
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private Set f(Set set, String string) {
        if (set.isEmpty()) {
            if (string == null) {
                return set;
            }
            set.add(string);
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : set) {
            if (this.b(string2, string)) {
                hashSet.add(string);
                continue;
            }
            if (this.b(string, string2)) {
                hashSet.add(string2);
                continue;
            }
            hashSet.add(string2);
            hashSet.add(string);
        }
        return hashSet;
    }

    private void c(String string, String string2, Set set) {
        if (string.indexOf(64) != -1) {
            String string3 = string.substring(string.indexOf(64) + 1);
            if (string2.indexOf(64) != -1) {
                if (string.equalsIgnoreCase(string2)) {
                    set.add(string);
                }
            } else if (string2.startsWith(".")) {
                if (this.b(string3, string2)) {
                    set.add(string);
                }
            } else if (string3.equalsIgnoreCase(string2)) {
                set.add(string);
            }
        } else if (string.startsWith(".")) {
            if (string2.indexOf(64) != -1) {
                String string4 = string2.substring(string.indexOf(64) + 1);
                if (this.b(string4, string)) {
                    set.add(string2);
                }
            } else if (string2.startsWith(".")) {
                if (this.b(string, string2) || string.equalsIgnoreCase(string2)) {
                    set.add(string);
                } else if (this.b(string2, string)) {
                    set.add(string2);
                }
            } else if (this.b(string2, string)) {
                set.add(string2);
            }
        } else if (string2.indexOf(64) != -1) {
            String string5 = string2.substring(string2.indexOf(64) + 1);
            if (string5.equalsIgnoreCase(string)) {
                set.add(string2);
            }
        } else if (string2.startsWith(".")) {
            if (this.b(string, string2)) {
                set.add(string);
            }
        } else if (string.equalsIgnoreCase(string2)) {
            set.add(string);
        }
    }

    private void g(Set set, String string) throws NameConstraintValidatorException {
        if (set.isEmpty()) {
            return;
        }
        for (String string2 : set) {
            if (!this.c(string, string2)) continue;
            throw new NameConstraintValidatorException("URI is from an excluded subtree.");
        }
    }

    private Set e(Set set, Set set2) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            String string = this.a(((GeneralSubtree)iterator.next()).getBase());
            if (set == null) {
                if (string == null) continue;
                hashSet.add(string);
                continue;
            }
            for (String string2 : set) {
                this.d(string2, string, hashSet);
            }
        }
        return hashSet;
    }

    private Set h(Set set, String string) {
        if (set.isEmpty()) {
            if (string == null) {
                return set;
            }
            set.add(string);
            return set;
        }
        HashSet hashSet = new HashSet();
        for (String string2 : set) {
            this.b(string2, string, hashSet);
        }
        return hashSet;
    }

    private void d(String string, String string2, Set set) {
        if (string.indexOf(64) != -1) {
            String string3 = string.substring(string.indexOf(64) + 1);
            if (string2.indexOf(64) != -1) {
                if (string.equalsIgnoreCase(string2)) {
                    set.add(string);
                }
            } else if (string2.startsWith(".")) {
                if (this.b(string3, string2)) {
                    set.add(string);
                }
            } else if (string3.equalsIgnoreCase(string2)) {
                set.add(string);
            }
        } else if (string.startsWith(".")) {
            if (string2.indexOf(64) != -1) {
                String string4 = string2.substring(string.indexOf(64) + 1);
                if (this.b(string4, string)) {
                    set.add(string2);
                }
            } else if (string2.startsWith(".")) {
                if (this.b(string, string2) || string.equalsIgnoreCase(string2)) {
                    set.add(string);
                } else if (this.b(string2, string)) {
                    set.add(string2);
                }
            } else if (this.b(string2, string)) {
                set.add(string2);
            }
        } else if (string2.indexOf(64) != -1) {
            String string5 = string2.substring(string2.indexOf(64) + 1);
            if (string5.equalsIgnoreCase(string)) {
                set.add(string2);
            }
        } else if (string2.startsWith(".")) {
            if (this.b(string, string2)) {
                set.add(string);
            }
        } else if (string.equalsIgnoreCase(string2)) {
            set.add(string);
        }
    }

    private void i(Set set, String string) throws NameConstraintValidatorException {
        if (set == null) {
            return;
        }
        for (String string2 : set) {
            if (!this.c(string, string2)) continue;
            return;
        }
        if (string.length() == 0 && set.size() == 0) {
            return;
        }
        throw new NameConstraintValidatorException("URI is not from a permitted subtree.");
    }

    private boolean c(String string, String string2) {
        String string3 = PKIXNameConstraintValidator.a(string);
        return !string2.startsWith(".") ? string3.equalsIgnoreCase(string2) : this.b(string3, string2);
    }

    private static String a(String string) {
        String string2 = string.substring(string.indexOf(58) + 1);
        if (string2.indexOf("//") != -1) {
            string2 = string2.substring(string2.indexOf("//") + 2);
        }
        if (string2.lastIndexOf(58) != -1) {
            string2 = string2.substring(0, string2.lastIndexOf(58));
        }
        string2 = string2.substring(string2.indexOf(58) + 1);
        if ((string2 = string2.substring(string2.indexOf(64) + 1)).indexOf(47) != -1) {
            string2 = string2.substring(0, string2.indexOf(47));
        }
        return string2;
    }

    private String a(GeneralName generalName) {
        return DERIA5String.getInstance(generalName.getName()).getString();
    }

    private static byte[] f(byte[] byArray, byte[] byArray2) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if ((byArray[i2] & 0xFFFF) <= (byArray2[i2] & 0xFFFF)) continue;
            return byArray;
        }
        return byArray2;
    }

    private static byte[] g(byte[] byArray, byte[] byArray2) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if ((byArray[i2] & 0xFFFF) >= (byArray2[i2] & 0xFFFF)) continue;
            return byArray;
        }
        return byArray2;
    }

    private static int h(byte[] byArray, byte[] byArray2) {
        if (Arrays.areEqual(byArray, byArray2)) {
            return 0;
        }
        if (Arrays.areEqual(PKIXNameConstraintValidator.f(byArray, byArray2), byArray)) {
            return 1;
        }
        return -1;
    }

    private static byte[] i(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray3[i2] = (byte)(byArray[i2] | byArray2[i2]);
        }
        return byArray3;
    }

    private int a(Collection collection) {
        if (collection == null) {
            return 0;
        }
        int n2 = 0;
        for (Object e2 : collection) {
            if (e2 instanceof byte[]) {
                n2 += Arrays.hashCode((byte[])e2);
                continue;
            }
            n2 += e2.hashCode();
        }
        return n2;
    }

    private boolean a(Collection collection, Collection collection2) {
        if (collection == collection2) {
            return true;
        }
        if (collection == null || collection2 == null) {
            return false;
        }
        if (collection.size() != collection2.size()) {
            return false;
        }
        for (Object e2 : collection) {
            Iterator iterator = collection2.iterator();
            boolean bl2 = false;
            while (iterator.hasNext()) {
                Object e3 = iterator.next();
                if (!this.a(e2, e3)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            return false;
        }
        return true;
    }

    private boolean a(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object instanceof byte[] && object2 instanceof byte[]) {
            return Arrays.areEqual((byte[])object, (byte[])object2);
        }
        return object.equals(object2);
    }

    private String a(byte[] byArray) {
        int n2;
        String string = "";
        for (n2 = 0; n2 < byArray.length / 2; ++n2) {
            string = string + Integer.toString(byArray[n2] & 0xFF) + ".";
        }
        string = string.substring(0, string.length() - 1);
        string = string + "/";
        for (n2 = byArray.length / 2; n2 < byArray.length; ++n2) {
            string = string + Integer.toString(byArray[n2] & 0xFF) + ".";
        }
        string = string.substring(0, string.length() - 1);
        return string;
    }

    private String a(Set set) {
        String string = "";
        string = string + "[";
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string = string + this.a((byte[])iterator.next()) + ",";
        }
        if (string.length() > 1) {
            string = string.substring(0, string.length() - 1);
        }
        string = string + "]";
        return string;
    }
}

