/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.x509;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Extensions;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class ExtensionsGenerator {
    private Hashtable a = new Hashtable();
    private Vector b = new Vector();

    public void reset() {
        this.a = new Hashtable();
        this.b = new Vector();
    }

    public void addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, ASN1Encodable aSN1Encodable) throws IOException {
        this.addExtension(aSN1ObjectIdentifier, bl2, aSN1Encodable.toASN1Primitive().getEncoded("DER"));
    }

    public void addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, byte[] byArray) {
        if (this.a.containsKey(aSN1ObjectIdentifier)) {
            throw new IllegalArgumentException("extension " + aSN1ObjectIdentifier + " already added");
        }
        this.b.addElement(aSN1ObjectIdentifier);
        this.a.put(aSN1ObjectIdentifier, new Extension(aSN1ObjectIdentifier, bl2, (ASN1OctetString)new DEROctetString(byArray)));
    }

    public void addExtension(Extension extension) {
        if (this.a.containsKey(extension.getExtnId())) {
            throw new IllegalArgumentException("extension " + extension.getExtnId() + " already added");
        }
        this.b.addElement(extension.getExtnId());
        this.a.put(extension.getExtnId(), extension);
    }

    public boolean isEmpty() {
        return this.b.isEmpty();
    }

    public Extensions generate() {
        Extension[] extensionArray = new Extension[this.b.size()];
        for (int i2 = 0; i2 != this.b.size(); ++i2) {
            extensionArray[i2] = (Extension)this.a.get(this.b.elementAt(i2));
        }
        return new Extensions(extensionArray);
    }
}

