/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.ess;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.x509.DigestInfo;
import com.aspose.psd.internal.bouncycastle.asn1.x509.IssuerSerial;

public class OtherCertID
extends ASN1Object {
    private ASN1Encodable a;
    private IssuerSerial b;

    public static OtherCertID getInstance(Object object) {
        if (object instanceof OtherCertID) {
            return (OtherCertID)object;
        }
        if (object != null) {
            return new OtherCertID(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private OtherCertID(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 1 || aSN1Sequence.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        this.a = aSN1Sequence.getObjectAt(0).toASN1Primitive() instanceof ASN1OctetString ? ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)) : DigestInfo.getInstance(aSN1Sequence.getObjectAt(0));
        if (aSN1Sequence.size() > 1) {
            this.b = IssuerSerial.getInstance(aSN1Sequence.getObjectAt(1));
        }
    }

    public OtherCertID(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.a = new DigestInfo(algorithmIdentifier, byArray);
    }

    public OtherCertID(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, IssuerSerial issuerSerial) {
        this.a = new DigestInfo(algorithmIdentifier, byArray);
        this.b = issuerSerial;
    }

    public AlgorithmIdentifier getAlgorithmHash() {
        if (this.a.toASN1Primitive() instanceof ASN1OctetString) {
            return new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1);
        }
        return DigestInfo.getInstance(this.a).getAlgorithmId();
    }

    public byte[] getCertHash() {
        if (this.a.toASN1Primitive() instanceof ASN1OctetString) {
            return ((ASN1OctetString)this.a.toASN1Primitive()).getOctets();
        }
        return DigestInfo.getInstance(this.a).getDigest();
    }

    public IssuerSerial getIssuerSerial() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

