/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.dvcs;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.dvcs.CertEtcToken;
import com.aspose.psd.internal.bouncycastle.asn1.dvcs.PathProcInput;

public class TargetEtcChain
extends ASN1Object {
    private CertEtcToken a;
    private ASN1Sequence b;
    private PathProcInput c;

    public TargetEtcChain(CertEtcToken certEtcToken) {
        this(certEtcToken, null, null);
    }

    public TargetEtcChain(CertEtcToken certEtcToken, CertEtcToken[] certEtcTokenArray) {
        this(certEtcToken, certEtcTokenArray, null);
    }

    public TargetEtcChain(CertEtcToken certEtcToken, PathProcInput pathProcInput) {
        this(certEtcToken, null, pathProcInput);
    }

    public TargetEtcChain(CertEtcToken certEtcToken, CertEtcToken[] certEtcTokenArray, PathProcInput pathProcInput) {
        this.a = certEtcToken;
        if (certEtcTokenArray != null) {
            this.b = new DERSequence(certEtcTokenArray);
        }
        this.c = pathProcInput;
    }

    private TargetEtcChain(ASN1Sequence aSN1Sequence) {
        int n2 = 0;
        ASN1Encodable aSN1Encodable = aSN1Sequence.getObjectAt(n2++);
        this.a = CertEtcToken.getInstance(aSN1Encodable);
        if (aSN1Sequence.size() > 1) {
            if ((aSN1Encodable = aSN1Sequence.getObjectAt(n2++)) instanceof ASN1TaggedObject) {
                this.a(aSN1Encodable);
            } else {
                this.b = ASN1Sequence.getInstance(aSN1Encodable);
                if (aSN1Sequence.size() > 2) {
                    aSN1Encodable = aSN1Sequence.getObjectAt(n2);
                    this.a(aSN1Encodable);
                }
            }
        }
    }

    private void a(ASN1Encodable aSN1Encodable) {
        ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Encodable);
        switch (aSN1TaggedObject.getTagNo()) {
            case 0: {
                this.c = PathProcInput.getInstance(aSN1TaggedObject, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown tag encountered: " + aSN1TaggedObject.getTagNo());
            }
        }
    }

    public static TargetEtcChain getInstance(Object object) {
        if (object instanceof TargetEtcChain) {
            return (TargetEtcChain)object;
        }
        if (object != null) {
            return new TargetEtcChain(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static TargetEtcChain getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return TargetEtcChain.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        if (this.c != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.c));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TargetEtcChain {\n");
        stringBuffer.append("target: " + this.a + "\n");
        if (this.b != null) {
            stringBuffer.append("chain: " + this.b + "\n");
        }
        if (this.c != null) {
            stringBuffer.append("pathProcInput: " + this.c + "\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public CertEtcToken getTarget() {
        return this.a;
    }

    public CertEtcToken[] getChain() {
        if (this.b != null) {
            return CertEtcToken.arrayFromSequence(this.b);
        }
        return null;
    }

    public PathProcInput getPathProcInput() {
        return this.c;
    }

    public static TargetEtcChain[] arrayFromSequence(ASN1Sequence aSN1Sequence) {
        TargetEtcChain[] targetEtcChainArray = new TargetEtcChain[aSN1Sequence.size()];
        for (int i2 = 0; i2 != targetEtcChainArray.length; ++i2) {
            targetEtcChainArray[i2] = TargetEtcChain.getInstance(aSN1Sequence.getObjectAt(i2));
        }
        return targetEtcChainArray;
    }
}

