/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.dvcs;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1GeneralizedTime;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.dvcs.DVCSTime;
import com.aspose.psd.internal.bouncycastle.asn1.dvcs.ServiceType;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.psd.internal.bouncycastle.asn1.x509.GeneralNames;
import com.aspose.psd.internal.bouncycastle.asn1.x509.PolicyInformation;
import java.math.BigInteger;

public class DVCSRequestInformation
extends ASN1Object {
    private int a = 1;
    private ServiceType b;
    private BigInteger c;
    private DVCSTime d;
    private GeneralNames e;
    private PolicyInformation f;
    private GeneralNames g;
    private GeneralNames h;
    private Extensions i;
    private static final int j = 1;
    private static final int k = 0;
    private static final int l = 1;
    private static final int m = 2;
    private static final int n = 3;
    private static final int o = 4;

    private DVCSRequestInformation(ASN1Sequence aSN1Sequence) {
        ASN1Encodable aSN1Encodable;
        int n2 = 0;
        if (aSN1Sequence.getObjectAt(0) instanceof ASN1Integer) {
            aSN1Encodable = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(n2++));
            this.a = aSN1Encodable.getValue().intValue();
        } else {
            this.a = 1;
        }
        this.b = ServiceType.getInstance(aSN1Sequence.getObjectAt(n2++));
        while (n2 < aSN1Sequence.size()) {
            aSN1Encodable = aSN1Sequence.getObjectAt(n2);
            if (aSN1Encodable instanceof ASN1Integer) {
                this.c = ASN1Integer.getInstance(aSN1Encodable).getValue();
            } else if (aSN1Encodable instanceof ASN1GeneralizedTime) {
                this.d = DVCSTime.getInstance(aSN1Encodable);
            } else if (aSN1Encodable instanceof ASN1TaggedObject) {
                ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Encodable);
                int n3 = aSN1TaggedObject.getTagNo();
                switch (n3) {
                    case 0: {
                        this.e = GeneralNames.getInstance(aSN1TaggedObject, false);
                        break;
                    }
                    case 1: {
                        this.f = PolicyInformation.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, false));
                        break;
                    }
                    case 2: {
                        this.g = GeneralNames.getInstance(aSN1TaggedObject, false);
                        break;
                    }
                    case 3: {
                        this.h = GeneralNames.getInstance(aSN1TaggedObject, false);
                        break;
                    }
                    case 4: {
                        this.i = Extensions.getInstance(aSN1TaggedObject, false);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown tag number encountered: " + n3);
                    }
                }
            } else {
                this.d = DVCSTime.getInstance(aSN1Encodable);
            }
            ++n2;
        }
    }

    public static DVCSRequestInformation getInstance(Object object) {
        if (object instanceof DVCSRequestInformation) {
            return (DVCSRequestInformation)object;
        }
        if (object != null) {
            return new DVCSRequestInformation(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static DVCSRequestInformation getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return DVCSRequestInformation.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != 1) {
            aSN1EncodableVector.add(new ASN1Integer(this.a));
        }
        aSN1EncodableVector.add(this.b);
        if (this.c != null) {
            aSN1EncodableVector.add(new ASN1Integer(this.c));
        }
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        int[] nArray = new int[]{0, 1, 2, 3, 4};
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[]{this.e, this.f, this.g, this.h, this.i};
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            ASN1Encodable aSN1Encodable = aSN1EncodableArray[i2];
            if (aSN1Encodable == null) continue;
            aSN1EncodableVector.add(new DERTaggedObject(false, n2, aSN1Encodable));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DVCSRequestInformation {\n");
        if (this.a != 1) {
            stringBuffer.append("version: " + this.a + "\n");
        }
        stringBuffer.append("service: " + this.b + "\n");
        if (this.c != null) {
            stringBuffer.append("nonce: " + this.c + "\n");
        }
        if (this.d != null) {
            stringBuffer.append("requestTime: " + this.d + "\n");
        }
        if (this.e != null) {
            stringBuffer.append("requester: " + this.e + "\n");
        }
        if (this.f != null) {
            stringBuffer.append("requestPolicy: " + this.f + "\n");
        }
        if (this.g != null) {
            stringBuffer.append("dvcs: " + this.g + "\n");
        }
        if (this.h != null) {
            stringBuffer.append("dataLocations: " + this.h + "\n");
        }
        if (this.i != null) {
            stringBuffer.append("extensions: " + this.i + "\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public int getVersion() {
        return this.a;
    }

    public ServiceType getService() {
        return this.b;
    }

    public BigInteger getNonce() {
        return this.c;
    }

    public DVCSTime getRequestTime() {
        return this.d;
    }

    public GeneralNames getRequester() {
        return this.e;
    }

    public PolicyInformation getRequestPolicy() {
        return this.f;
    }

    public GeneralNames getDVCS() {
        return this.g;
    }

    public GeneralNames getDataLocations() {
        return this.h;
    }

    public Extensions getExtensions() {
        return this.i;
    }
}

