/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.cms;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.cms.KEKIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class KEKRecipientInfo
extends ASN1Object {
    private ASN1Integer a;
    private KEKIdentifier b;
    private AlgorithmIdentifier c;
    private ASN1OctetString d;

    public KEKRecipientInfo(KEKIdentifier kEKIdentifier, AlgorithmIdentifier algorithmIdentifier, ASN1OctetString aSN1OctetString) {
        this.a = new ASN1Integer(4L);
        this.b = kEKIdentifier;
        this.c = algorithmIdentifier;
        this.d = aSN1OctetString;
    }

    public KEKRecipientInfo(ASN1Sequence aSN1Sequence) {
        this.a = (ASN1Integer)aSN1Sequence.getObjectAt(0);
        this.b = KEKIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        this.c = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(2));
        this.d = (ASN1OctetString)aSN1Sequence.getObjectAt(3);
    }

    public static KEKRecipientInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return KEKRecipientInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static KEKRecipientInfo getInstance(Object object) {
        if (object instanceof KEKRecipientInfo) {
            return (KEKRecipientInfo)object;
        }
        if (object != null) {
            return new KEKRecipientInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public KEKIdentifier getKekid() {
        return this.b;
    }

    public AlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.c;
    }

    public ASN1OctetString getEncryptedKey() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        return new DERSequence(aSN1EncodableVector);
    }
}

