/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1OutputStream;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.OIDTokenizer;
import com.aspose.psd.internal.bouncycastle.asn1.l;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ASN1ObjectIdentifier
extends ASN1Primitive {
    private final String a;
    private byte[] b;
    private static final long c = 0xFFFFFFFFFFFF80L;
    private static final ConcurrentMap<a, ASN1ObjectIdentifier> d = new ConcurrentHashMap<a, ASN1ObjectIdentifier>();

    public static ASN1ObjectIdentifier getInstance(Object object) {
        if (object == null || object instanceof ASN1ObjectIdentifier) {
            return (ASN1ObjectIdentifier)object;
        }
        if (object instanceof ASN1Encodable && ((ASN1Encodable)object).toASN1Primitive() instanceof ASN1ObjectIdentifier) {
            return (ASN1ObjectIdentifier)((ASN1Encodable)object).toASN1Primitive();
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            try {
                return (ASN1ObjectIdentifier)ASN1ObjectIdentifier.fromByteArray(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct object identifier from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1ObjectIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        ASN1Primitive aSN1Primitive = aSN1TaggedObject.getObject();
        if (bl2 || aSN1Primitive instanceof ASN1ObjectIdentifier) {
            return ASN1ObjectIdentifier.getInstance(aSN1Primitive);
        }
        return ASN1ObjectIdentifier.fromOctetString(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
    }

    ASN1ObjectIdentifier(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = 0L;
        BigInteger bigInteger = null;
        boolean bl2 = true;
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            if (l2 <= 0xFFFFFFFFFFFF80L) {
                l2 += (long)(n2 & 0x7F);
                if ((n2 & 0x80) == 0) {
                    if (bl2) {
                        if (l2 < 40L) {
                            stringBuffer.append('0');
                        } else if (l2 < 80L) {
                            stringBuffer.append('1');
                            l2 -= 40L;
                        } else {
                            stringBuffer.append('2');
                            l2 -= 80L;
                        }
                        bl2 = false;
                    }
                    stringBuffer.append('.');
                    stringBuffer.append(l2);
                    l2 = 0L;
                    continue;
                }
                l2 <<= 7;
                continue;
            }
            if (bigInteger == null) {
                bigInteger = BigInteger.valueOf(l2);
            }
            bigInteger = bigInteger.or(BigInteger.valueOf(n2 & 0x7F));
            if ((n2 & 0x80) == 0) {
                if (bl2) {
                    stringBuffer.append('2');
                    bigInteger = bigInteger.subtract(BigInteger.valueOf(80L));
                    bl2 = false;
                }
                stringBuffer.append('.');
                stringBuffer.append(bigInteger);
                bigInteger = null;
                l2 = 0L;
                continue;
            }
            bigInteger = bigInteger.shiftLeft(7);
        }
        this.a = stringBuffer.toString();
        this.b = Arrays.clone(byArray);
    }

    public ASN1ObjectIdentifier(String string) {
        if (string == null) {
            throw new IllegalArgumentException("'identifier' cannot be null");
        }
        if (!ASN1ObjectIdentifier.a(string)) {
            throw new IllegalArgumentException("string " + string + " not an OID");
        }
        this.a = string;
    }

    ASN1ObjectIdentifier(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        if (!ASN1ObjectIdentifier.a(string, 0)) {
            throw new IllegalArgumentException("string " + string + " not a valid OID branch");
        }
        this.a = aSN1ObjectIdentifier.getId() + "." + string;
    }

    public String getId() {
        return this.a;
    }

    public ASN1ObjectIdentifier branch(String string) {
        return new ASN1ObjectIdentifier(this, string);
    }

    public boolean on(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        String string = this.getId();
        String string2 = aSN1ObjectIdentifier.getId();
        return string.length() > string2.length() && string.charAt(string2.length()) == '.' && string.startsWith(string2);
    }

    private void a(ByteArrayOutputStream byteArrayOutputStream, long l2) {
        byte[] byArray = new byte[9];
        int n2 = 8;
        byArray[n2] = (byte)((int)l2 & 0x7F);
        while (l2 >= 128L) {
            byArray[--n2] = (byte)((int)(l2 >>= 7) & 0x7F | 0x80);
        }
        byteArrayOutputStream.write(byArray, n2, 9 - n2);
    }

    private void a(ByteArrayOutputStream byteArrayOutputStream, BigInteger bigInteger) {
        int n2 = (bigInteger.bitLength() + 6) / 7;
        if (n2 == 0) {
            byteArrayOutputStream.write(0);
        } else {
            BigInteger bigInteger2 = bigInteger;
            byte[] byArray = new byte[n2];
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                byArray[i2] = (byte)(bigInteger2.intValue() & 0x7F | 0x80);
                bigInteger2 = bigInteger2.shiftRight(7);
            }
            int n3 = n2 - 1;
            byArray[n3] = (byte)(byArray[n3] & 0x7F);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
        }
    }

    private void a(ByteArrayOutputStream byteArrayOutputStream) {
        OIDTokenizer oIDTokenizer = new OIDTokenizer(this.a);
        int n2 = Integer.parseInt(oIDTokenizer.nextToken()) * 40;
        String string = oIDTokenizer.nextToken();
        if (string.length() <= 18) {
            this.a(byteArrayOutputStream, (long)n2 + Long.parseLong(string));
        } else {
            this.a(byteArrayOutputStream, new BigInteger(string).add(BigInteger.valueOf(n2)));
        }
        while (oIDTokenizer.hasMoreTokens()) {
            String string2 = oIDTokenizer.nextToken();
            if (string2.length() <= 18) {
                this.a(byteArrayOutputStream, Long.parseLong(string2));
                continue;
            }
            this.a(byteArrayOutputStream, new BigInteger(string2));
        }
    }

    private synchronized byte[] a() {
        if (this.b == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.a(byteArrayOutputStream);
            this.b = byteArrayOutputStream.toByteArray();
        }
        return this.b;
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() throws IOException {
        int n2 = this.a().length;
        return 1 + l.a(n2) + n2;
    }

    @Override
    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        byte[] byArray = this.a();
        aSN1OutputStream.write(6);
        aSN1OutputStream.writeLength(byArray.length);
        aSN1OutputStream.write(byArray);
    }

    @Override
    public int hashCode() {
        return this.a.hashCode();
    }

    @Override
    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (aSN1Primitive == this) {
            return true;
        }
        if (!(aSN1Primitive instanceof ASN1ObjectIdentifier)) {
            return false;
        }
        return this.a.equals(((ASN1ObjectIdentifier)aSN1Primitive).a);
    }

    public String toString() {
        return this.getId();
    }

    private static boolean a(String string, int n2) {
        boolean bl2 = false;
        int n3 = string.length();
        while (--n3 >= n2) {
            char c2 = string.charAt(n3);
            if ('0' <= c2 && c2 <= '9') {
                bl2 = true;
                continue;
            }
            if (c2 == '.') {
                if (!bl2) {
                    return false;
                }
                bl2 = false;
                continue;
            }
            return false;
        }
        return bl2;
    }

    private static boolean a(String string) {
        if (string.length() < 3 || string.charAt(1) != '.') {
            return false;
        }
        char c2 = string.charAt(0);
        if (c2 < '0' || c2 > '2') {
            return false;
        }
        return ASN1ObjectIdentifier.a(string, 2);
    }

    public ASN1ObjectIdentifier intern() {
        a a2 = new a(this.a());
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)d.get(a2);
        if (aSN1ObjectIdentifier == null && (aSN1ObjectIdentifier = d.putIfAbsent(a2, this)) == null) {
            aSN1ObjectIdentifier = this;
        }
        return aSN1ObjectIdentifier;
    }

    static ASN1ObjectIdentifier fromOctetString(byte[] byArray) {
        a a2 = new a(byArray);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)d.get(a2);
        if (aSN1ObjectIdentifier == null) {
            return new ASN1ObjectIdentifier(byArray);
        }
        return aSN1ObjectIdentifier;
    }

    private static class a {
        private final int a;
        private final byte[] b;

        a(byte[] byArray) {
            this.a = Arrays.hashCode(byArray);
            this.b = byArray;
        }

        public int hashCode() {
            return this.a;
        }

        public boolean equals(Object object) {
            if (object instanceof a) {
                return Arrays.areEqual(this.b, ((a)object).b);
            }
            return false;
        }
    }
}

