/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.imageoptions;

import com.aspose.psd.Color;
import com.aspose.psd.ColorPalette;
import com.aspose.psd.IColorPalette;
import com.aspose.psd.ImageOptionsBase;
import com.aspose.psd.ResolutionSetting;
import com.aspose.psd.coreexceptions.imageformats.TiffImageException;
import com.aspose.psd.fileformats.tiff.TiffDataType;
import com.aspose.psd.fileformats.tiff.TiffExifIfd;
import com.aspose.psd.fileformats.tiff.TiffRational;
import com.aspose.psd.fileformats.tiff.enums.TiffAlphaStorage;
import com.aspose.psd.fileformats.tiff.enums.TiffCompressions;
import com.aspose.psd.fileformats.tiff.enums.TiffFillOrders;
import com.aspose.psd.fileformats.tiff.enums.TiffNewSubFileTypes;
import com.aspose.psd.fileformats.tiff.enums.TiffOrientations;
import com.aspose.psd.fileformats.tiff.enums.TiffPhotometrics;
import com.aspose.psd.fileformats.tiff.enums.TiffPlanarConfigs;
import com.aspose.psd.fileformats.tiff.enums.TiffPredictor;
import com.aspose.psd.fileformats.tiff.enums.TiffResolutionUnits;
import com.aspose.psd.fileformats.tiff.enums.TiffTags;
import com.aspose.psd.fileformats.tiff.enums.TiffThresholds;
import com.aspose.psd.internal.Exceptions.ArgumentNullException;
import com.aspose.psd.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.psd.internal.ag.a;
import com.aspose.psd.internal.ai.b;
import com.aspose.psd.internal.ai.h;
import com.aspose.psd.internal.ai.m;
import com.aspose.psd.internal.ai.o;
import com.aspose.psd.internal.bB.i;
import com.aspose.psd.internal.bG.I;
import com.aspose.psd.internal.bG.aV;
import com.aspose.psd.internal.bG.bC;
import com.aspose.psd.internal.bG.bc;
import com.aspose.psd.internal.bG.g;
import com.aspose.psd.internal.gK.d;
import com.aspose.psd.internal.jO.e;
import com.aspose.psd.internal.jO.f;
import com.aspose.psd.internal.jO.l;
import com.aspose.psd.internal.kt.c;
import com.aspose.psd.system.Enum;
import com.aspose.psd.system.collections.Generic.List;
import com.aspose.psd.system.io.MemoryStream;
import com.aspose.psd.xmp.XmpPacketWrapper;
import java.lang.reflect.Array;
import java.util.Arrays;

public class TiffOptions
extends ImageOptionsBase {
    private final i<TiffDataType> a = new i();
    private final List<TiffDataType> b = new List();
    private final i<long[]> c = new i();
    private int d = 18761;
    private boolean e;
    private boolean f = false;
    private final Color g = Color.getWhite();
    private int h = 0x6400000;
    private int i = 1;
    private boolean j = false;
    private int k;

    public TiffOptions(int expectedFormat, int byteOrder) {
        this.setPhotometric(0);
        switch (expectedFormat) {
            case 10: {
                this.setCompression(2);
                break;
            }
            case 5: {
                this.setCompression(3);
                break;
            }
            case 6: {
                this.setCompression(4);
                break;
            }
            case 7: {
                this.setCompression(8);
                break;
            }
            case 8: {
                this.setCompression(8);
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8});
                break;
            }
            case 11: {
                this.setCompression(7);
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8});
                break;
            }
            case 12: {
                this.setCompression(7);
                this.setPhotometric(6);
                this.setBitsPerSample(new int[]{8, 8, 8});
                break;
            }
            case 1: {
                this.setCompression(5);
                break;
            }
            case 2: {
                this.setCompression(5);
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8});
                break;
            }
            case 3: {
                this.setCompression(5);
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8, 8});
                this.setAlphaStorage(2);
                break;
            }
            case 4: {
                this.setCompression(5);
                this.setPhotometric(5);
                this.setBitsPerSample(new int[]{8, 8, 8, 8});
                break;
            }
            case 14: {
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8});
                break;
            }
            case 9: 
            case 15: {
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8, 8});
                this.setAlphaStorage(2);
            }
        }
        this.d = byteOrder;
        this.setCompressedQuality(75);
    }

    public TiffOptions(int expectedFormat) {
        this(expectedFormat, 18761);
    }

    public TiffOptions(TiffOptions options) {
        super(options);
        if (options.b != null) {
            this.a(options.b.toArray((TiffDataType[])new TiffDataType[0]));
        }
        this.d = options.d;
        this.e = options.e;
        this.f = options.f;
        options.g.CloneTo(this.g);
        this.h = options.h;
        this.i = options.i;
        this.j = options.j;
        if (options.getSource() != null) {
            this.setSource(options.getSource());
        }
        if (options.getResolutionSettings() != null) {
            this.setResolutionSettings(options.getResolutionSettings());
        }
        if (options.getVectorRasterizationOptions() != null) {
            this.setVectorRasterizationOptions(options.getVectorRasterizationOptions());
        }
        if (options.getMultiPageOptions() != null) {
            this.setMultiPageOptions(options.getMultiPageOptions());
        }
        this.xmpData = options.xmpData;
        this.setCompressedQuality(options.k);
    }

    public TiffOptions(TiffDataType[] tags) {
        if (tags == null) {
            throw new ArgumentNullException("tags");
        }
        this.a(tags);
        this.setCompressedQuality(75);
    }

    public static int getValidTagsCount(TiffDataType[] tags) {
        int n2 = 0;
        if (tags != null) {
            for (TiffDataType tiffDataType : tags) {
                if (tiffDataType == null || com.aspose.psd.internal.gK.d.b((Object)tiffDataType, o.class) || !tiffDataType.isValid()) continue;
                ++n2;
            }
        }
        return n2;
    }

    static com.aspose.psd.internal.kt.b createOptionsValidator(TiffOptions options) {
        if (options.i == 0) {
            return new com.aspose.psd.internal.kt.a(options);
        }
        if (options.getCompression() == 7) {
            switch (options.getPhotometric()) {
                case 1: {
                    return new c(options);
                }
                case 2: {
                    return new com.aspose.psd.internal.kt.d(options);
                }
                case 6: {
                    return new com.aspose.psd.internal.kt.e(options);
                }
            }
        }
        return new com.aspose.psd.internal.kt.f(options);
    }

    public int getFileStandard() {
        return this.i;
    }

    public void setFileStandard(int value) {
        this.i = value;
    }

    @Deprecated
    public int getDefaultMemoryAllocationLimit() {
        return this.h;
    }

    @Deprecated
    public void setDefaultMemoryAllocationLimit(int value) {
        this.h = value > 0 ? value : this.h;
    }

    public boolean getPremultiplyComponents() {
        return this.f;
    }

    public void setPremultiplyComponents(boolean value) {
        this.f = value;
    }

    public Color c() {
        return this.g;
    }

    public void a(Color color) {
        color.CloneTo(this.g);
    }

    @Override
    public XmpPacketWrapper getXmpData() {
        return this.xmpData;
    }

    @Override
    public void setXmpData(XmpPacketWrapper value) {
        this.xmpData = value;
    }

    public boolean isValid() {
        return this.b(true);
    }

    public int[] getYCbCrSubsampling() {
        int[] nArray;
        int[] nArray2 = this.e(530);
        if (nArray2 == null) {
            nArray2 = new int[]{2, 2};
        }
        if ((nArray = nArray2).length != 2) {
            throw new TiffImageException("Invalid field length. YCbCrSubsampling field must consist of two values.");
        }
        if ((nArray[0] & 0xFFFF) != 1 && (nArray[0] & 0xFFFF) != 2 && (nArray[0] & 0xFFFF) != 4 || (nArray[1] & 0xFFFF) != 1 && (nArray[1] & 0xFFFF) != 2 && (nArray[1] & 0xFFFF) != 4) {
            throw new TiffImageException(aV.a("Invalid YCbCrSubsampling value [{0},{1}]", new Object[]{nArray[0], nArray[1]}));
        }
        if ((nArray[1] & 0xFFFF) > (nArray[0] & 0xFFFF)) {
            throw new TiffImageException(aV.a("YCbCrSubsampleVert={0} shall always be less than or equal to YCbCrSubsampleHoriz={1}", new Object[]{nArray[1], nArray[0]}));
        }
        return nArray;
    }

    public void setYCbCrSubsampling(int[] value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        this.a(530, value);
    }

    public TiffRational[] getYCbCrCoefficients() {
        int n2 = 3;
        if (this.getPhotometric() == 6) {
            TiffRational[] tiffRationalArray = this.g(529);
            if (tiffRationalArray != null) {
                int n3 = tiffRationalArray.length;
                if (n3 != 3) {
                    throw new TiffImageException("Invalid count of rational coefficient values. Must be equal to 3.");
                }
                return tiffRationalArray;
            }
            return new TiffRational[]{new TiffRational(299L, 1000L), new TiffRational(587L, 1000L), new TiffRational(114L, 1000L)};
        }
        return null;
    }

    public void setYCbCrCoefficients(TiffRational[] value) {
        int n2 = 3;
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (value.length != 3) {
            throw new TiffImageException("Invalid count of rational coefficient values. Must be equal to 3.");
        }
        this.a(529, value);
    }

    public boolean isTiled() {
        if (!(this.isTagPresent(324) && this.isTagPresent(325) && this.isTagPresent(322) && this.isTagPresent(323))) {
            return false;
        }
        TiffDataType tiffDataType = this.getTagByType(322);
        int[] nArray = (int[])com.aspose.psd.internal.gK.d.a(tiffDataType.getValue(), int[].class);
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        tiffDataType = this.getTagByType(323);
        nArray = (int[])com.aspose.psd.internal.gK.d.a(tiffDataType.getValue(), int[].class);
        return nArray != null && nArray.length != 0;
    }

    public String getArtist() {
        return this.h(315);
    }

    public void setArtist(String value) {
        this.a(315, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTagPresent(int tag) {
        boolean bl2;
        i<TiffDataType> i2 = this.a;
        synchronized (i2) {
            bl2 = this.a.b(tag);
        }
        return bl2;
    }

    public int getByteOrder() {
        return this.d;
    }

    public void setByteOrder(int value) {
        this.d = value;
    }

    public byte[] getIccProfile() {
        return this.c(34675);
    }

    public MemoryStream d() {
        MemoryStream memoryStream = null;
        byte[] byArray = this.c(34675);
        if (byArray != null) {
            memoryStream = new MemoryStream(byArray);
        }
        return memoryStream;
    }

    public void setIccProfile(byte[] value) {
        this.a(34675, value);
    }

    public int[] getBitsPerSample() {
        int[] nArray = this.e(258);
        if (nArray == null) {
            nArray = new int[]{1};
        } else if (nArray.length < (this.getSamplesPerPixel() & 0xFFFF) && (this.getPhotometric() == 2 || this.getPhotometric() == 6)) {
            m m2;
            int n2 = this.getSamplesPerPixel() & 0xFFFF;
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            TiffDataType tiffDataType = this.getTagByType(338);
            int n3 = 0;
            if (com.aspose.psd.internal.gK.d.b((Object)tiffDataType, m.class) && (m2 = (m)((Object)com.aspose.psd.internal.gK.d.a(tiffDataType, m.class))).a() != null) {
                n3 = m2.a().length;
            }
            for (int i2 = n3; i2 > 0; --i2) {
                nArray2[nArray2.length - i2] = 8;
            }
            nArray = nArray2;
        }
        return nArray;
    }

    public void setBitsPerSample(int[] value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (value.length == 0) {
            throw new ArgumentOutOfRangeException("value", "At least single array value must be specified.");
        }
        this.a(258, value);
        this.a(277, (bc)null, value.length & 0xFFFF);
    }

    public final int[] e() {
        int[] nArray = this.e(338);
        if (nArray != null) {
            int[] nArray2 = this.e(258);
            int n2 = nArray.length;
            if (nArray2 == null || nArray2.length < n2 || n2 > (this.getSamplesPerPixel() & 0xFFFF)) {
                throw new TiffImageException(aV.a("Invalid length of extra components. ExtraSamples.Length = {0}", new Object[]{n2}));
            }
        }
        return nArray;
    }

    public void a(int[] nArray) {
        if (nArray == null) {
            this.removeTag(338);
        } else {
            if (nArray.length == 0) {
                throw new ArgumentOutOfRangeException("value", "At least single array value must be specified.");
            }
            this.a(338, nArray);
        }
    }

    public final long f() {
        return this.d(338);
    }

    public int getCompression() {
        return this.a(259, 1) & 0xFFFF;
    }

    public void setCompression(int value) {
        this.a(259, com.aspose.psd.internal.gK.d.a(TiffCompressions.class), value);
    }

    public final int getCompressedQuality() {
        return this.k;
    }

    public final void setCompressedQuality(int value) {
        if (value > 100 || value < 1) {
            throw new ArgumentOutOfRangeException("Quality must be between 1 and 100.");
        }
        this.k = value;
    }

    public String getCopyright() {
        return this.h(33432);
    }

    public void setCopyright(String value) {
        this.a(33432, value);
    }

    public int[] getColorMap() {
        return this.e(320);
    }

    public void setColorMap(int[] value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if ((this.getSamplesPerPixel() & 0xFFFF) != 1) {
            throw new TiffImageException("The color map may be defined for samples per pixel equal to 1 only.");
        }
        int n2 = this.getBitsPerPixel();
        if (n2 == 0) {
            throw new TiffImageException("The bits per sample are not defined.");
        }
        int n3 = com.aspose.psd.internal.gK.d.e(3.0 * bC.f(2.0, (double)n2));
        if (value.length != n3) {
            throw new ArgumentOutOfRangeException("value", "The array length must correspond to the followign formula: 3 * (2**BitsPerSample).");
        }
        this.a(320, value);
    }

    @Override
    public IColorPalette getPalette() {
        return this.h();
    }

    @Override
    public void setPalette(IColorPalette value) {
        if (value == null || value.getEntriesCount() == 0) {
            this.removeTag(320);
        } else {
            int[] nArray = value.getArgb32Entries();
            int n2 = value.getEntriesCount();
            int n3 = this.getBitsPerPixel();
            if (n3 == 0) {
                throw new TiffImageException("The bits per sample are not defined. Please specify the BitsPerSample first.");
            }
            int n4 = com.aspose.psd.internal.gK.d.e(bC.f(2.0, (double)n3));
            int[] nArray2 = new int[3 * n4];
            n2 = bC.d(n2, n4);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n5 = nArray[i2];
                int n6 = n5 >> 16 & 0xFF;
                int n7 = n5 >> 8 & 0xFF;
                int n8 = n5 & 0xFF;
                nArray2[i2] = (byte)n6 & 0xFF;
                nArray2[i2 + n4] = (byte)n7 & 0xFF;
                nArray2[i2 + n4 * 2] = (byte)n8 & 0xFF;
            }
            this.setColorMap(nArray2);
            this.e = value.isCompactPalette();
        }
    }

    public String getDateTime() {
        return this.h(306);
    }

    public void setDateTime(String value) {
        this.a(306, value);
    }

    public String getDocumentName() {
        return this.h(269);
    }

    public void setDocumentName(String value) {
        this.a(269, value);
    }

    public int getAlphaStorage() {
        return this.a(338, 0) & 0xFFFF;
    }

    public void setAlphaStorage(int value) {
        this.a(338, com.aspose.psd.internal.gK.d.a(TiffAlphaStorage.class), value);
    }

    public boolean isExtraSamplesPresent() {
        int n2 = 65535;
        return 65535 != (this.a(338, 65535) & 0xFFFF);
    }

    public int getFillOrder() {
        return this.a(266, 1) & 0xFFFF;
    }

    public void setFillOrder(int value) {
        this.a(266, com.aspose.psd.internal.gK.d.a(TiffFillOrders.class), value);
    }

    public int[] getHalfToneHints() {
        return this.e(321);
    }

    public void setHalfToneHints(int[] value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (value.length != 2) {
            throw new ArgumentOutOfRangeException("value", "Halftone hints array length must be equal to 2.");
        }
        this.a(321, value);
    }

    public String getImageDescription() {
        return this.h(270);
    }

    public void setImageDescription(String value) {
        this.a(270, value);
    }

    public String getInkNames() {
        return this.h(333);
    }

    public void setInkNames(String value) {
        this.a(333, value);
    }

    public String getScannerManufacturer() {
        return this.h(271);
    }

    public void setScannerManufacturer(String value) {
        this.a(271, value);
    }

    public int[] getMaxSampleValue() {
        int[] nArray = this.e(281);
        if (nArray == null) {
            int[] nArray2 = this.getBitsPerSample();
            nArray = new int[nArray2.length];
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                int n2;
                nArray[i2] = n2 = com.aspose.psd.internal.gK.d.e(bC.f(2.0, (double)((long)nArray2[i2] & 0xFFFFL))) - 1 & 0xFFFF;
            }
        }
        return nArray;
    }

    public void setMaxSampleValue(int[] value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (value.length != (this.getSamplesPerPixel() & 0xFFFF)) {
            throw new ArgumentOutOfRangeException("value", "The array length must correspond to the samples per pixel count.");
        }
        this.a(281, value);
    }

    public int[] getMinSampleValue() {
        int[] nArray = this.e(280);
        if (nArray == null) {
            nArray = new int[this.getSamplesPerPixel()];
        }
        return nArray;
    }

    public void setMinSampleValue(int[] value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (value.length != (this.getSamplesPerPixel() & 0xFFFF)) {
            throw new ArgumentOutOfRangeException("value", "The array length must correspond to the samples per pixel count.");
        }
        this.a(280, value);
    }

    public String getScannerModel() {
        return this.h(272);
    }

    public void setScannerModel(String value) {
        this.a(272, value);
    }

    public int getOrientation() {
        return this.a(274, 1) & 0xFFFF;
    }

    public void setOrientation(int value) {
        this.a(274, com.aspose.psd.internal.gK.d.a(TiffOrientations.class), value);
    }

    public String getPageName() {
        return this.h(285);
    }

    public void setPageName(String value) {
        this.a(285, value);
    }

    public int[] getPageNumber() {
        return this.e(297);
    }

    public void setPageNumber(int[] value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (value.length != 2) {
            throw new ArgumentOutOfRangeException("value", "Expected 2 values in the array: PageNumber[0] is the page number and PageNumber[1] is the total number of pages in the document.");
        }
        this.a(297, value);
    }

    public int getPhotometric() {
        int n2 = 65535;
        int n3 = this.a(262, 65535) & 0xFFFF;
        return n3 != 65535 ? n3 : this.i();
    }

    public void setPhotometric(int value) {
        this.a(262, com.aspose.psd.internal.gK.d.a(TiffPhotometrics.class), value);
    }

    public int getPlanarConfiguration() {
        return this.a(284, 1) & 0xFFFF;
    }

    public void setPlanarConfiguration(int value) {
        this.a(284, com.aspose.psd.internal.gK.d.a(TiffPlanarConfigs.class), value);
    }

    public int getResolutionUnit() {
        return this.a(296, 2) & 0xFFFF;
    }

    public void setResolutionUnit(int value) {
        this.a(296, com.aspose.psd.internal.gK.d.a(TiffResolutionUnits.class), value);
    }

    public long getRowsPerStrip() {
        return this.b(278, 0xFFFFFFFFL);
    }

    public void setRowsPerStrip(long value) {
        this.a(278, new long[]{value}, false);
    }

    public long getTileWidth() {
        return this.b(322, 0xFFFFFFFFL);
    }

    public void setTileWidth(long value) {
        this.a(322, new long[]{value}, false);
    }

    public long getTileLength() {
        return this.b(323, 0xFFFFFFFFL);
    }

    public void setTileLength(long value) {
        this.a(323, new long[]{value}, false);
    }

    public int[] getSampleFormat() {
        int[] nArray;
        int[] nArray2 = this.e(339);
        if (nArray2 == null) {
            nArray = new int[this.getSamplesPerPixel()];
            Arrays.fill(nArray, 1);
        } else {
            nArray = new int[nArray2.length];
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                nArray[i2] = nArray2[i2] & 0xFFFF;
            }
        }
        return nArray;
    }

    public void setSampleFormat(int[] value) {
        TiffOptions.a(value, this.getSamplesPerPixel() & 0xFFFF, "samples per pixel.");
        int[] nArray = new int[value.length];
        System.arraycopy(value, 0, nArray, 0, value.length);
        this.a(339, nArray);
    }

    public int getSamplesPerPixel() {
        return this.a(277, 1);
    }

    public long[] getSmaxSampleValue() {
        return this.a(341, 0xFFFFFFFFL, this.getSamplesPerPixel() & 0xFFFF);
    }

    public void setSmaxSampleValue(long[] value) {
        TiffOptions.a(value, this.getSamplesPerPixel() & 0xFFFF, "samples per pixel.");
        this.a(341, value, true);
    }

    public long[] getSminSampleValue() {
        return this.a(340, 0L, this.getSamplesPerPixel() & 0xFFFF);
    }

    public void setSminSampleValue(long[] value) {
        TiffOptions.a(value, this.getSamplesPerPixel() & 0xFFFF, "samples per pixel.");
        this.a(340, value, true);
    }

    public String getSoftwareType() {
        return this.h(305);
    }

    public void setSoftwareType(String value) {
        this.a(305, value);
    }

    public long[] getStripByteCounts() {
        return this.b(279);
    }

    public void setStripByteCounts(long[] value) {
        this.a(279, value, false);
    }

    public long[] getStripOffsets() {
        return this.b(273);
    }

    public void setStripOffsets(long[] value) {
        this.a(273, value, false);
    }

    public long[] getTileByteCounts() {
        return this.b(325);
    }

    public void setTileByteCounts(long[] value) {
        this.a(325, value, false);
    }

    public long[] getTileOffsets() {
        return this.b(324);
    }

    public void setTileOffsets(long[] value) {
        this.a(324, value, false);
    }

    public long getSubFileType() {
        return this.a(254, 0L) & 0xFFFFFFFFL;
    }

    public void setSubFileType(long value) {
        this.a(254, com.aspose.psd.internal.gK.d.a(TiffNewSubFileTypes.class), value);
    }

    public String getTargetPrinter() {
        return this.h(337);
    }

    public void setTargetPrinter(String value) {
        this.a(337, value);
    }

    public int getThreshholding() {
        return this.a(263, 1) & 0xFFFF;
    }

    public void setThreshholding(int value) {
        this.a(263, com.aspose.psd.internal.gK.d.a(TiffThresholds.class), value);
    }

    public int getTotalPages() {
        int n2 = 0;
        m m2 = (m)((Object)com.aspose.psd.internal.gK.d.a(this.getTagByType(297), m.class));
        if (m2 != null && m2.a() != null && m2.a().length > 1) {
            n2 = m2.a()[1];
        }
        return n2;
    }

    public TiffRational getXposition() {
        return this.f(286);
    }

    public void setXposition(TiffRational value) {
        this.a(286, com.aspose.psd.internal.gK.d.a(TiffTags.class), value);
    }

    @Override
    public ResolutionSetting getResolutionSettings() {
        return super.getResolutionSettings();
    }

    @Override
    public void setResolutionSettings(ResolutionSetting value) {
        super.setResolutionSettings(value);
        if (value != null) {
            this.setXresolution(TiffRational.approximateFraction(value.getHorizontalResolution()));
            this.setYresolution(TiffRational.approximateFraction(value.getVerticalResolution()));
        } else {
            this.setXresolution(null);
            this.setYresolution(null);
        }
    }

    public TiffRational getXresolution() {
        return this.f(282);
    }

    public void setXresolution(TiffRational value) {
        this.a(282, com.aspose.psd.internal.gK.d.a(TiffTags.class), value);
        this.a(value, this.getYresolution());
    }

    public TiffRational getYposition() {
        return this.f(287);
    }

    public void setYposition(TiffRational value) {
        this.a(287, com.aspose.psd.internal.gK.d.a(TiffTags.class), value);
        this.a(this.getXresolution(), value);
    }

    public TiffRational getYresolution() {
        return this.f(283);
    }

    public void setYresolution(TiffRational value) {
        this.a(283, com.aspose.psd.internal.gK.d.a(TiffTags.class), value);
    }

    public long getFaxT4Options() {
        return this.a(292, 0L) & 0xFFFFFFFFL;
    }

    public void setFaxT4Options(long value) {
        this.a(292, new long[]{value & 0xFFFFFFFFL});
    }

    public int getPredictor() {
        return this.a(317, 1) & 0xFFFF;
    }

    public void setPredictor(int value) {
        this.a(317, com.aspose.psd.internal.gK.d.a(TiffPredictor.class), value);
    }

    public long getImageLength() {
        return this.b(257, 0L);
    }

    public void setImageLength(long value) {
        this.a(257, new long[]{value}, false);
    }

    public long getImageWidth() {
        return this.b(256, 0L);
    }

    public void setImageWidth(long value) {
        this.a(256, new long[]{value}, false);
    }

    public TiffExifIfd getExifIfd() {
        long l2 = 0xFFFFFFFFL;
        long l3 = this.b(34665, 0xFFFFFFFFL);
        return 0xFFFFFFFFL != (l3 & 0xFFFFFFFFL) ? new TiffExifIfd(l3) : new TiffExifIfd();
    }

    final void setExifIfd_internalized(TiffExifIfd value) {
        if (value == null || !value.hasValue()) {
            return;
        }
        this.a(34665, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TiffDataType[] getTags() {
        TiffDataType[] tiffDataTypeArray;
        List<TiffDataType> list = this.b;
        synchronized (list) {
            tiffDataTypeArray = this.b.toArray((TiffDataType[])new TiffDataType[0]);
        }
        return tiffDataTypeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTags(TiffDataType[] value) {
        List<TiffDataType> list = this.b;
        synchronized (list) {
            i<TiffDataType> i2 = this.a;
            synchronized (i2) {
                this.b.clear();
                this.a.c();
                if (value != null) {
                    for (TiffDataType tiffDataType : value) {
                        this.addTag(tiffDataType);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getValidTagCount() {
        TiffDataType[] tiffDataTypeArray;
        List<TiffDataType> list = this.b;
        synchronized (list) {
            tiffDataTypeArray = this.b.toArray((TiffDataType[])new TiffDataType[0]);
        }
        return TiffOptions.getValidTagsCount(tiffDataTypeArray);
    }

    public int getBitsPerPixel() {
        int[] nArray = this.getBitsPerSample();
        int n2 = 0;
        if (nArray != null) {
            for (int n3 : nArray) {
                n2 += n3 & 0xFFFF;
            }
        }
        return n2;
    }

    public final String getXPTitle() {
        return this.i(40091);
    }

    public final void setXPTitle(String value) {
        this.b(40091, value);
    }

    public final String getXPComment() {
        return this.i(40092);
    }

    public final void setXPComment(String value) {
        this.b(40092, value);
    }

    public final String getXPAuthor() {
        return this.i(40093);
    }

    public final void setXPAuthor(String value) {
        this.b(40093, value);
    }

    public final String getXPKeywords() {
        return this.i(40094);
    }

    public final void setXPKeywords(String value) {
        this.b(40094, value);
    }

    public final String getXPSubject() {
        return this.i(40095);
    }

    public final void setXPSubject(String value) {
        this.b(40095, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTag(int tag) {
        boolean bl2 = false;
        List<TiffDataType> list = this.b;
        synchronized (list) {
            i<TiffDataType> i2 = this.a;
            synchronized (i2) {
                if (this.a.b(tag)) {
                    TiffDataType tiffDataType = this.a.a(tag);
                    this.a.c(tag);
                    this.b.removeItem(tiffDataType);
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    public void validate() {
        this.b(false);
    }

    public void addTags(TiffDataType[] tagsToAdd) {
        if (tagsToAdd == null) {
            throw new ArgumentNullException("tagsToAdd");
        }
        for (TiffDataType tiffDataType : tagsToAdd) {
            this.addTag(tiffDataType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTag(TiffDataType tagToAdd) {
        this.g();
        if (tagToAdd == null) {
            throw new ArgumentNullException("tagToAdd");
        }
        List<TiffDataType> list = this.b;
        synchronized (list) {
            i<TiffDataType> i2 = this.a;
            synchronized (i2) {
                if (!this.a.b(tagToAdd.getTagId())) {
                    this.b.addItem(tagToAdd);
                }
                this.a.a(tagToAdd.getTagId(), tagToAdd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TiffDataType getTagByType(int tagKey) {
        TiffDataType tiffDataType = null;
        i<TiffDataType> i2 = this.a;
        synchronized (i2) {
            if (this.a.b(tagKey)) {
                tiffDataType = this.a.a(tagKey);
            }
        }
        return tiffDataType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] a(int n2) {
        i<long[]> i2 = this.c;
        synchronized (i2) {
            long[] lArray;
            if (!this.j || !this.c.b(n2)) {
                lArray = this.b(n2);
                this.j = true;
                this.c.a(n2, lArray);
            } else {
                lArray = this.c.a(n2);
            }
            return lArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void g() {
        i<long[]> i2 = this.c;
        synchronized (i2) {
            this.j = false;
            this.c.c();
        }
    }

    private IColorPalette h() {
        ColorPalette colorPalette = null;
        int[] nArray = this.getColorMap();
        if (nArray != null) {
            int n2;
            int n3;
            boolean bl2 = false;
            int[] nArray2 = nArray;
            int n4 = nArray2.length;
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = nArray2[n3];
                if ((n2 & 0xFFFF) <= 255) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                int[] nArray3 = new int[nArray.length];
                for (n3 = 0; n3 < nArray3.length; ++n3) {
                    nArray3[n3] = (nArray[n3] & 0xFFFF) >> 8 & 0xFF & 0xFFFF;
                }
                nArray2 = nArray3;
            } else {
                nArray2 = nArray;
            }
            int n5 = nArray2.length / 3;
            if (n5 > 0) {
                int[] nArray4 = new int[n5];
                for (n2 = 0; n2 < nArray4.length; ++n2) {
                    nArray4[n2] = 0xFF000000 | ((byte)nArray2[n2] & 0xFF) << 16 | ((byte)nArray2[n2 + n5] & 0xFF) << 8 | (byte)nArray2[n2 + (n5 << 1)] & 0xFF;
                }
                colorPalette = new ColorPalette(nArray4, this.e);
            }
        }
        return colorPalette;
    }

    private static void a(Object object, int n2, String string) {
        if (object == null) {
            throw new ArgumentNullException("array");
        }
        if (Array.getLength(object) != n2) {
            throw new ArgumentOutOfRangeException("array", aV.a(new String[]{"The array length is not valid. Expected length equal to ", string}));
        }
    }

    private long[] b(int n2) {
        long[] lArray = null;
        TiffDataType tiffDataType = this.getTagByType(n2);
        if (tiffDataType != null && com.aspose.psd.internal.gK.d.b(tiffDataType.getValue(), g.class)) {
            g g2 = (g)((Object)com.aspose.psd.internal.gK.d.a(tiffDataType.getValue(), g.class));
            int n3 = g2.j();
            lArray = new long[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                lArray[i2] = I.h(g2.e(i2));
            }
        }
        return lArray;
    }

    private byte[] c(int n2) {
        byte[] byArray = null;
        TiffDataType tiffDataType = this.getTagByType(n2);
        if (tiffDataType != null && com.aspose.psd.internal.gK.d.b(tiffDataType.getValue(), g.class)) {
            g g2 = (g)((Object)com.aspose.psd.internal.gK.d.a(tiffDataType.getValue(), g.class));
            byArray = new byte[g2.j()];
            for (int i2 = 0; i2 < g2.j(); ++i2) {
                byArray[i2] = I.c(g2.e(i2));
            }
        }
        return byArray;
    }

    private long[] a(int n2, long l2, int n3) {
        long[] lArray = this.b(n2);
        if (lArray == null) {
            lArray = new long[n3];
            Arrays.fill(lArray, l2);
        }
        return lArray;
    }

    private long d(int n2) {
        TiffDataType tiffDataType = this.getTagByType(n2);
        return tiffDataType == null ? 0L : tiffDataType.getCount();
    }

    private void a(int n2, long[] lArray, boolean bl2) {
        int n3;
        Object object;
        long l2 = 0L;
        for (long l3 : lArray) {
            if ((l3 & 0xFFFFFFFFL) <= (l2 & 0xFFFFFFFFL)) continue;
            l2 = l3;
        }
        if (bl2 && (l2 & 0xFFFFFFFFL) <= 255L) {
            object = new byte[lArray.length];
            for (n3 = 0; n3 < lArray.length; ++n3) {
                object[n3] = (byte)lArray[n3];
            }
            TiffDataType tiffDataType = this.getTagByType(n2);
            if (tiffDataType != null && tiffDataType.getTagType() != 1) {
                this.removeTag(n2);
            }
            this.a(n2, (byte[])object);
        } else if ((l2 & 0xFFFFFFFFL) <= 65535L) {
            object = new int[lArray.length];
            for (n3 = 0; n3 < lArray.length; ++n3) {
                object[n3] = (int)(lArray[n3] & 0xFFFFFFFFL);
            }
            TiffDataType tiffDataType = this.getTagByType(n2);
            if (tiffDataType != null && tiffDataType.getTagType() != 3) {
                this.removeTag(n2);
            }
            this.a(n2, (int[])object);
        } else {
            object = this.getTagByType(n2);
            if (object != null && ((TiffDataType)object).getTagType() != 4) {
                this.removeTag(n2);
            }
            this.a(n2, lArray);
        }
    }

    private void a(TiffDataType[] tiffDataTypeArray) {
        for (TiffDataType tiffDataType : tiffDataTypeArray) {
            this.addTag(tiffDataType.deepClone());
        }
    }

    private void a(int n2, byte[] byArray) {
        b b2 = (b)this.a(n2, new com.aspose.psd.internal.jO.b());
        b2.a(byArray);
        this.addTag(b2);
    }

    private void a(int n2, int[] nArray) {
        m m2 = (m)this.a(n2, new l());
        m2.a(nArray);
        this.addTag(m2);
    }

    private void a(int n2, long[] lArray) {
        com.aspose.psd.internal.ai.g g2 = (com.aspose.psd.internal.ai.g)this.a(n2, new f());
        g2.a(lArray);
        this.addTag(g2);
    }

    private void a(int n2, TiffExifIfd[] tiffExifIfdArray) {
        com.aspose.psd.internal.bA.e e2 = new com.aspose.psd.internal.bA.e();
        if (tiffExifIfdArray == null) {
            return;
        }
        for (TiffExifIfd tiffExifIfd : tiffExifIfdArray) {
            if (!tiffExifIfd.hasValue()) continue;
            e2.e(tiffExifIfd.getOffset());
        }
        if (e2.b() > 0) {
            com.aspose.psd.internal.ai.f f2 = (com.aspose.psd.internal.ai.f)this.a(n2, new e());
            f2.a(new long[0]);
            this.addTag(f2);
        }
    }

    private void a(int n2, TiffRational[] tiffRationalArray) {
        h h2 = (h)this.a(n2, new com.aspose.psd.internal.jO.g());
        h2.a(tiffRationalArray);
        this.addTag(h2);
    }

    private void a(int n2, bc bc2, int n3) {
        if (bc2 != null && !Enum.isDefined(bc2, (long)n3)) {
            throw new ArgumentOutOfRangeException("value", "The value is not defined.");
        }
        this.a(n2, new int[]{n3});
    }

    private void a(int n2, bc bc2, long l2) {
        if (bc2 != null && !Enum.isDefined(bc2, l2)) {
            throw new ArgumentOutOfRangeException("value", "The value is not defined.");
        }
        this.a(n2, new long[]{l2});
    }

    private void a(int n2, TiffExifIfd tiffExifIfd) {
        this.a(n2, new TiffExifIfd[]{tiffExifIfd});
    }

    private void a(int n2, bc bc2, TiffRational tiffRational) {
        if (bc2 != null && !Enum.isDefined(bc2, (long)n2)) {
            throw new ArgumentOutOfRangeException("value", "The value is not defined.");
        }
        this.a(n2, new TiffRational[]{tiffRational});
    }

    private int[] e(int n2) {
        int[] nArray = null;
        m m2 = (m)((Object)com.aspose.psd.internal.gK.d.a(this.getTagByType(n2), m.class));
        if (m2 != null) {
            nArray = m2.a();
        }
        return nArray;
    }

    private int a(int n2, int n3) {
        int n4 = n3;
        m m2 = (m)((Object)com.aspose.psd.internal.gK.d.a(this.getTagByType(n2), m.class));
        if (m2 != null && m2.a() != null && m2.a().length > 0) {
            n4 = m2.a()[0];
        }
        return n4;
    }

    private long a(int n2, long l2) {
        long l3 = l2;
        com.aspose.psd.internal.ai.g g2 = (com.aspose.psd.internal.ai.g)((Object)com.aspose.psd.internal.gK.d.a(this.getTagByType(n2), com.aspose.psd.internal.ai.g.class));
        if (g2 != null && g2.a() != null && g2.a().length > 0) {
            l3 = g2.a()[0];
        }
        return l3;
    }

    private long b(int n2, long l2) {
        long l3 = l2;
        TiffDataType tiffDataType = this.getTagByType(n2);
        if (tiffDataType != null && tiffDataType.getValue() != null && com.aspose.psd.internal.gK.d.b(tiffDataType.getValue(), g.class) && ((g)((Object)com.aspose.psd.internal.gK.d.a(tiffDataType.getValue(), g.class))).j() > 0) {
            l3 = I.h(((g)((Object)com.aspose.psd.internal.gK.d.a(tiffDataType.getValue(), g.class))).e(0));
        }
        return l3;
    }

    private void a(int n2, String string) {
        if (string == null) {
            this.removeTag(n2);
            return;
        }
        com.aspose.psd.internal.ai.a a2 = (com.aspose.psd.internal.ai.a)this.a(n2, new com.aspose.psd.internal.jO.a());
        a2.a(string);
        this.addTag(a2);
    }

    private void b(int n2, String string) {
        if (string == null) {
            this.removeTag(n2);
            return;
        }
        b b2 = (b)this.a(n2, new com.aspose.psd.internal.jO.b());
        b2.a(com.aspose.psd.internal.cv.l.B().c(aV.a(new String[]{string, "\u0000"})));
        this.addTag(b2);
    }

    private TiffRational f(int n2) {
        TiffRational tiffRational = null;
        h h2 = (h)((Object)com.aspose.psd.internal.gK.d.a(this.getTagByType(n2), h.class));
        if (h2 != null && h2.a() != null && h2.a().length > 0) {
            tiffRational = h2.a()[0];
        }
        return tiffRational;
    }

    private TiffRational[] g(int n2) {
        TiffRational[] tiffRationalArray;
        TiffRational[] tiffRationalArray2 = null;
        h h2 = (h)((Object)com.aspose.psd.internal.gK.d.a(this.getTagByType(n2), h.class));
        if (h2 != null && (tiffRationalArray = h2.a()) != null && tiffRationalArray.length > 0) {
            tiffRationalArray2 = new TiffRational[tiffRationalArray.length];
            System.arraycopy(tiffRationalArray, 0, tiffRationalArray2, 0, tiffRationalArray.length);
        }
        return tiffRationalArray2;
    }

    private String h(int n2) {
        String string = null;
        com.aspose.psd.internal.ai.a a2 = (com.aspose.psd.internal.ai.a)((Object)com.aspose.psd.internal.gK.d.a(this.getTagByType(n2), com.aspose.psd.internal.ai.a.class));
        if (a2 != null) {
            string = a2.a();
        }
        return string;
    }

    private String i(int n2) {
        String string = null;
        b b2 = (b)((Object)com.aspose.psd.internal.gK.d.a(this.getTagByType(n2), b.class));
        if (b2 != null) {
            string = aV.c(com.aspose.psd.internal.cv.l.B().c(b2.a()), new char[]{'\u0000'});
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TiffDataType a(int n2, a a2) {
        TiffDataType tiffDataType = a2.a(n2);
        TiffDataType tiffDataType2 = null;
        i<TiffDataType> i2 = this.a;
        synchronized (i2) {
            if (this.a.b(n2) && (tiffDataType2 = this.a.a(n2)).getTagType() != tiffDataType.getTagType()) {
                this.removeTag(n2);
                tiffDataType2 = null;
            }
        }
        if (tiffDataType2 == null) {
            tiffDataType2 = tiffDataType;
        }
        return tiffDataType2;
    }

    private boolean b(boolean bl2) {
        com.aspose.psd.internal.kt.b b2 = TiffOptions.createOptionsValidator(this);
        return b2.a(bl2);
    }

    @Override
    protected Object memberwiseClone() {
        return new TiffOptions(this);
    }

    private int i() {
        int[] nArray = this.getBitsPerSample();
        return nArray.length > 1 ? 2 : 0;
    }

    private void a(TiffRational tiffRational, TiffRational tiffRational2) {
        if (tiffRational != null && tiffRational2 != null) {
            ResolutionSetting resolutionSetting = this.getResolutionSettings();
            if (resolutionSetting == null) {
                super.setResolutionSettings(new ResolutionSetting(tiffRational.getValueD(), tiffRational2.getValueD()));
            } else {
                resolutionSetting.setHorizontalResolution(tiffRational.getValueD());
                resolutionSetting.setVerticalResolution(tiffRational2.getValueD());
            }
        }
    }
}

