/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.fileformats.tiff;

import com.aspose.psd.coreexceptions.FrameworkException;
import com.aspose.psd.coreexceptions.ImageSaveException;
import com.aspose.psd.coreexceptions.imageformats.TiffImageException;
import com.aspose.psd.fileformats.tiff.enums.TiffDataTypes;
import com.aspose.psd.fileformats.tiff.enums.TiffTags;
import com.aspose.psd.fileformats.tiff.filemanagement.TiffStreamReader;
import com.aspose.psd.fileformats.tiff.filemanagement.TiffStreamWriter;
import com.aspose.psd.internal.Exceptions.ArgumentNullException;
import com.aspose.psd.internal.ag.b;
import com.aspose.psd.internal.ai.o;
import com.aspose.psd.internal.bG.aV;
import com.aspose.psd.internal.bG.bf;
import com.aspose.psd.internal.bG.bg;
import com.aspose.psd.internal.bG.g;
import com.aspose.psd.internal.cv.z;
import com.aspose.psd.internal.gL.aN;
import com.aspose.psd.internal.hg.d;
import com.aspose.psd.internal.hj.a;
import com.aspose.psd.system.Enum;

public abstract class TiffDataType
implements Comparable<TiffDataType> {
    private int a;

    protected TiffDataType(int tagId) {
        this.a = tagId;
    }

    public abstract long getCount();

    public int getId() {
        return this.a;
    }

    public int getTagId() {
        return this.a & 0xFFFF;
    }

    public abstract int getTagType();

    public long getAlignedDataSize() {
        return aN.a(this.getDataSize());
    }

    public abstract long getDataSize();

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public boolean isValid() {
        return (this.getCount() & 0xFFFFFFFFL) > 0L;
    }

    public boolean d() {
        return (this.a & 0xFFFF) > 32768;
    }

    public static TiffDataType readTag(TiffStreamReader dataStream, long position) {
        if (dataStream == null) {
            throw new ArgumentNullException("dataStream");
        }
        int[] nArray = dataStream.readUShortArray(position, 2L);
        int n2 = nArray[0];
        int n3 = nArray[1];
        long l2 = dataStream.readULong(position += 4L);
        position += 4L;
        try {
            TiffDataType tiffDataType = b.a(n3, n2);
            if (tiffDataType == null) {
                long l3 = dataStream.readULong(position);
                tiffDataType = new o(dataStream, n3, n2, l2, l3);
            } else {
                tiffDataType.readData(dataStream, position, l2 & 0xFFFFFFFFL);
                if (com.aspose.psd.internal.gK.d.b((Object)tiffDataType, com.aspose.psd.internal.jT.a.class)) {
                    TiffDataType.a((com.aspose.psd.internal.jT.a)tiffDataType, dataStream, position);
                }
            }
            return tiffDataType;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new FrameworkException(aV.a("InstantiationException for tag type : ", bf.b(n3), ". ", throwable.getMessage()), throwable);
        }
    }

    @Override
    public int compareTo(TiffDataType obj) {
        if (obj == null) {
            throw new TiffImageException("Expected TiffDataType type.");
        }
        return (this.a & 0xFFFF) - (obj.a & 0xFFFF);
    }

    public int hashCode() {
        return this.a;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TiffDataType)) {
            return false;
        }
        TiffDataType tiffDataType = (TiffDataType)obj;
        return this.a == tiffDataType.a;
    }

    public TiffDataType deepClone() {
        TiffDataType tiffDataType = this.createInstance();
        this.copyInstanceData(tiffDataType);
        return tiffDataType;
    }

    public void writeTag(TiffStreamWriter dataStream, long additionalDataOffset) {
        if (dataStream == null) {
            throw new ArgumentNullException("dataStream");
        }
        try {
            dataStream.writeUShort(this.a);
            dataStream.writeUShort(this.getTagType());
            long l2 = this.getCount();
            dataStream.writeULong(l2);
            this.writeTagValueOrOffset(dataStream, additionalDataOffset);
        }
        catch (RuntimeException runtimeException) {
            throw new ImageSaveException(aV.a("Unable to Write values for ", Enum.getName(TiffDataTypes.class, this.getTagType()), " Message : ", runtimeException.getMessage()));
        }
    }

    public abstract long writeAdditionalData(TiffStreamWriter var1);

    public String toString() {
        String string = aV.a;
        Object object = this.getValue();
        if (object != null) {
            if (object instanceof g) {
                z z2 = new z();
                z2.a('{');
                g g2 = (g)object;
                int n2 = g2.j();
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (i2 < n2 - 1) {
                        z2.a("{0}, ", g2.e(i2));
                        continue;
                    }
                    z2.a(g2.e(i2));
                    z2.a('}');
                }
                string = z2.toString();
            } else if (object.getClass().isArray()) {
                string = com.aspose.psd.internal.hj.a.a(object);
            } else if (this.getValue() != null) {
                string = object.toString();
            }
        }
        return aV.a("Tag: ", Enum.getName(TiffTags.class, this.getTagId()), " Type: ", TiffDataTypes.toString(TiffDataTypes.class, this.getTagType()), " Count: ", bg.b(this.getCount()), " Value: ", string);
    }

    protected abstract void readData(TiffStreamReader var1, long var2, long var4);

    protected abstract void writeTagValueOrOffset(TiffStreamWriter var1, long var2);

    protected void copyInstanceData(TiffDataType clonedType) {
        clonedType.a = this.a;
    }

    protected abstract TiffDataType createInstance();

    private static void a(com.aspose.psd.internal.jT.a a2, TiffStreamReader tiffStreamReader, long l2) {
        long l3 = tiffStreamReader.readULong(l2);
        a2.a(d.a(tiffStreamReader, l3 & 0xFFFFFFFFL));
    }
}

