/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.fileformats.psd.layers.layerresources.vectorpaths;

import com.aspose.psd.Point;
import com.aspose.psd.PointF;
import com.aspose.psd.coreexceptions.imageformats.PsdImageArgumentException;
import com.aspose.psd.fileformats.psd.layers.layerresources.vectorpaths.VectorPathRecord;
import com.aspose.psd.internal.gL.w;
import com.aspose.psd.internal.ja.a;
import com.aspose.psd.system.collections.Generic.List;
import java.util.Arrays;
import java.util.Collection;

public class BezierKnotRecord
extends VectorPathRecord {
    private static final int a = 2;
    private static final int b = 4;
    private boolean c;
    private boolean d;
    private Point[] e;

    public BezierKnotRecord() {
    }

    public BezierKnotRecord(byte[] data) {
        Short s2 = w.g(data, 0);
        switch (s2) {
            case 1: {
                this.c = true;
                this.d = true;
                break;
            }
            case 2: {
                this.c = true;
                this.d = false;
                break;
            }
            case 4: {
                this.c = false;
                this.d = true;
                break;
            }
            case 5: {
                this.c = false;
                this.d = false;
                break;
            }
            default: {
                throw new PsdImageArgumentException("Can not create Bezier Knot Record from specified byte array. Byte array doesn't contain Bezier Knot Record markers");
            }
        }
        this.setPoints(new Point[3]);
        int n2 = 2;
        for (int i2 = 0; i2 < this.e.length; ++i2) {
            int n3 = w.c(data, n2);
            int n4 = w.c(data, n2 += 4);
            this.e[i2] = new Point(n3, n4);
            n2 += 4;
        }
    }

    public final PointF[] getPathPoints() {
        List<Point> list = new List<Point>();
        list.addAll((Collection<Point>)Arrays.asList(this.getPoints()));
        return com.aspose.psd.internal.ja.a.b(list);
    }

    public final void setPathPoints(PointF[] value) {
        List<PointF> list = new List<PointF>();
        list.addAll((Collection<PointF>)Arrays.asList(value));
        this.e = com.aspose.psd.internal.ja.a.a(list);
    }

    public final Point[] getPoints() {
        return this.e;
    }

    public final void setPoints(Point[] value) {
        if (value.length != 3) {
            throw new PsdImageArgumentException("Length of point array must be 3. Bezier Knot Record uses 3 points.");
        }
        this.e = value;
    }

    public final boolean isClosed() {
        return this.c;
    }

    public final void setClosed(boolean value) {
        this.c = value;
    }

    public final boolean isLinked() {
        return this.d;
    }

    public final void setLinked(boolean value) {
        this.d = value;
    }

    public final boolean isOpen() {
        return !this.c;
    }

    public final void setOpen(boolean value) {
        this.c = !value;
    }

    @Override
    public short getType() {
        if (this.c) {
            if (this.d) {
                return 1;
            }
            return 2;
        }
        if (this.d) {
            return 4;
        }
        return 5;
    }

    @Override
    public byte[] a() {
        byte[] byArray = new byte[this.getLength()];
        byArray[1] = (byte)this.getType();
        for (int i2 = 0; i2 < 3; ++i2) {
            byte[] byArray2 = w.a(this.e[i2].getX());
            System.arraycopy(byArray2, 0, byArray, 2 + 8 * i2, byArray2.length);
            byte[] byArray3 = w.a(this.e[i2].getY());
            System.arraycopy(byArray3, 0, byArray, 2 + (4 + 8 * i2), byArray3.length);
        }
        return byArray;
    }
}

