/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.fileformats.psd.layers.layerresources;

import com.aspose.psd.StreamContainer;
import com.aspose.psd.coreexceptions.imageformats.PsdImageArgumentException;
import com.aspose.psd.fileformats.psd.layers.LayerResource;
import com.aspose.psd.internal.bG.I;

public class LspfResource
extends LayerResource {
    public static final int TypeToolKey = 1819504742;
    private int c;

    public LspfResource(byte[] data) {
        if (data.length != 4) {
            throw new PsdImageArgumentException("Invalid lspf Resource data length");
        }
        if ((data[3] & 0xFF) == 0) {
            this.setTransparencyProtected(I.a((Byte)data[0]));
            this.setCompositeProtected(I.a((Byte)data[1]));
            this.setPositionProtected(I.a((Byte)data[2]));
        } else {
            byte by2 = data[3];
            this.setTransparencyProtected(I.a((by2 & 0xFF & 1) != 0));
            this.setCompositeProtected(I.a((by2 & 0xFF & 2) != 0));
            this.setPositionProtected(I.a((by2 & 0xFF & 4) != 0));
        }
    }

    public LspfResource(boolean isTransparencyProtected, boolean isCompositeProtected, boolean isPositionProtected) {
        this.setTransparencyProtected(isTransparencyProtected);
        this.setCompositeProtected(isCompositeProtected);
        this.setPositionProtected(isPositionProtected);
    }

    public LspfResource() {
        this(false, false, false);
    }

    public final boolean isTransparencyProtected() {
        return (this.getLockType() & 1) != 0;
    }

    public final void setTransparencyProtected(boolean value) {
        if (value) {
            this.setLockType(this.getLockType() | 1);
        } else {
            this.setLockType(this.getLockType() & 0xFFFFFFFE);
        }
    }

    public final boolean isCompositeProtected() {
        return (this.getLockType() & 2) != 0;
    }

    public final void setCompositeProtected(boolean value) {
        if (value) {
            this.setLockType(this.getLockType() | 2);
        } else {
            this.setLockType(this.getLockType() & 0xFFFFFFFD);
        }
    }

    public final boolean isPositionProtected() {
        return (this.getLockType() & 4) != 0;
    }

    public final void setPositionProtected(boolean value) {
        if (value) {
            this.setLockType(this.getLockType() | 4);
        } else {
            this.setLockType(this.getLockType() & 0xFFFFFFFB);
        }
    }

    @Override
    public int getSignature() {
        return 943868237;
    }

    @Override
    public int getKey() {
        return 1819504742;
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public int getPsdVersion() {
        return 6;
    }

    public final int getLockType() {
        return this.c;
    }

    public final void setLockType(int value) {
        this.c = value;
    }

    @Override
    public void save(StreamContainer streamContainer, int psdVersion) {
        this.saveResourceHeader(streamContainer);
        byte[] byArray = new byte[]{I.d(this.isTransparencyProtected()), I.d(this.isCompositeProtected()), I.d(this.isPositionProtected()), I.a(this.getLockType())};
        streamContainer.write(byArray);
    }
}

