/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.fileformats.psd;

import com.aspose.psd.Color;
import com.aspose.psd.IColorPalette;
import com.aspose.psd.IPsdColorPalette;
import com.aspose.psd.internal.Exceptions.ArgumentNullException;
import com.aspose.psd.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.psd.internal.gK.d;
import com.aspose.psd.internal.gL.C;
import com.aspose.psd.internal.gL.l;

public class PsdColorPalette
implements IPsdColorPalette {
    private byte[] a;
    private short b;
    private boolean c;
    private C d;
    private boolean e;

    public PsdColorPalette(IColorPalette colorPalette) {
        if (colorPalette == null) {
            throw new ArgumentNullException("colorPalette");
        }
        int[] nArray = colorPalette.getArgb32Entries();
        this.a = PsdColorPalette.a(nArray);
        IPsdColorPalette iPsdColorPalette = (IPsdColorPalette)((Object)com.aspose.psd.internal.gK.d.a(colorPalette, IPsdColorPalette.class));
        if (iPsdColorPalette != null && iPsdColorPalette.hasTransparentColor()) {
            this.b = iPsdColorPalette.getTransparentIndex();
            this.c = true;
        }
        this.d = new C(nArray);
        this.e = colorPalette.isCompactPalette();
    }

    public PsdColorPalette(IColorPalette colorPalette, short transparentIndex) {
        this(colorPalette);
        if (PsdColorPalette.a(transparentIndex, this.a)) {
            this.b = transparentIndex;
            this.c = true;
        }
    }

    public PsdColorPalette(byte[] rawEntriesData, boolean isCompactPalette) {
        if (rawEntriesData == null) {
            throw new ArgumentNullException("rawEntriesData");
        }
        this.a = rawEntriesData;
        this.d = new C(this.getArgb32Entries());
        this.e = isCompactPalette;
    }

    public PsdColorPalette(byte[] rawEntriesData) {
        this(rawEntriesData, false);
    }

    public PsdColorPalette(byte[] rawEntriesData, short transparentIndex, boolean useCompactPalette) {
        this(rawEntriesData, useCompactPalette);
        if (PsdColorPalette.a(transparentIndex, this.a)) {
            this.b = transparentIndex;
            this.c = true;
        }
    }

    public PsdColorPalette(byte[] rawEntriesData, short transparentIndex) {
        this(rawEntriesData, transparentIndex, false);
    }

    public PsdColorPalette(int[] colorPaletteArgb32Entries, boolean isCompactPalette) {
        if (colorPaletteArgb32Entries == null) {
            throw new ArgumentNullException("colorPaletteArgb32Entries");
        }
        this.a = PsdColorPalette.a(colorPaletteArgb32Entries);
        this.d = new C(colorPaletteArgb32Entries);
        this.e = isCompactPalette;
    }

    public PsdColorPalette(Color[] colorPaletteEntries, boolean isCompactPalette) {
        this(l.a(colorPaletteEntries), isCompactPalette);
    }

    public PsdColorPalette(Color[] colorPaletteEntries) {
        this(colorPaletteEntries, false);
    }

    public PsdColorPalette(Color[] colorPaletteEntries, short transparentIndex, boolean useCompactPalette) {
        this(colorPaletteEntries, useCompactPalette);
        if (PsdColorPalette.a(transparentIndex, this.a)) {
            this.b = transparentIndex;
            this.c = true;
        }
    }

    public PsdColorPalette(Color[] colorPaletteEntries, short transparentIndex) {
        this(colorPaletteEntries, transparentIndex, false);
    }

    @Override
    public final int getRawEntriesCount() {
        return this.a.length;
    }

    @Override
    public final int getEntriesCount() {
        return this.a.length / 3;
    }

    @Override
    public final int[] getArgb32Entries() {
        int n2 = this.a.length / 3;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = 0xFF000000 | (this.a[i2] & 0xFF) << 16 | (this.a[n2 + i2] & 0xFF) << 8 | this.a[n2 * 2 + i2] & 0xFF;
        }
        return nArray;
    }

    @Override
    public final Color[] getEntries() {
        int n2 = this.a.length / 3;
        Color[] colorArray = new Color[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Color color;
            colorArray[i2] = color = Color.fromArgb(this.a[i2], this.a[n2 + i2], this.a[n2 * 2 + i2]);
        }
        return colorArray;
    }

    @Override
    public final short getTransparentIndex() {
        return this.b;
    }

    @Override
    public final boolean hasTransparentColor() {
        return this.c;
    }

    @Override
    public final Color getTransparentColor() {
        Color color = Color.getEmpty();
        if (this.c) {
            int n2 = this.a.length / 3;
            color = Color.fromArgb(this.a[this.b] & 0xFF, this.a[n2 + this.b] & 0xFF, this.a[n2 * 2 + this.b] & 0xFF);
        }
        return color;
    }

    @Override
    public final byte[] getRawEntries() {
        return this.a;
    }

    @Override
    public final boolean isCompactPalette() {
        return this.e;
    }

    public static PsdColorPalette copyPalette(IColorPalette colorPalette, boolean useCompactPalette) {
        PsdColorPalette psdColorPalette = null;
        if (com.aspose.psd.internal.gK.d.b((Object)colorPalette, IPsdColorPalette.class)) {
            IPsdColorPalette iPsdColorPalette = (IPsdColorPalette)((Object)com.aspose.psd.internal.gK.d.a(colorPalette, IPsdColorPalette.class));
            byte[] byArray = new byte[iPsdColorPalette.getRawEntriesCount()];
            System.arraycopy(iPsdColorPalette.getRawEntries(), 0, byArray, 0, byArray.length);
            psdColorPalette = iPsdColorPalette.hasTransparentColor() ? new PsdColorPalette(byArray, iPsdColorPalette.getTransparentIndex(), useCompactPalette) : new PsdColorPalette(byArray, useCompactPalette);
        } else if (colorPalette != null) {
            int[] nArray = new int[colorPalette.getEntriesCount()];
            System.arraycopy(colorPalette.getArgb32Entries(), 0, nArray, 0, nArray.length);
            psdColorPalette = new PsdColorPalette(nArray, useCompactPalette);
        }
        return psdColorPalette;
    }

    public static PsdColorPalette copyPalette(IColorPalette colorPalette) {
        return PsdColorPalette.copyPalette(colorPalette, colorPalette != null && colorPalette.isCompactPalette());
    }

    @Override
    public final int getNearestColorIndex(int argb32Color) {
        int n2 = this.c && argb32Color == 0 ? this.b : this.d.a(argb32Color);
        return n2;
    }

    @Override
    public final int getNearestColorIndex(Color color) {
        return this.getNearestColorIndex(color.toArgb());
    }

    @Override
    public final int getArgb32Color(int index) {
        int n2 = this.a.length / 3;
        if (index >= n2 || index < 0) {
            throw new ArgumentOutOfRangeException("index", "The specified index lies out of the entries length.");
        }
        int n3 = !this.c || this.b != index ? 0xFF000000 | (this.a[index] & 0xFF) << 16 | (this.a[n2 + index] & 0xFF) << 8 | this.a[n2 * 2 + index] & 0xFF : 0;
        return n3;
    }

    @Override
    public final Color getColor(int index) {
        return Color.fromArgb(this.getArgb32Color(index));
    }

    private static boolean a(short s2, byte[] byArray) {
        int n2 = byArray.length / 3;
        return s2 >= 0 && s2 < n2;
    }

    private static byte[] a(int[] nArray) {
        int n2 = nArray.length * 3;
        byte[] byArray = new byte[n2];
        int n3 = nArray.length;
        int n4 = n3 * 2;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n5 = nArray[i2];
            byte by2 = (byte)(n5 >> 16 & 0xFF);
            byte by3 = (byte)(n5 >> 8 & 0xFF);
            byte by4 = (byte)(n5 & 0xFF);
            byArray[i2] = by2;
            byArray[i2 + n3] = by3;
            byArray[i2 + n4] = by4;
        }
        return byArray;
    }
}

