/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd;

import com.aspose.psd.Point;
import com.aspose.psd.RectangleF;
import com.aspose.psd.Size;
import com.aspose.psd.internal.bG.aV;
import com.aspose.psd.internal.bG.bC;
import com.aspose.psd.internal.bU.i;
import com.aspose.psd.internal.gK.d;
import com.aspose.psd.system.SerializableAttribute;

@SerializableAttribute
public class Rectangle
extends com.aspose.psd.internal.gK.i<Rectangle> {
    static final String RectangleFormat = "{{X={0}, Y={1}, Width={2}, Height={3}}}";
    private static final Rectangle a = new Rectangle();
    private int b;
    private int c;
    private int d;
    private int e;

    public Rectangle() {
    }

    public Rectangle(int x2, int y2, int width, int height) {
        this.d = x2;
        this.e = y2;
        this.c = width;
        this.b = height;
    }

    public Rectangle(Point location, Size size) {
        this.d = location.getX();
        this.e = location.getY();
        this.c = size.getWidth();
        this.b = size.getHeight();
    }

    public static Rectangle getEmpty() {
        return a.Clone();
    }

    public Point getLocation() {
        return new Point(this.d, this.e);
    }

    public void setLocation(Point value) {
        this.d = value.getX();
        this.e = value.getY();
    }

    public Size getSize() {
        return new Size(this.c, this.b);
    }

    public void setSize(Size value) {
        this.c = value.getWidth();
        this.b = value.getHeight();
    }

    public int getX() {
        return this.d;
    }

    public void setX(int value) {
        this.d = value;
    }

    public int getY() {
        return this.e;
    }

    public void setY(int value) {
        this.e = value;
    }

    public int getWidth() {
        return this.c;
    }

    public void setWidth(int value) {
        this.c = value;
    }

    public int getHeight() {
        return this.b;
    }

    public void setHeight(int value) {
        this.b = value;
    }

    public int getLeft() {
        return this.d;
    }

    public void setLeft(int value) {
        int n2 = value - this.d;
        this.d = value;
        this.c -= n2;
    }

    public int getTop() {
        return this.e;
    }

    public void setTop(int value) {
        int n2 = value - this.e;
        this.e = value;
        this.b -= n2;
    }

    public int getRight() {
        return this.d + this.c;
    }

    public void setRight(int value) {
        int n2 = value - this.getRight();
        this.c += n2;
    }

    public int getBottom() {
        return this.e + this.b;
    }

    public void setBottom(int value) {
        int n2 = value - this.getBottom();
        this.b += n2;
    }

    public boolean isEmpty() {
        return this.b == 0 && this.c == 0 && this.d == 0 && this.e == 0;
    }

    public boolean a() {
        return this.b > 0 && this.c > 0 && (this.d + this.c > 0 || this.e + this.b > 0);
    }

    public static Rectangle fromPoints(Point point1, Point point2) {
        int n2 = bC.d(point1.getX(), point2.getX());
        int n3 = bC.b(point1.getX(), point2.getX());
        int n4 = bC.d(point1.getY(), point2.getY());
        int n5 = bC.b(point1.getY(), point2.getY());
        return Rectangle.fromLeftTopRightBottom(n2, n4, n3, n5);
    }

    public static Rectangle ceiling(RectangleF value) {
        return new Rectangle(com.aspose.psd.internal.gK.d.e(bC.b((double)value.getX())), com.aspose.psd.internal.gK.d.e(bC.b((double)value.getY())), com.aspose.psd.internal.gK.d.e(bC.b((double)value.getWidth())), com.aspose.psd.internal.gK.d.e(bC.b((double)value.getHeight())));
    }

    public static Rectangle truncate(RectangleF value) {
        return new Rectangle(com.aspose.psd.internal.gK.d.e(value.getX()), com.aspose.psd.internal.gK.d.e(value.getY()), com.aspose.psd.internal.gK.d.e(value.getWidth()), com.aspose.psd.internal.gK.d.e(value.getHeight()));
    }

    public static Rectangle round(RectangleF value) {
        return new Rectangle(com.aspose.psd.internal.gK.d.e(bC.d(value.getX())), com.aspose.psd.internal.gK.d.e(bC.d(value.getY())), com.aspose.psd.internal.gK.d.e(bC.d(value.getWidth())), com.aspose.psd.internal.gK.d.e(bC.d(value.getHeight())));
    }

    public static Rectangle inflate(Rectangle rect, int x2, int y2) {
        Rectangle rectangle = rect.Clone();
        rectangle.inflate(x2, y2);
        return rectangle;
    }

    public static Rectangle intersect(Rectangle a2, Rectangle b2) {
        int n2 = bC.b(a2.d, b2.d);
        int n3 = bC.d(a2.d + a2.c, b2.d + b2.c);
        int n4 = bC.b(a2.e, b2.e);
        int n5 = bC.d(a2.e + a2.b, b2.e + b2.b);
        if (n3 >= n2 && n5 >= n4) {
            return new Rectangle(n2, n4, n3 - n2, n5 - n4);
        }
        return a.Clone();
    }

    public static Rectangle union(Rectangle a2, Rectangle b2) {
        int n2 = bC.d(a2.d, b2.d);
        int n3 = bC.b(a2.d + a2.c, b2.d + b2.c);
        int n4 = bC.d(a2.e, b2.e);
        int n5 = bC.b(a2.e + a2.b, b2.e + b2.b);
        return new Rectangle(n2, n4, n3 - n2, n5 - n4);
    }

    public static boolean op_Equality(Rectangle left, Rectangle right) {
        return left.d == right.d && left.e == right.e && left.c == right.c && left.b == right.b;
    }

    public static boolean op_Inequality(Rectangle left, Rectangle right) {
        return !Rectangle.op_Equality(left, right);
    }

    public static Rectangle fromLeftTopRightBottom(int left, int top, int right, int bottom) {
        return new Rectangle(left, top, right - left, bottom - top);
    }

    public boolean contains(int x2, int y2) {
        return this.d <= x2 && x2 < this.d + this.c && this.e <= y2 && y2 < this.e + this.b;
    }

    public boolean contains(Point point) {
        return this.contains(point.getX(), point.getY());
    }

    public boolean contains(Rectangle rect) {
        return this.d <= rect.d && rect.d + rect.c <= this.d + this.c && this.e <= rect.e && rect.e + rect.b <= this.e + this.b;
    }

    public void inflate(int width, int height) {
        this.d -= width;
        this.e -= height;
        this.c += 2 * width;
        this.b += 2 * height;
    }

    public void inflate(Size size) {
        this.inflate(size.getWidth(), size.getHeight());
    }

    public void intersect(Rectangle rect) {
        Rectangle rectangle = Rectangle.intersect(rect, this);
        this.d = rectangle.d;
        this.e = rectangle.e;
        this.c = rectangle.c;
        this.b = rectangle.b;
    }

    public boolean intersectsWith(Rectangle rect) {
        return rect.d < this.d + this.c && this.d < rect.d + rect.c && rect.e < this.e + this.b && this.e < rect.e + rect.b;
    }

    public void offset(Point pos) {
        this.offset(pos.getX(), pos.getY());
    }

    public void offset(int x2, int y2) {
        this.d += x2;
        this.e += y2;
    }

    public void normalize() {
        if (this.c < 0) {
            this.d += this.c;
            this.c = -this.c;
        }
        if (this.b < 0) {
            this.e += this.b;
            this.b = -this.b;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Rectangle)) {
            return false;
        }
        Rectangle rectangle = (Rectangle)obj;
        return rectangle.d == this.d && rectangle.e == this.e && rectangle.c == this.c && rectangle.b == this.b;
    }

    public int hashCode() {
        return this.d ^ (this.e << 13 | this.e >> 19) ^ (this.c << 26 | this.c >> 6) ^ (this.b << 7 | this.b >> 25);
    }

    public String toString() {
        return aV.a(i.h(), RectangleFormat, this.d, this.e, this.c, this.b);
    }

    @Override
    public void CloneTo(Rectangle that) {
        that.b = this.b;
        that.c = this.c;
        that.d = this.d;
        that.e = this.e;
    }

    @Override
    public Rectangle Clone() {
        Rectangle rectangle = new Rectangle();
        this.CloneTo(rectangle);
        return rectangle;
    }

    public static boolean isEquals(Rectangle obj1, Rectangle obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }
}

