/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd;

import com.aspose.psd.Color;
import com.aspose.psd.IColorPalette;
import com.aspose.psd.internal.Exceptions.ArgumentNullException;
import com.aspose.psd.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.psd.internal.gL.C;
import com.aspose.psd.internal.gL.l;

public final class ColorPalette
implements IColorPalette {
    private final int[] a;
    private final C b;
    private final boolean c;

    public ColorPalette(int[] argb32Entries, boolean isCompactPalette) {
        if (argb32Entries == null) {
            throw new ArgumentNullException("argb32Entries");
        }
        this.a = argb32Entries;
        this.b = new C(argb32Entries);
        this.c = isCompactPalette;
    }

    public ColorPalette(int[] argb32Entries) {
        this(argb32Entries, false);
    }

    public ColorPalette(Color[] entries, boolean isCompactPalette) {
        this(l.a(entries), isCompactPalette);
    }

    public ColorPalette(Color[] entries) {
        this(entries, false);
    }

    @Override
    public int getEntriesCount() {
        return this.a.length;
    }

    @Override
    public int[] getArgb32Entries() {
        return (int[])this.a.clone();
    }

    @Override
    public Color[] getEntries() {
        Color[] colorArray = new Color[this.a.length];
        for (int i2 = 0; i2 < colorArray.length; ++i2) {
            colorArray[i2] = Color.fromArgb(this.a[i2]);
        }
        return colorArray;
    }

    @Override
    public boolean isCompactPalette() {
        return this.c;
    }

    public static ColorPalette copyPalette(IColorPalette colorPalette, boolean useCompactPalette) {
        ColorPalette colorPalette2 = null;
        if (colorPalette != null) {
            int[] nArray = new int[colorPalette.getEntriesCount()];
            System.arraycopy(colorPalette.getArgb32Entries(), 0, nArray, 0, nArray.length);
            colorPalette2 = new ColorPalette(nArray, useCompactPalette);
        }
        return colorPalette2;
    }

    public static ColorPalette copyPalette(IColorPalette colorPalette) {
        return ColorPalette.copyPalette(colorPalette, colorPalette != null && colorPalette.isCompactPalette());
    }

    @Override
    public int getNearestColorIndex(int argb32Color) {
        return this.b.a(argb32Color);
    }

    @Override
    public int getNearestColorIndex(Color color) {
        return this.b.a(color.toArgb());
    }

    @Override
    public int getArgb32Color(int index) {
        if (index >= this.a.length || index < 0) {
            throw new ArgumentOutOfRangeException("index", "The specified index lies out of the entries length.");
        }
        return this.a[index];
    }

    @Override
    public Color getColor(int index) {
        return Color.fromArgb(this.getArgb32Color(index));
    }
}

