/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.rendering;

import com.aspose.pdf.internal.html.dom.Document;
import com.aspose.pdf.internal.html.dom.Element;
import com.aspose.pdf.internal.html.io.ICreateStreamProvider;
import com.aspose.pdf.internal.html.l0l;
import com.aspose.pdf.internal.html.rendering.GraphicContext;
import com.aspose.pdf.internal.html.rendering.IDevice;
import com.aspose.pdf.internal.html.rendering.RenderingOptions;
import com.aspose.pdf.internal.l26y.l0k;
import com.aspose.pdf.internal.l26y.l1v;
import com.aspose.pdf.internal.l68l.l13h;
import com.aspose.pdf.internal.l68l.l14p;
import com.aspose.pdf.internal.l68l.l2t;
import com.aspose.pdf.internal.l69h.le;
import com.aspose.pdf.internal.ms.System.Collections.Generic.l2l;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.IO.l0if;
import com.aspose.pdf.internal.ms.System.IO.l1y;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l4v;
import com.aspose.pdf.internal.ms.System.l5f;
import com.aspose.pdf.internal.ms.System.l5p;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Device<TGraphicContext extends GraphicContext, TRenderingOptions extends RenderingOptions>
implements IDevice {
    private final l2l<TGraphicContext> _contextStack = new l2l();
    private TRenderingOptions auto_Options;
    private ICreateStreamProvider auto_StreamProvider;
    private Stream _outputStream;
    private int auto_PageIndex;
    private Document auto_CurrentDocument;

    protected Device(TRenderingOptions options, ICreateStreamProvider streamProvider, Class<? extends GraphicContext> clazz) {
        this.setOptions(((RenderingOptions)options).deepClone());
        this.setStreamProvider(streamProvider);
    }

    protected Device(TRenderingOptions options, String file, Class<? extends GraphicContext> clazz) {
        this(options, new lt(file), clazz);
    }

    protected Device(TRenderingOptions options, Stream stream, Class<? extends GraphicContext> clazz) {
        this(options, new lb(stream), clazz);
    }

    protected Device(TRenderingOptions options, InputStream stream, Class<? extends GraphicContext> clazz) {
        this(options, new lb(Stream.fromJava(stream)), clazz);
    }

    public Device(TRenderingOptions options, OutputStream outputStream, Class<? extends GraphicContext> clazz) {
        this(options, new lf(outputStream), clazz);
    }

    protected void initialize(Class<? extends GraphicContext> clazz) {
        try {
            this._contextStack.lj();
            this._contextStack.lf(clazz.newInstance());
            this.setPageIndex(0);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception caught: ", exception);
        }
    }

    public TRenderingOptions getOptions_Rename_Namesake() {
        return this.auto_Options;
    }

    @Override
    public RenderingOptions getOptions() {
        return this.getOptions_Rename_Namesake();
    }

    private void setOptions(TRenderingOptions value) {
        this.auto_Options = value;
    }

    protected lI getConfiguration() {
        lI lI2 = new lI();
        lI2.lI(0);
        return lI2;
    }

    public TGraphicContext getGraphicContext() {
        return (TGraphicContext)((GraphicContext)this._contextStack.lt());
    }

    protected ICreateStreamProvider getStreamProvider() {
        return this.auto_StreamProvider;
    }

    private void setStreamProvider(ICreateStreamProvider value) {
        this.auto_StreamProvider = value;
    }

    protected Stream getOutputStream() {
        return this._outputStream;
    }

    private void setOutputStream(Stream value) {
        this._outputStream = value == null ? null : new l0l(value);
    }

    public Stream getOriginalOutputStream() {
        l0l l0l2 = (l0l)((Object)com.aspose.pdf.internal.l82h.lb.lI(this._outputStream, l0l.class));
        if (l0l2 != null) {
            return l0l2.lI();
        }
        return this._outputStream;
    }

    @Override
    public void saveGraphicContext() {
        this._contextStack.lf(((GraphicContext)this._contextStack.lt()).deepClone());
    }

    @Override
    public void restoreGraphicContext() {
        if (this._contextStack.size() > 1) {
            this._contextStack.lb();
        }
    }

    protected int getPageIndex() {
        return this.auto_PageIndex;
    }

    protected void setPageIndex(int value) {
        this.auto_PageIndex = value;
    }

    public Document getCurrentDocument() {
        return this.auto_CurrentDocument;
    }

    public void setCurrentDocument(Document value) {
        this.auto_CurrentDocument = value;
    }

    protected abstract String getExtension();

    @Override
    public void beginDocument(Document document, Class<? extends GraphicContext> clazz) {
        this.initialize(clazz);
        this.setCurrentDocument(document);
        if (this.getConfiguration().lI() == 0) {
            String string = "about".equals(this.getCurrentDocument().getContext().getWindow().getLocation().getProtocol()) ? "document" : l1y.lf(this.getCurrentDocument().getDocumentURI());
            this.setOutputStream(this.getStreamProvider().getStream(string, this.getExtension()));
        }
    }

    @Override
    public void endDocument() {
        if (this.getConfiguration().lI() == 0) {
            l5f l5f2 = (l5f)((l1v)l0k.lI("Func4<Document, Stream, IDevice, IDisposable>")).lI(this.getCurrentDocument(), com.aspose.pdf.internal.l82h.lb.lI(this.getOutputStream(), l0l.class), this);
            if (l5f2 != null) {
                l5f2.dispose();
            }
            this.getStreamProvider().releaseStream(this.getOriginalOutputStream());
            this.setOutputStream(null);
        }
        this.setCurrentDocument(null);
    }

    @Override
    public void beginPage(l14p size) {
        this.setPageIndex(this.getPageIndex() + 1);
        if (this.getConfiguration().lI() == 1) {
            String string = "about".equals(this.getCurrentDocument().getContext().getWindow().getLocation().getProtocol()) ? "document" : l1y.lf(this.getCurrentDocument().getDocumentURI());
            this.setOutputStream(this.getStreamProvider().getStream(string, this.getExtension(), this.getPageIndex()));
        }
    }

    @Override
    public void endPage() {
        if (this.getConfiguration().lI() == 1) {
            l5f l5f2 = (l5f)((l1v)l0k.lI("Func4<Document, Stream, IDevice, IDisposable>")).lI(this.getCurrentDocument(), com.aspose.pdf.internal.l82h.lb.lI(this.getOutputStream(), l0l.class), this);
            if (l5f2 != null) {
                l5f2.dispose();
            }
            this.getStreamProvider().releaseStream(this.getOriginalOutputStream());
            this.setOutputStream(null);
        }
    }

    @Override
    public abstract boolean beginElement(Element var1, l13h var2);

    @Override
    public abstract void endElement(Element var1);

    @Override
    public abstract void closePath();

    @Override
    public abstract void moveTo(l2t var1);

    @Override
    public abstract void lineTo(l2t var1);

    @Override
    public abstract void addRect(l13h var1);

    @Override
    public abstract void cubicBezierTo(l2t var1, l2t var2, l2t var3);

    @Override
    public abstract void stroke();

    @Override
    public abstract void fill(int var1);

    @Override
    public abstract void clip(int var1);

    @Override
    public abstract void strokeAndFill(int var1);

    @Override
    public abstract void fillText(String var1, l2t var2);

    @Override
    public abstract void strokeText(String var1, l2t var2);

    @Override
    public abstract void drawImage(byte[] var1, int var2, l13h var3);

    @Override
    public void dispose() {
        this.dispose(true);
        l5p.lI(this);
    }

    protected void dispose(boolean disposing) {
    }

    private static class lf
    extends Stream {
        private OutputStream lI;

        public lf(OutputStream outputStream) {
            this.lI = outputStream;
        }

        @Override
        public boolean canRead() {
            return false;
        }

        @Override
        public boolean canSeek() {
            return false;
        }

        @Override
        public boolean canWrite() {
            return true;
        }

        @Override
        protected void lI(boolean bl) {
            try {
                if (this.lI != null) {
                    this.lI.close();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
            finally {
                this.lI = null;
                super.lI(bl);
            }
        }

        @Override
        public void flush() {
            try {
                this.lI.flush();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
        }

        @Override
        public long getLength() {
            return 0L;
        }

        @Override
        public long getPosition() {
            return 0L;
        }

        @Override
        public int read(@com.aspose.pdf.internal.l69h.lt @le byte[] arg0, int arg1, int arg2) {
            return 0;
        }

        @Override
        public long seek(long arg0, int arg1) {
            return 0L;
        }

        @Override
        public void setLength(long arg0) {
        }

        @Override
        public void setPosition(long arg0) {
        }

        @Override
        public void write(byte[] b, int off, int len) {
            try {
                this.lI.write(b, off, len);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
        }
    }

    public static final class lj
    extends l4v {
        public static final int lI = 0;
        public static final int lf = 1;

        private lj() {
        }

        static {
            l4v.register(new l4v.lb((Class)lj.class, Integer.class){
                {
                    this.lI("SingleStream", 0L);
                    this.lI("MultipleStreams", 1L);
                }
            });
        }
    }

    public static class lI {
        private int lI;

        public int lI() {
            return this.lI;
        }

        public void lI(int n) {
            this.lI = n;
        }
    }

    private static class lb
    implements ICreateStreamProvider {
        private Stream lI;

        public lb(Stream stream) {
            this.lI = stream;
        }

        @Override
        public Stream getStream(String name, String extension) {
            return this.lI;
        }

        @Override
        public Stream getStream(String name, String extension, int page) {
            return this.lI;
        }

        @Override
        public void releaseStream(Stream stream) {
        }

        @Override
        public void dispose() {
            this.lI = null;
        }
    }

    private static class lt
    implements ICreateStreamProvider {
        private String lI;
        private String lf;
        private String lj;

        public lt(String string) {
            this.lI = l1y.ld(string);
            this.lf = l1y.lf(string);
            this.lj = l1y.lb(string);
        }

        @Override
        public Stream getStream(String name, String extension) {
            String string = this.lf;
            if (string == null) {
                string = name;
            }
            name = string;
            String string2 = this.lj;
            if (string2 == null) {
                string2 = extension;
            }
            extension = string2;
            String string3 = l10l.lI("{0}{1}", new Object[]{name, extension});
            return l0if.lf(l1y.lf(this.lI, string3));
        }

        @Override
        public Stream getStream(String name, String extension, int page) {
            String string = this.lf;
            if (string == null) {
                string = name;
            }
            name = string;
            String string2 = this.lj;
            if (string2 == null) {
                string2 = extension;
            }
            extension = string2;
            String string3 = l10l.lI("{0}_{1}{2}", name, com.aspose.pdf.internal.l82h.lb.lI(page), extension);
            return l0if.lf(l1y.lf(this.lI, string3));
        }

        @Override
        public void releaseStream(Stream stream) {
            if (stream != null) {
                stream.dispose();
            }
        }

        @Override
        public void dispose() {
        }
    }
}

