/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.forms;

import com.aspose.pdf.internal.html.HTMLButtonElement;
import com.aspose.pdf.internal.html.HTMLDocument;
import com.aspose.pdf.internal.html.HTMLElement;
import com.aspose.pdf.internal.html.HTMLFormElement;
import com.aspose.pdf.internal.html.HTMLInputElement;
import com.aspose.pdf.internal.html.HTMLObjectElement;
import com.aspose.pdf.internal.html.HTMLOptionElement;
import com.aspose.pdf.internal.html.HTMLSelectElement;
import com.aspose.pdf.internal.html.HTMLTextAreaElement;
import com.aspose.pdf.internal.html.Url;
import com.aspose.pdf.internal.html.dom.Element;
import com.aspose.pdf.internal.html.dom.lI;
import com.aspose.pdf.internal.html.forms.FormEditor;
import com.aspose.pdf.internal.html.forms.SubmissionResult;
import com.aspose.pdf.internal.html.io.lf;
import com.aspose.pdf.internal.html.net.ByteArrayContent;
import com.aspose.pdf.internal.html.net.Content;
import com.aspose.pdf.internal.html.net.FormUrlEncodedContent;
import com.aspose.pdf.internal.html.net.HttpMethod;
import com.aspose.pdf.internal.html.net.MultipartFormDataContent;
import com.aspose.pdf.internal.html.net.RequestMessage;
import com.aspose.pdf.internal.html.net.StringContent;
import com.aspose.pdf.internal.l26y.l0k;
import com.aspose.pdf.internal.l26y.l1t;
import com.aspose.pdf.internal.l26y.l3v;
import com.aspose.pdf.internal.l46j.lt;
import com.aspose.pdf.internal.l67h.l0t;
import com.aspose.pdf.internal.l70y.l0p;
import com.aspose.pdf.internal.l70y.l1j;
import com.aspose.pdf.internal.l82h.lb;
import com.aspose.pdf.internal.l82h.lh;
import com.aspose.pdf.internal.ms.System.Collections.Generic.lk;
import com.aspose.pdf.internal.ms.System.Collections.Generic.ly;
import com.aspose.pdf.internal.ms.System.IO.l1y;
import com.aspose.pdf.internal.ms.System.Net.l0y;
import com.aspose.pdf.internal.ms.System.Net.l7n;
import com.aspose.pdf.internal.ms.System.l10j;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l5f;
import com.aspose.pdf.internal.ms.System.l7k;
import com.aspose.pdf.internal.ms.System.l8t;
import com.aspose.pdf.internal.ms.System.le;

public class FormSubmitter
implements l5f {
    private static final lh gStringSwitchMap = new lh("application/x-www-form-urlencoded", "multipart/form-data", "text/plain");
    private HTMLFormElement _form;
    private HttpMethod _method;
    private String _action;
    private SubmissionResult lastResult;

    public FormSubmitter(HTMLFormElement form) {
        this._form = form;
    }

    public FormSubmitter(HTMLDocument document, int index) {
        HTMLFormElement hTMLFormElement = (HTMLFormElement)((Object)lb.lI(document.getForms().get_Item(index), HTMLFormElement.class));
        if (hTMLFormElement == null) {
            throw com.aspose.pdf.internal.l31k.lI.lI().lf("IndexSizeError");
        }
        this._form = hTMLFormElement;
    }

    public FormSubmitter(HTMLDocument document, String id) {
        Element element = document.getElementById(id);
        if (element == null) {
            throw com.aspose.pdf.internal.l31k.lI.lI().lf("NotFoundError");
        }
        HTMLFormElement hTMLFormElement = (HTMLFormElement)((Object)lb.lI(element, HTMLFormElement.class));
        if (hTMLFormElement == null) {
            throw com.aspose.pdf.internal.l31k.lI.lI().lf("TypeMismatchError");
        }
        this._form = hTMLFormElement;
    }

    public FormSubmitter(FormEditor editor) {
        this._form = editor.getForm();
    }

    private static String normalizeLineBreaks(String input) {
        l1j l1j2 = new l1j(lb.lb((Object)((double)input.length() * 1.1), 14));
        boolean bl = false;
        block4: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (bl) {
                bl = false;
                if (c == '\n') continue;
            }
            switch (c) {
                case '\r': {
                    l1j2.lI("\r\n");
                    bl = true;
                    continue block4;
                }
                case '\n': {
                    l1j2.lI("\r\n");
                    continue block4;
                }
                default: {
                    l1j2.lI(c);
                }
            }
        }
        return l1j2.toString();
    }

    public HttpMethod getMethod() {
        if (this._method == null) {
            if (!l10l.lf(this._form.getMethod())) {
                return new HttpMethod(this._form.getMethod());
            }
            return HttpMethod.getGet();
        }
        return this._method;
    }

    public void setMethod(HttpMethod value) {
        this._method = value;
    }

    public String getAction() {
        if (this._action == null) {
            return this._form.getAction();
        }
        return this._action;
    }

    public void setAction(String value) {
        this._action = value;
    }

    public SubmissionResult submit() {
        return this.submit(l0y.lI(), l10j.lt(100.0).l0if(), false);
    }

    public SubmissionResult submit(l7n credentials) {
        return this.submit(credentials, l10j.lt(100.0).l0if(), true);
    }

    public SubmissionResult submit(l10j timeout) {
        return this.submit(l0y.lI(), timeout.l0if(), false);
    }

    public SubmissionResult submit(l7n credentials, l10j timeout) {
        return this.submit(credentials, timeout.l0if(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubmissionResult submit(l7n credentials, l10j timeout, boolean preAuthenticate) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        HttpMethod httpMethod;
        Object object5;
        HTMLDocument hTMLDocument = (HTMLDocument)this._form.getOwnerDocument();
        if ((hTMLDocument.getContext().getSecurity() & 0x20) == 32) {
            return null;
        }
        HTMLElement hTMLElement = this.getSubmitButton();
        Object object6 = this.getAction();
        if (l10l.lf((String)object6)) {
            object6 = hTMLDocument.getDocumentURI();
        }
        if (hTMLElement != null && !l10l.lf((String)(object5 = hTMLElement.getAttribute("formaction")))) {
            object6 = object5;
        }
        object5 = new Url((String)object6, hTMLDocument.getBaseURI());
        com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<l3v<String, lI, String>> l0t2 = this.getDataSetFromForm(hTMLElement);
        l5f l5f2 = (l5f)((l1t)l0k.lI("Func3<Document, List<Tuple3<String, Value, String>>, IDisposable>")).lI(this._form.getOwnerDocument(), l0t2);
        try {
            lt lt2 = ((Url)object5).UrlRecord.le;
            if (!lI.lh.lt.lf(lt2) && !lI.lh.lb.lf(lt2)) {
                throw new l7k(l10l.lI("Scheme {0} is not supported.", new Object[]{lt2}));
            }
            httpMethod = this.getMethodFromSubmitter(hTMLElement);
            string = this.getEnctypeFromSubmitter(hTMLElement);
        }
        finally {
            if (l5f2 != null) {
                l5f2.dispose();
            }
        }
        if (HttpMethod.op_Equality(HttpMethod.getGet(), httpMethod)) {
            ((Url)object5).UrlRecord.lI = new com.aspose.pdf.internal.l46n.lf().lI(l0t2);
            RequestMessage requestMessage = new RequestMessage((Url)object5);
            requestMessage.setMethod(HttpMethod.getGet());
            requestMessage.setCredentials(credentials);
            requestMessage.setPreAuthenticate(true);
            this.lastResult = new SubmissionResult(requestMessage, this._form.getOwnerDocument().getContext().getNetwork().send(requestMessage), this._form);
            return this.lastResult;
        }
        l0p l0p2 = this.pickEncodingForForm();
        com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<ly<String, String>> l0t3 = new com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<ly<String, String>>();
        switch (gStringSwitchMap.lI(string)) {
            case 0: {
                object4 = l0t2.iterator();
                try {
                    while (object4.hasNext()) {
                        object3 = (l3v)object4.next();
                        object2 = ((lI)((l3v)object3).lf()).lj();
                        if (!l10l.lf((String)((l3v)object3).lj()) && "hidden".equals(((l3v)object3).lj()) && "_charset_".equals(((l3v)object3).lI())) {
                            object2 = this.pickEncodingForForm().lc();
                        }
                        l0t3.addItem(new ly(((l3v)object3).lI(), object2));
                    }
                }
                finally {
                    if (lb.lf(object4, l5f.class)) {
                        ((l5f)object4).dispose();
                    }
                }
                object = new FormUrlEncodedContent(l0t3);
                break;
            }
            case 1: {
                object4 = l0p2.lc();
                object3 = new MultipartFormDataContent();
                object2 = l0t2.iterator();
                try {
                    while (object2.hasNext()) {
                        l3v l3v2 = (l3v)object2.next();
                        byte[] byArray = ((lI)l3v2.lf()).lt();
                        if (!l10l.lf((String)l3v2.lj()) && "hidden".equals(l3v2.lj()) && "_charset_".equals(l3v2.lI())) {
                            byArray = com.aspose.pdf.internal.html.dom.lI.lI.lj((String)object4);
                        }
                        ByteArrayContent byteArrayContent = new ByteArrayContent(byArray);
                        if ("file".equals(l3v2.lj())) {
                            String string2 = l1y.lI(((lI)l3v2.lf()).lI());
                            ((MultipartFormDataContent)object3).add(byteArrayContent, (String)l3v2.lI(), string2);
                            continue;
                        }
                        ((MultipartFormDataContent)object3).add(byteArrayContent, (String)l3v2.lI());
                    }
                }
                finally {
                    if (lb.lf(object2, l5f.class)) {
                        ((l5f)object2).dispose();
                    }
                }
                object = object3;
                break;
            }
            case 2: {
                object4 = l0t2.iterator();
                try {
                    while (object4.hasNext()) {
                        object3 = (l3v)object4.next();
                        object2 = ((lI)((l3v)object3).lf()).lj();
                        if (!l10l.lf((String)((l3v)object3).lj()) && "hidden".equals(((l3v)object3).lj()) && "_charset_".equals(((l3v)object3).lI())) {
                            object2 = l0p2.lc();
                        }
                        l0t3.addItem(new ly(((l3v)object3).lI(), object2));
                    }
                }
                finally {
                    if (lb.lf(object4, l5f.class)) {
                        ((l5f)object4).dispose();
                    }
                }
                object3 = new l1j();
                object2 = l0t3.iterator();
                try {
                    while (object2.hasNext()) {
                        ly ly2 = (ly)object2.next();
                        ((l1j)object3).lI((String)ly2.lI());
                        ((l1j)object3).lI('=');
                        ((l1j)object3).lI((String)ly2.lf());
                        ((l1j)object3).lI("\r\n");
                    }
                }
                finally {
                    if (lb.lf(object2, l5f.class)) {
                        ((l5f)object2).dispose();
                    }
                }
                object = new StringContent(((l1j)object3).toString(), l0p2);
                break;
            }
            default: {
                throw new le(l10l.lI("The enctype '{0}' is not supported while submitting data to the server.", new Object[]{string}));
            }
        }
        object4 = (l5f)((l1t)l0k.lI("Func3<Document, Stream, IDisposable>")).lI(this._form.getOwnerDocument(), ((Content)object).readAsStream());
        try {
            object3 = new RequestMessage((Url)object5);
            ((RequestMessage)object3).setMethod(httpMethod);
            ((RequestMessage)object3).setContent((Content)object);
            ((RequestMessage)object3).setCredentials(credentials);
            ((RequestMessage)object3).setPreAuthenticate(preAuthenticate);
            ((RequestMessage)object3).setTimeout(timeout.l0if());
            this.lastResult = new SubmissionResult((RequestMessage)object3, this._form.getOwnerDocument().getContext().getNetwork().send((RequestMessage)object3), this._form);
            object2 = this.lastResult;
            return object2;
        }
        finally {
            if (object4 != null) {
                object4.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTMLElement getSubmitButton() {
        l0t l0t2 = this._form.getElements().iterator();
        try {
            while (l0t2.hasNext()) {
                Element element = (Element)l0t2.next();
                if (!l8t.lf(element.getTag(), lI.le.l6j) || !l10l.lt("submit", ((HTMLInputElement)element).getType(), (short)5)) continue;
                HTMLElement hTMLElement = (HTMLElement)element;
                return hTMLElement;
            }
        }
        finally {
            if (lb.lf((Object)l0t2, l5f.class)) {
                ((l5f)((Object)l0t2)).dispose();
            }
        }
        return null;
    }

    private HttpMethod getMethodFromSubmitter(HTMLElement submitter) {
        String string;
        if (submitter != null && !l10l.lf(string = submitter.getAttribute("formethod"))) {
            return new HttpMethod(string);
        }
        return this.getMethod();
    }

    private String getEnctypeFromSubmitter(HTMLElement submitter) {
        String string;
        if (submitter != null && !l10l.lf(string = submitter.getAttribute("formenctype"))) {
            return l10l.lu(string);
        }
        return l10l.lu(this._form.getEnctype());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<l3v<String, lI, String>> getDataSetFromForm(HTMLElement submitter) {
        com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<HTMLElement> l0t2 = this.getSubmittableElements(submitter);
        com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<l3v<String, lI, String>> l0t3 = new com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<l3v<String, lI, String>>();
        lk lk2 = l0t2.iterator();
        try {
            while (lk2.hasNext()) {
                l5f l5f2;
                Object object;
                l5f l5f3;
                HTMLElement hTMLElement = (HTMLElement)lk2.next();
                String string = this.getTypeOfField(hTMLElement);
                if ("image".equals(string)) continue;
                String string2 = hTMLElement.getAttribute("name");
                if (l8t.lf(hTMLElement.getTag(), lI.le.l6y)) {
                    l5f3 = ((HTMLSelectElement)hTMLElement).getOptions().iterator();
                    try {
                        while (l5f3.hasNext()) {
                            object = (Element)l5f3.next();
                            l5f2 = (HTMLOptionElement)object;
                            if (!((HTMLOptionElement)l5f2).getSelected() || ((HTMLOptionElement)l5f2).getDisabled()) continue;
                            l0t3.addItem(new l3v<String, lI, String>(string2, lI.lI(((HTMLOptionElement)l5f2).getValue()), string));
                        }
                        continue;
                    }
                    finally {
                        if (!lb.lf((Object)l5f3, l5f.class)) continue;
                        l5f3.dispose();
                        continue;
                    }
                }
                if (l8t.lf(hTMLElement.getTag(), lI.le.l6j)) {
                    l5f3 = (HTMLInputElement)hTMLElement;
                    if ("checkbox".equals(((HTMLInputElement)l5f3).getType()) || "radio".equals(((HTMLInputElement)l5f3).getType())) {
                        object = "on";
                        if (hTMLElement.hasAttribute("value")) {
                            object = ((HTMLInputElement)hTMLElement).getValue();
                        }
                        l0t3.addItem(new l3v<String, lI, String>(string2, lI.lI((String)object), string));
                        continue;
                    }
                    if ("file".equals(((HTMLInputElement)l5f3).getType())) {
                        boolean bl = false;
                        l5f2 = ((HTMLInputElement)hTMLElement).getFiles().iterator();
                        try {
                            while (l5f2.hasNext()) {
                                lf lf2 = (lf)l5f2.next();
                                l0t3.addItem(new l3v<String, lI, String>(string2, lI.lI(lf2), string));
                                bl = true;
                            }
                        }
                        finally {
                            if (lb.lf((Object)l5f2, l5f.class)) {
                                l5f2.dispose();
                            }
                        }
                        if (bl) continue;
                        l0t3.addItem(new l3v<String, lI, String>(string2, lI.lI(l10l.lI), "application/octet-stream"));
                        continue;
                    }
                    l0t3.addItem(new l3v<String, lI, String>(string2, lI.lI(((HTMLInputElement)hTMLElement).getValue()), string));
                    continue;
                }
                if (l8t.lf(hTMLElement.getTag(), lI.le.l7if)) {
                    l0t3.addItem(new l3v<String, lI, String>(string2, lI.lI(((HTMLTextAreaElement)hTMLElement).getValue()), string));
                    continue;
                }
                if (l8t.lf(hTMLElement.getTag(), lI.le.l4k)) continue;
                l0t3.addItem(new l3v<String, lI, String>(string2, lI.lI(((HTMLInputElement)hTMLElement).getValue()), string));
            }
        }
        finally {
            if (lb.lf((Object)lk2, l5f.class)) {
                ((l5f)lk2).dispose();
            }
        }
        int n = 0;
        while (n < l0t3.size()) {
            if (!"file".equals(l0t3.get_Item(n).lj()) && !"textarea".equals(l0t3.get_Item(n).lj())) {
                l0t3.set_Item(n, new l3v<String, lI, String>(FormSubmitter.normalizeLineBreaks(l0t3.get_Item(n).lI()), lI.lI(FormSubmitter.normalizeLineBreaks(l0t3.get_Item(n).lf().lj())), l0t3.get_Item(n).lj()));
            }
            ++n;
        }
        return l0t3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<HTMLElement> getSubmittableElements(HTMLElement submitter) {
        com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<HTMLElement> l0t2 = new com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<HTMLElement>();
        l0t l0t3 = this._form.getElements().iterator();
        try {
            while (l0t3.hasNext()) {
                Element element = (Element)l0t3.next();
                if (!l8t.lf(element.getTag(), lI.le.l6j) && !l8t.lf(element.getTag(), lI.le.l4k) && !l8t.lf(element.getTag(), lI.le.l6y) && !l8t.lf(element.getTag(), lI.le.l7if) || !this.isValidElementToSubmit((HTMLElement)element, submitter)) continue;
                l0t2.addItem((HTMLElement)element);
            }
        }
        finally {
            if (lb.lf((Object)l0t3, l5f.class)) {
                ((l5f)((Object)l0t3)).dispose();
            }
        }
        return l0t2;
    }

    private boolean isValidElementToSubmit(HTMLElement element, HTMLElement submitter) {
        if (l8t.lf(element.getParentElement().getTag(), lI.le.l6n)) {
            return false;
        }
        if (element.hasAttribute("disabled")) {
            return false;
        }
        if (l8t.lf(element.getTag(), lI.le.l6h) && !element.equals(submitter)) {
            return true;
        }
        if (l8t.lf(element.getTag(), lI.le.l6j)) {
            HTMLInputElement hTMLInputElement = (HTMLInputElement)element;
            if ("checkbox".equals(l10l.lu(hTMLInputElement.getType())) && !hTMLInputElement.getChecked()) {
                return false;
            }
            if ("radio".equals(l10l.lu(hTMLInputElement.getType())) && !hTMLInputElement.getChecked() && hTMLInputElement.getValue() != null && !"checked".equals(l10l.lu(hTMLInputElement.getValue()))) {
                return false;
            }
            if (!"image".equals(hTMLInputElement.getType()) && l10l.lf(hTMLInputElement.getAttribute("name"))) {
                return false;
            }
        }
        return !l8t.lf(element.getTag(), lI.le.l7if) || !l10l.lf(element.getAttribute("name"));
    }

    private String getTypeOfField(HTMLElement element) {
        if (lb.lf((Object)element, HTMLInputElement.class)) {
            return ((HTMLInputElement)element).getType();
        }
        if (lb.lf((Object)element, HTMLSelectElement.class)) {
            return ((HTMLSelectElement)element).getType();
        }
        if (lb.lf((Object)element, HTMLButtonElement.class)) {
            return ((HTMLButtonElement)element).getType();
        }
        if (lb.lf((Object)element, HTMLObjectElement.class)) {
            return ((HTMLObjectElement)element).getType();
        }
        if (lb.lf((Object)element, HTMLTextAreaElement.class)) {
            return ((HTMLTextAreaElement)element).getType();
        }
        return l10l.lI;
    }

    private l0p pickEncodingForForm() {
        if (this._form.hasAttribute("accept-charset")) {
            String[] stringArray;
            String string = this._form.getAttribute("accept-charset");
            for (String string2 : stringArray = l10l.lI(string, new String[]{" "}, 1)) {
                try {
                    return l0p.lt(string2);
                }
                catch (RuntimeException runtimeException) {
                }
            }
        }
        return com.aspose.pdf.internal.html.dom.lI.lI;
    }

    @Override
    public void dispose() {
        this._form = null;
        if (this.lastResult != null) {
            this.lastResult.dispose();
            this.lastResult = null;
        }
    }

    public static abstract class com.aspose.pdf.internal.html.forms.FormSubmitter$lI {
        public static final int lI = 1;
        public static final int lf = 2;

        public static com.aspose.pdf.internal.html.forms.FormSubmitter$lI lI(com.aspose.pdf.internal.html.io.lf lf2) {
            return new lI(lf2);
        }

        public static com.aspose.pdf.internal.html.forms.FormSubmitter$lI lI(String string) {
            return new lf(string);
        }

        public String lI() {
            return l10l.lI;
        }

        public abstract int lf();

        public abstract String lj();

        public abstract byte[] lt();

        private static class lf
        extends com.aspose.pdf.internal.html.forms.FormSubmitter$lI {
            private String lj;

            public lf(String string) {
                this.lj = string;
            }

            @Override
            public String lj() {
                return this.lj;
            }

            @Override
            public byte[] lt() {
                return l0p.l0k().lj(this.lj);
            }

            @Override
            public int lf() {
                return 1;
            }
        }

        private static class lI
        extends com.aspose.pdf.internal.html.forms.FormSubmitter$lI {
            private com.aspose.pdf.internal.html.io.lf lj;

            public lI(com.aspose.pdf.internal.html.io.lf lf2) {
                this.lj = lf2;
            }

            @Override
            public String lj() {
                return this.lj.toString();
            }

            @Override
            public byte[] lt() {
                return this.lj.lI();
            }

            @Override
            public String lI() {
                return this.lj.getName();
            }

            @Override
            public int lf() {
                return 2;
            }
        }
    }
}

